/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
class UiBotModelBuildZTBTransportScheduleStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    UiBotModelBuildZTBTransportScheduleStrategy() {
    }

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        String transportNo = apiRequest.getDataId();
        ArrayList<UiBotLayout> newLayoutList = new ArrayList<UiBotLayout>();
        List scheduleList = this.digiwinEspProxyService.getShippingSchedule(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "${CARD}": {
                    if (CollectionUtils.isEmpty((Collection)scheduleList)) break;
                    scheduleList.forEach(schedule -> {
                        Card card = new Card();
                        card.setTitle((String)schedule.get("arrival_desc"));
                        ArrayList<CardContent> content = new ArrayList<CardContent>();
                        CardContent deliveryCardContent = new CardContent();
                        deliveryCardContent.setLabel(this.localeService.getLanguageValue(locale, "\u8d77\u70b9"));
                        deliveryCardContent.setValue((String)schedule.get("delivery_address"));
                        deliveryCardContent.setValueStyleType(Integer.valueOf(1));
                        content.add(deliveryCardContent);
                        CardContent receiptCardContent = new CardContent();
                        receiptCardContent.setLabel(this.localeService.getLanguageValue(locale, "\u7ec8\u70b9"));
                        receiptCardContent.setValue((String)schedule.get("receipt_address"));
                        receiptCardContent.setValueStyleType(Integer.valueOf(1));
                        content.add(receiptCardContent);
                        CardContent receiverNameCardContent = new CardContent();
                        receiverNameCardContent.setLabel(this.localeService.getLanguageValue(locale, "\u8054\u7cfb\u4eba"));
                        receiverNameCardContent.setValue((String)schedule.get("receiver_name"));
                        receiverNameCardContent.setValueStyleType(Integer.valueOf(1));
                        content.add(receiverNameCardContent);
                        CardContent receiverMobileCardContent = new CardContent();
                        receiverMobileCardContent.setLabel(this.localeService.getLanguageValue(locale, "\u8054\u7cfb\u7535\u8bdd"));
                        receiverMobileCardContent.setValue((String)schedule.get("receiver_mobile"));
                        receiverMobileCardContent.setValueStyleType(Integer.valueOf(1));
                        receiverMobileCardContent.setType("PHONE");
                        content.add(receiverMobileCardContent);
                        card.setContent(content);
                        String cardSchema = UUIDUtil.getUuid();
                        UiBotLayout cardLayout = new UiBotLayout();
                        cardLayout.setSchema(cardSchema);
                        cardLayout.setType("CARD");
                        newLayoutList.add(cardLayout);
                        pageData.put((Object)cardSchema, (Object)card);
                    });
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, bottomButtonDigiwinAthena.getName())));
                    newLayoutList.add(layout);
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        uiBotModel.setLayout(newLayoutList);
        return uiBotModel;
    }
}

