/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBTransportShiftingAbnormalAlarmStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "INPUT_SINGLE": {
                    InputSingleText singleText = InputSingleText.create((String)schema, (String)((String)layout.getmLabelText().get(locale)), (Boolean)false, (Boolean)true, (String)locale, (String)"", (Boolean)false);
                    if (StrUtil.equals((CharSequence)schema, (CharSequence)"licensePlateNo")) {
                        singleText.setInputType(InputTypeEnum.INPUT_LICENSE_PLAT.getValue());
                    }
                    pageData.put((Object)schema, (Object)singleText);
                    break;
                }
                case "INPUT_NUMERIC": {
                    InputNumeric inputNumeric = InputNumeric.create((Integer)11, (Integer)0, (String)"", (String)((String)layout.getmLabelText().get(locale)), (Integer)InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setRequired(Boolean.valueOf(false));
                    pageData.put((Object)schema, (Object)inputNumeric);
                    break;
                }
                case "INPUT_MULTI": {
                    pageData.put((Object)schema, (Object)InputMultiText.create((String)schema, (String)((String)layout.getmLabelText().get(locale)), (String)"", (Boolean)true, (Boolean)false, (Boolean)false, (String)locale));
                    break;
                }
                case "BUTTON_SINGLE_SELECT": {
                    pageData.put((Object)schema, (Object)ButtonSingleSelect.createByZtbShiftingAbnormalAlarm((UiBotLayout)layout, (String)locale, (Boolean)false));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                        if (ActionTypeEnum.CALL_API.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            Map<String, Object> buttonRawData = ObjectUtil.isEmpty((Object)action.getRawData()) ? new HashMap() : (Map)action.getRawData();
                            Object buttonActionId = buttonRawData.get("action_id");
                            if (StrUtil.equals((CharSequence)StrUtil.toString(buttonRawData.get("action_id")), (CharSequence)"cancel")) {
                                bottomButtonDigiwinAthena.setIsCheckButton(Boolean.valueOf(false));
                            }
                            buttonRawData.put("transport_no", rawData.get((Object)"transport_no"));
                            buttonRawData.put("task_no", rawData.get((Object)"task_no"));
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get((Object)"action"));
                            buttonRawData.put("data", rawData.get((Object)"data"));
                            buttonRawData.put("notValidInput", true);
                            buttonRawData.put("action_id", "shifting");
                            buttonRawData.put("button_action_id", buttonActionId);
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

