/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.recommend.rule;

import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRule;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleParamsTypeEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="recommendRuleService")
public class RecommendRuleServiceImpl
implements RecommendRuleService {
    private static final Logger logger = LoggerFactory.getLogger(RecommendRuleServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<RecommendRule> findRuleByCategory(String category) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)category));
        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    public List<RecommendRule> findRulePurchasedGoods() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"paramsType").is((Object)RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()));
        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    public List<RecommendRule> findRulePurchasedGoodsByCategory(String category) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)category));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"paramsType").is((Object)RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()));
        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    public List<RecommendRule> findRuleByCategoryList(List<String> categoryList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").in(categoryList));
        return this.mongoTemplate.find(query, RecommendRule.class);
    }
}

