/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.sso;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtils;
import com.digiwin.mobile.mobileuibot.common.crypto.rsa.RSAUtils;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigIwinCamResponse;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.IamAuth;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAddJoinTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.model.ProxyRefreshTenant;
import com.digiwin.mobile.mobileuibot.sso.dto.DigiwinAppStandardSsoQueryDTO;
import com.digiwin.mobile.mobileuibot.sso.dto.ThirdPartyLoginFreeQueryDTO;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoMongoKeyEnum;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.sso.model.EnvironmentalConfiguration;
import com.digiwin.mobile.mobileuibot.sso.model.SsoConfigModel;
import com.digiwin.mobile.mobileuibot.sso.model.ThirdPartyForParticipationRequestModel;
import com.digiwin.mobile.mobileuibot.sso.service.SsoService;
import com.digiwin.mobile.mobileuibot.sso.utils.HttpRequestDeviceUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/mobile/v1/sso"})
public class SsoController {
    private static final Logger log = LoggerFactory.getLogger(SsoController.class);
    public static final String THIRD_PARTY_SSO_SECRET_KEY = "OkTLr7+ZtjyoGyEM";
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    private static LocaleService localeService;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static DigiwinIamProxyService iamProxyService;
    private static DigiwinAtmcProxyService atmcProxyService;
    private static PageTaskRelationService pageTaskRelationService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigIwinCamProxyService camProxyService;
    private static ActivityFilterService activityFilterService;
    private Map<String, SsoService> channelSourcessoServiceMap = new HashMap();

    @Autowired
    public void setPageTaskRelationService(PageTaskRelationService pageTaskRelationService) {
        SsoController.pageTaskRelationService = pageTaskRelationService;
    }

    @Autowired
    public void setLocaleService(LocaleService localeService) {
        SsoController.localeService = localeService;
    }

    @Autowired
    public void setIamProxyService(DigiwinIamProxyService iamProxyService) {
        SsoController.iamProxyService = iamProxyService;
    }

    @Autowired
    public void setAtmcProxyService(DigiwinAtmcProxyService atmcProxyService) {
        SsoController.atmcProxyService = atmcProxyService;
    }

    @Autowired
    public void setActivityFilterService(ActivityFilterService activityFilterService) {
        SsoController.activityFilterService = activityFilterService;
    }

    @Autowired
    public void setSsoServiceMap(Map<String, SsoService> ssoServiceMap) {
        ssoServiceMap.forEach((k, v) -> this.channelSourcessoServiceMap.put(v.getSsoChannelSource(), v));
    }

    @GetMapping(value={"/line"})
    public ApiResponse handleLineSso(HttpServletRequest request, HttpServletResponse response) {
        try {
            ThirdPartyForParticipationRequestModel model = ThirdPartyForParticipationRequestModel.handleParams((HttpServletRequest)request);
            SsoService ssoService = this.channelSourcessoServiceMap.getOrDefault(model.getChannelSource(), null);
            ApiResponse ssoResponse = null;
            if (Objects.isNull(ssoService)) {
                ssoResponse = this.handleIamSsoLogin(model);
            }
            if (ssoResponse != null) {
                if (ssoResponse.isError()) {
                    return ApiResponse.buildError((String)ssoResponse.getMsg());
                }
                DigiwhaleLoginResponse data = (DigiwhaleLoginResponse)ssoResponse.getData();
                model.setIamUserToken(data.getToken());
                model.setUserId(data.getUserId());
                model.setTenantId(data.getTenantId());
            }
            Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
            boolean mobileDevice = HttpRequestDeviceUtils.isMobileDevice((HttpServletRequest)request);
            if (mobileDevice) {
                if (Objects.nonNull(ssoService)) {
                    return ssoService.getSsoMobileParams(response, model, isTw);
                }
                return this.getSsoMongoMobileParams(response, model, isTw, new Query());
            }
            if (Objects.nonNull(ssoService)) {
                return ssoService.getSsoPcParams(response, model, isTw);
            }
            return this.getSsoMongoPcParams(response, model, isTw, new Query());
        }
        catch (Exception e) {
            log.error("line\u91cd\u5b9a\u5411\u5931\u8d25:{}", (Object)e.getMessage());
            return ApiResponse.buildError((String)e.getMessage());
        }
    }

    @GetMapping(value={"/grantOauthAccess"})
    public ApiResponse grantOauthAccess(HttpServletRequest request, HttpServletResponse response) {
        try {
            Query query = new Query();
            ThirdPartyForParticipationRequestModel model = ThirdPartyForParticipationRequestModel.handleParams((HttpServletRequest)request);
            Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
            return this.getSsoMongoMobileParams(response, model, isTw, query);
        }
        catch (Exception e) {
            log.error("grantOauthAccess\u91cd\u5b9a\u5411\u5931\u8d25:{}", (Object)e.getMessage());
            return ApiResponse.buildError((String)e.getMessage());
        }
    }

    @Nullable
    private ApiResponse getSsoMongoMobileParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw, Query query) throws IOException {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)SsoMongoKeyEnum.MOBILE.getSource()));
        SsoConfigModel mobileModel = (SsoConfigModel)this.mongoTemplate.findOne(query, SsoConfigModel.class);
        ApiResponse url = SsoController.getRedirectUrl((SsoConfigModel)mobileModel, (Boolean)isTw, (ThirdPartyForParticipationRequestModel)model, (Boolean)true);
        if (url != null) {
            if (SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
                log.error("\u4f01\u5faeurl:{}", (Object)url);
                return ApiResponse.buildOK().setData((Object)url);
            }
            response.sendRedirect(String.valueOf(url.getData()));
        }
        return url;
    }

    @Nullable
    private ApiResponse getSsoMongoPcParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw, Query query) throws IOException {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)SsoMongoKeyEnum.PC.getSource()));
        SsoConfigModel pcModel = (SsoConfigModel)this.mongoTemplate.findOne(query, SsoConfigModel.class);
        ApiResponse url = SsoController.getRedirectUrl((SsoConfigModel)pcModel, (Boolean)isTw, (ThirdPartyForParticipationRequestModel)model, (Boolean)false);
        if (url != null) {
            response.sendRedirect(String.valueOf(url.getData()));
        }
        return url;
    }

    @GetMapping(value={"/digiwinapp"})
    public ApiResponse<String> handleDigiwinAppStandardSso(DigiwinAppStandardSsoQueryDTO dto, HttpServletResponse response) {
        try {
            if (StringUtils.isNotBlank((CharSequence)dto.getSsoTargetUrl()) && StringUtils.isNotBlank((CharSequence)dto.getMLoginID()) && StringUtils.isNotBlank((CharSequence)dto.getMPassword())) {
                String clientAgent = "mobileplatform-" + UUIDUtil.getUuid();
                String encryptUserName = AESUtil.decrypt((String)"550F743242C486791EDBDEDEE3498BAA", (String)dto.getMLoginID());
                String loginName = encryptUserName + "@digiwin.com";
                String encryptParamPwd = AESUtil.decrypt((String)"550F743242C486791EDBDEDEE3498BAA", (String)dto.getMPassword());
                String encryptPublicKey = this.getEncryptPublicKey();
                String passwordHash = this.getEncryptPwd(encryptParamPwd, encryptPublicKey);
                ResponseEntity responseEntity = this.digiwinIamProxyService.userLoginByAD(loginName, encryptPublicKey, passwordHash, dto.getLocale(), null, clientAgent, null, "");
                IamAuth iamAuth = ((DigiwhaleLoginResponse)Objects.requireNonNull(responseEntity.getBody())).getIamAuth();
                StringBuilder appendUrl = new StringBuilder(dto.getSsoTargetUrl());
                appendUrl.append("/#/?iamUserToken=").append(iamAuth.getToken());
                appendUrl.append("&userId=").append(iamAuth.getUserId());
                appendUrl.append("&tenantId=").append(iamAuth.getTenantId()).append(dto.getSsoUrlParameter());
                String url = appendUrl.toString();
                if (!url.contains("locale")) {
                    appendUrl.append("&locale=").append(dto.getLocale());
                }
                response.sendRedirect(appendUrl.toString());
                return ApiResponse.buildOK((String)appendUrl.toString());
            }
        }
        catch (Exception e) {
            log.error("SSO\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return ApiResponse.buildServiceError((String)localeService.getLanguageValue(dto.getLocale(), "SSO\u9a8c\u8bc1\u5931\u8d25"), (String)e.getMessage());
        }
        return ApiResponse.buildOK();
    }

    private String getEncryptPublicKey() throws Exception {
        String serverPublicKey = this.digiwinIamProxyService.doGetPublicKey();
        if (StringUtils.isEmpty((CharSequence)serverPublicKey)) {
            log.error("\u672a\u62ff\u5230\u4e92\u8054\u7684\u516c\u94a5\u3002\u3002\u3002\u3002");
        } else {
            log.error("\u62ff\u5230\u4e92\u8054\u516c\u94a5\u4e3a\uff1a" + serverPublicKey);
        }
        return RSAUtils.encryptByPublicKey((String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCs+xq+pZvnji066WeQmfpS9vA17SciLiJk9DSTyGll11/F1tcg+jevbgG6a60uRfwdlnq1McMKbIdEdd0HcMIc3FPTAMCerSwWeZIU5ffL8hKBIhQy2JApZ4PIQIb5+WcojT97kjhxQRnBZjmXPfyRpXehIEAdyELn7fo7/dJacQIDAQAB", (String)serverPublicKey);
    }

    private String getEncryptPwd(String userName, String encryptPublicKey) throws Exception {
        String aesPrivateKey = this.digiwinIamProxyService.doGetAesKey(encryptPublicKey);
        String aesKey = new String(RSAUtils.decryptByPrivateKey((byte[])Base64.decodeBase64((String)aesPrivateKey), (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKz7Gr6lm+eOLTrpZ5CZ+lL28DXtJyIuImT0NJPIaWXXX8XW1yD6N69uAbprrS5F/B2WerUxwwpsh0R13QdwwhzcU9MAwJ6tLBZ5khTl98vyEoEiFDLYkClng8hAhvn5ZyiNP3uSOHFBGcFmOZc9/JGld6EgQB3IQuft+jv90lpxAgMBAAECgYANkRQj57E2k/wQJsYsnSb44s0sLZFoKN4htNV60bkSd7XXOmZc+8LqS2JvUIqgmnSPjYHKPEDjzGc/g072im1u3JUbTO7EyHhn7iuf9ynUe3KAAMSdD58SmQy2z12gpWYfp7x3AIGWWcHNk29Y/wVf73ZYRZWD5PZ7E2IHuFOewQJBAPfd0T0LlmIwssDgj0KsvP65rVhE6z81Z3IrMv0gXcmcQghJXYWOYonxxtAmSf3PYFJWFDcovFUtWlD5XkE7sj0CQQCyqDdz6laf/Y+fBBe6UEF9Qle1qFcga5S6nCBQ7RWPrfX3Twh8MvrTcCFfcVAe/NVxGZhFCvSNEF8aD0E67ZBFAkBMcoCXWFyQej6XmGr3AHnmAnSBVfhMbXczUjmOso3aobQIBECw8YJY01YjWrvVaUFnA5+Gh6zWhH9nnBHDAtttAkAdoG+xtUawOWg7wn3805pIn1vUMBpisfR0Dbf+M5LDxOFpJZ4OmpWlwo6GOVBEE0GCA/CQYoSzb+eVdromf4bRAkEAgjVXk9PqfsOQr3fZQ9G8sDiXHbqgwpvsqH73/7HTdLO6+IapR+meHyIj1H62z22WvsmwJmGtHyC2ROD5kJ1npg=="));
        return AESUtils.aesEncryptByBase64((String)userName, (String)aesKey);
    }

    @Nullable
    public static ApiResponse getRedirectUrl(SsoConfigModel mobileModel, Boolean isTw, ThirdPartyForParticipationRequestModel model, Boolean mobileDevice) {
        Map parameterMap = mobileModel.getParameterMap();
        List environmentalConfigurations = isTw != false ? (List)parameterMap.get(AppEnvDeployAreaEnum.TW.name()) : (List)parameterMap.get(AppEnvDeployAreaEnum.CN.name());
        String url = SsoController.haveParameterSubstitution((ThirdPartyForParticipationRequestModel)model, (List)environmentalConfigurations, (Boolean)mobileDevice);
        log.error("\u83b7\u53d6\u91cd\u5b9a\u5411url:{}", (Object)url);
        return ApiResponse.buildOK().setData((Object)url);
    }

    @Nullable
    public static String haveParameterSubstitution(ThirdPartyForParticipationRequestModel model, List<EnvironmentalConfiguration> environmentalConfigurations, Boolean mobileDevice) {
        for (EnvironmentalConfiguration var : environmentalConfigurations) {
            if (!AppContext.getEnvType().equalsIgnoreCase(var.getEnvironment())) continue;
            String parameter = SsoController.handelParameter((EnvironmentalConfiguration)var, (ThirdPartyForParticipationRequestModel)model, (Boolean)mobileDevice);
            if (SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
                return SsoController.handEnterpriseWechatUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
            }
            if (SsoSourceTypeEnum.MOBILE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType()) || SsoSourceTypeEnum.LINE.getSource().equalsIgnoreCase(model.getSourceType())) {
                if (BooleanUtils.isFalse((Boolean)mobileDevice)) {
                    return parameter.replace("{iamUserToken}", model.getIamUserToken());
                }
                return SsoController.loginSsoUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
            }
            if (StringUtils.isNotBlank((CharSequence)model.getIamUserToken())) {
                return SsoController.loginSsoUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
            }
            String replace = parameter.replace("{redirectUrl}", "login&targetUrl=render").replace("{ }", model.getTargetTenantId());
            StringBuilder url = new StringBuilder(replace);
            if (ObjectUtils.isNotEmpty((Object)model.getIsHideAppBar())) {
                url.append("&isHideAppBar=").append(model.getIsHideAppBar());
            }
            return String.valueOf(url);
        }
        return null;
    }

    public static String handelParameter(EnvironmentalConfiguration var, ThirdPartyForParticipationRequestModel model, Boolean mobileDevice) {
        String parameter = var.getParameter().replace("{muiUrl}", mobileDevice != false ? AppContext.getApiUrlSetting().getWebUrl() : AppContext.getApiUrlSetting().getMuiUrl()).replace("{local}", model.getLocal());
        if (StringUtils.isNotBlank((CharSequence)model.getTaskId())) {
            parameter = parameter.replace("{dataId}", model.getTaskId());
        }
        parameter = StringUtils.isNotBlank((CharSequence)model.getProxyToken()) ? parameter.replace("{proxyToken}", model.getProxyToken()) : parameter.replace("&proxyToken={proxyToken}", "");
        parameter = StringUtils.isNotBlank((CharSequence)model.getTargetTenantId()) ? parameter.replace("{targetTenantId}", model.getTargetTenantId()) : parameter.replace("&targetTenantId={targetTenantId}", "");
        parameter = SsoController.handleNanaAppletUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
        parameter = SsoController.handWeChatUrlPhaseOne((ThirdPartyForParticipationRequestModel)model, (String)parameter);
        parameter = SsoController.handDingTalkUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
        return parameter;
    }

    private static String handleNanaAppletUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.NANA_APPLET.getSource().equalsIgnoreCase(model.getSourceType())) {
            SsoController.authCodeSubstitutionAccessToken((ThirdPartyForParticipationRequestModel)model);
            SsoController.handelTaskCategory((ThirdPartyForParticipationRequestModel)model);
            parameter = parameter.replace("&sourceType=nana", "&sourceType=nana_applet");
            parameter = StringUtils.isNotBlank((CharSequence)model.getPageId()) ? parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId()) : parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), PageSettingIdPresetEnum.MOBILE_ATHENA_EMPTY_PAGE.name());
        }
        return parameter;
    }

    private static String handWeChatUrlPhaseOne(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.MOBILE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
            SsoController.handleReplaceToken((ThirdPartyForParticipationRequestModel)model);
            SsoController.handelTaskCategory((ThirdPartyForParticipationRequestModel)model);
            AppRequestContext.getContextEntity().setSourceType(model.getSourceType());
            parameter = parameter.replace("&sourceType=nana", "&sourceType=Wechat");
            parameter = StringUtils.isNotBlank((CharSequence)model.getTaskCategory()) && "APPROVAL".equalsIgnoreCase(model.getTaskCategory()) ? parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.name()) : parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), PageSettingIdPresetEnum.MOBILE_ATHENA_EMPTY_PAGE.name());
        }
        return parameter;
    }

    private static String handEnterpriseWechatUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        SsoController.handleEnterpriseWechatAuthorization((ThirdPartyForParticipationRequestModel)model);
        parameter = parameter.replace("&sourceType=nana", "&sourceType=enterprise_Wechat");
        if (StringUtils.isNotBlank((CharSequence)model.getTaskId())) {
            SsoController.handelTaskCategory((ThirdPartyForParticipationRequestModel)model);
            parameter = StringUtils.isNotBlank((CharSequence)model.getPageId()) ? parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId()) : parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), PageSettingIdPresetEnum.MOBILE_ATHENA_EMPTY_PAGE.name());
            return SsoController.loginSsoUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter);
        }
        parameter = parameter.replace("&dataId={dataId}", "");
        String url = StringUtils.isNotBlank((CharSequence)model.getIamUserToken()) ? SsoController.loginSsoUrl((ThirdPartyForParticipationRequestModel)model, (String)parameter).replace("render", "home").replace("MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL", PageSettingIdPresetEnum.INDEX.name()) : parameter.replace("{redirectUrl}", "login&targetUrl=render").replace("&pageId=MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL", "");
        return url;
    }

    private static String handDingTalkUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.DING_TALK.getSource().equalsIgnoreCase(model.getSourceType())) {
            SsoController.handelTaskCategory((ThirdPartyForParticipationRequestModel)model);
            parameter = StringUtils.isNotBlank((CharSequence)model.getPageId()) ? parameter.replace("&sourceType=nana", "&sourceType=ding_talk").replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId()) : parameter.replace(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), PageSettingIdPresetEnum.MOBILE_ATHENA_EMPTY_PAGE.name());
        }
        return parameter;
    }

    private static String loginSsoUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        String replace = parameter.replace("{redirectUrl}", "render");
        StringBuilder url = new StringBuilder(replace);
        url.append("&iamUserToken=").append(model.getIamUserToken()).append("&userId=").append(model.getUserId()).append("&tenantId=").append(model.getTenantId());
        if (ObjectUtils.isNotEmpty((Object)model.getIsHideAppBar())) {
            url.append("&isHideAppBar=").append(model.getIsHideAppBar());
        }
        return String.valueOf(url);
    }

    private ApiResponse handleIamSsoLogin(ThirdPartyForParticipationRequestModel model) {
        ThirdPartyLoginFreeQueryDTO queryDTO = new ThirdPartyLoginFreeQueryDTO();
        BeanUtils.copyProperties((Object)model, (Object)queryDTO);
        queryDTO.setTenantId(model.getTargetTenantId());
        queryDTO.setType("line");
        DigiwhaleLoginResponse iamUserInfo = iamProxyService.identityOauthTokenGrantAccess(queryDTO);
        if (ObjectUtils.isEmpty((Object)iamUserInfo)) {
            return ApiResponse.buildError((String)"Line IAM SSO Fail");
        }
        if (ObjectUtils.isNotEmpty((Object)iamUserInfo.getErrorMessage())) {
            return ApiResponse.buildError((String)iamUserInfo.getErrorMessage());
        }
        return ApiResponse.buildOK().setData((Object)iamUserInfo);
    }

    private static void authCodeSubstitutionAccessToken(ThirdPartyForParticipationRequestModel model) {
        DigiwinIamAuthoredUser digiwhaleLoginResponse = iamProxyService.authCodeSubstitutionAccessToken(model.getCode(), model.getAppId());
        if (!ObjectUtils.isNotEmpty((Object)digiwhaleLoginResponse)) {
            throw new ServiceException(localeService.getLanguageValue(model.getLocal(), "SSO\u767b\u5f55\u5931\u8d25"));
        }
        model.setIamUserToken(digiwhaleLoginResponse.getToken());
        model.setUserId(digiwhaleLoginResponse.getUserId());
        model.setTenantId(digiwhaleLoginResponse.getTenantId());
    }

    private static void handleReplaceToken(ThirdPartyForParticipationRequestModel model) {
        String token = iamProxyService.identityTokenTempAccess(model.getIamUserToken(), model.getTenantId(), model.getUserId(), "athena");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            model.setIamUserToken(token);
        }
    }

    private static void handleEnterpriseWechatAuthorization(ThirdPartyForParticipationRequestModel model) {
        DigiwhaleLoginResponse response = iamProxyService.identityOauthTokenAccess(model.getCode(), model.getTenantId(), "weCom", model.getAppId());
        if (!ObjectUtils.isEmpty((Object)response)) {
            model.setIamUserToken(response.getToken());
            model.setUserId(response.getUserId());
            model.setTenantId(response.getTenantId());
        }
    }

    private static void handelTaskCategory(ThirdPartyForParticipationRequestModel model) {
        String iamUserToken = model.getIamUserToken();
        String tenantId = model.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)model.getTaskId()) && StringUtils.isNotBlank((CharSequence)iamUserToken)) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklog;
            if (StringUtils.isNotBlank((CharSequence)model.getTargetTenantId()) && !model.getTargetTenantId().equalsIgnoreCase(model.getTenantId())) {
                ProxyRefreshTenant proxyRefreshTenant = ProxyRefreshTenant.create((DigiwinIamTokenRefreshTenant)iamProxyService.tokenRefreshTenant(model.getTargetTenantId(), "", iamUserToken));
                iamUserToken = proxyRefreshTenant.getUserToken();
                tenantId = proxyRefreshTenant.getTenantId();
            }
            if (ObjectUtils.isNotEmpty((Object)(digiwinAtmcBacklog = atmcProxyService.getDigiwinAtmcBacklogDetailByShare(model.getLocal(), iamUserToken, model.getTaskId()))) && StringUtils.isNotBlank((CharSequence)digiwinAtmcBacklog.getTmTaskId())) {
                model.setTaskCategory(digiwinAtmcBacklog.getTmCategory());
                String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, model.getLocal());
                List pageTaskRelationList = activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);
                Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId())).findFirst();
                Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory())).findFirst();
                String pageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ? optPageTaskRelationTaskIdAndActivityId.get().getPageId() : (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
                model.setPageId(pageId);
            } else {
                throw new ServiceException(localeService.getLanguageValue(model.getLocal(), "\u67e5\u8be2\u4efb\u52a1\u5931\u8d25"));
            }
        }
    }

    @RequestMapping(value={"/line/login"}, method={RequestMethod.POST})
    public ApiResponse<T> handLineWeChatSsoLogin(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        DigIwinCamResponse lineCamInfo = this.camProxyService.getLineCamInfo(params);
        if (ObjectUtils.isEmpty((Object)lineCamInfo)) {
            return ApiResponse.buildError();
        }
        JSONObject lineInfo = (JSONObject)JsonUtil.objectToJavaObject((Object)lineCamInfo.getData(), JSONObject.class);
        String tenantId = lineInfo.getString("tenantId");
        String iamUserToken = lineInfo.getString("token");
        String userId = lineInfo.getString("userId");
        if (ObjectUtils.isEmpty((Object)userId)) {
            return ApiResponse.buildOK();
        }
        String verifyUserId = lineInfo.getString("verifyUserId");
        DigiwinIamUserAddJoinTenant joinTenantResult = this.digiwinIamProxyService.userAddJoinTenant(iamUserToken, tenantId, "", "", "");
        joinTenantResult.setTenantId(tenantId);
        DigiwinIamTokenRefreshTenant refreshTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(joinTenantResult.getTenantId(), "", iamUserToken);
        JSONObject userInfo = iamProxyService.getUserInfo(refreshTenantResult.getUserToken(), userId);
        if (ObjectUtils.isEmpty((Object)userInfo)) {
            return ApiResponse.buildError();
        }
        EocPerson eocInfo = this.digiwinEocProxyService.getEocInfo(userInfo.getString("id"), iamUserToken);
        userInfo.put("eoc", (Object)eocInfo);
        userInfo.put("bindTenantId", (Object)tenantId);
        userInfo.put("verifyUserId", (Object)verifyUserId);
        userInfo.put("iamAuth", (Object)refreshTenantResult.getAuthoredUser());
        return ApiResponse.buildOK().setData((Object)userInfo);
    }
}

