/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.sso.dingding;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigiwinCamDingDingQuery;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigiwinCamDingDingResult;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.sso.SsoController;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoMongoKeyEnum;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.sso.model.EnvironmentalConfiguration;
import com.digiwin.mobile.mobileuibot.sso.model.SsoConfigModel;
import com.digiwin.mobile.mobileuibot.sso.model.ThirdPartyForParticipationRequestModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/mobile/v1/ding_talk"})
public class DingDingController {
    private static final Logger log = LoggerFactory.getLogger(DingDingController.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DigIwinCamProxyService camProxyService;
    @Autowired
    private DigiwinIamProxyService iamProxyService;

    @GetMapping(value={"/getClientKey"})
    public ApiResponse<Map<String, String>> getClientKey(@RequestParam(value="appId") String appId) {
        try {
            HashMap map = new HashMap(2);
            List goodsMappings = this.camProxyService.getGoodsMappings(appId);
            goodsMappings.forEach(data -> {
                if ("clientKey".equalsIgnoreCase(data.getKey())) {
                    map.put("clientKey", data.getValue());
                }
                if ("appId".equalsIgnoreCase(data.getKey())) {
                    map.put("dingTalkAppId", data.getValue());
                }
            });
            return ApiResponse.buildOK().setData(map);
        }
        catch (Exception e) {
            log.error("getClientKey error:{}", (Object)e.getMessage());
            return ApiResponse.buildError((String)("DingTalk getClientKey\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/ssoLogin"})
    public ApiResponse<DigiwinCamDingDingResult> handleDingTalkSsoLogin(@RequestBody DigiwinCamDingDingQuery query) {
        try {
            DigiwinCamDingDingResult data = this.camProxyService.dingDingSsoLogin(query);
            log.error("\u9489\u9489cam \u8fd4\u56de:{}", (Object)JsonUtil.javaObjectToJsonString((Object)data));
            if (ObjectUtils.isEmpty((Object)data)) {
                return ApiResponse.buildError((String)"code expire");
            }
            DigiwinIamAnalyzedToken digiwinIamAnalyzedToken = this.iamProxyService.tokenAnalyze(data.getToken());
            if (ObjectUtils.isNotEmpty((Object)digiwinIamAnalyzedToken)) {
                data.setUserName(digiwinIamAnalyzedToken.getName());
                data.setTenantName(digiwinIamAnalyzedToken.getTenantName());
            }
            if (StringUtil.isNotEmpty((CharSequence)query.getTaskId())) {
                this.handelTaskDeatilUrl(data, query);
            }
            log.error("\u9489\u9489cam \u6700\u7ec8\u8fd4\u56de:{}", (Object)JsonUtil.javaObjectToJsonString((Object)data));
            return ApiResponse.buildOK().setData((Object)data);
        }
        catch (Exception e) {
            log.error("ding_talk,ssoLogin error:{}", (Object)e.getMessage());
            return ApiResponse.buildError((String)e.getMessage());
        }
    }

    private void handelTaskDeatilUrl(DigiwinCamDingDingResult data, DigiwinCamDingDingQuery camDingDingQuery) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)SsoMongoKeyEnum.MOBILE.getSource()));
        SsoConfigModel mobileModel = (SsoConfigModel)this.mongoTemplate.findOne(query, SsoConfigModel.class);
        if (ObjectUtils.isEmpty((Object)mobileModel)) {
            return;
        }
        ApiResponse response = SsoController.getRedirectUrl((SsoConfigModel)mobileModel, (Boolean)false, (ThirdPartyForParticipationRequestModel)DingDingController.handelModelParams((DigiwinCamDingDingResult)data, (DigiwinCamDingDingQuery)camDingDingQuery), (Boolean)true);
        if (response != null) {
            data.setUrl(String.valueOf(response.getData()));
        }
    }

    @NotNull
    private static ThirdPartyForParticipationRequestModel handelModelParams(DigiwinCamDingDingResult data, DigiwinCamDingDingQuery camDingDingQuery) {
        ThirdPartyForParticipationRequestModel model = new ThirdPartyForParticipationRequestModel();
        model.setIamUserToken(data.getToken());
        model.setUserId(data.getUserId());
        model.setTenantId(data.getTenantId());
        model.setIsHideAppBar(Boolean.valueOf(true));
        model.setTaskId(camDingDingQuery.getTaskId());
        model.setTargetTenantId(camDingDingQuery.getTargetTenantId());
        model.setLocal("zh_CN");
        model.setSourceType(SsoSourceTypeEnum.DING_TALK.getSource());
        return model;
    }

    @Nullable
    private String handelUrl(String appId, String corpId, String taskId, String targetTenantId, SsoConfigModel mobileModel, String suiteKey) {
        String parameter = null;
        for (EnvironmentalConfiguration configuration : (List)mobileModel.getParameterMap().get("CN")) {
            if (!AppContext.getEnvType().equalsIgnoreCase(configuration.getEnvironment())) continue;
            parameter = configuration.getParameter().replace("{muiUrl}", AppContext.getApiUrlSetting().getWebUrl());
        }
        if (parameter != null) {
            String url = parameter.replace("{corpId}", corpId).replace("{clientKey}", suiteKey).replace("{appId}", appId);
            if (StringUtil.isNotEmpty((CharSequence)taskId)) {
                url = url + "&taskId=" + taskId;
            }
            if (StringUtil.isNotEmpty((CharSequence)targetTenantId)) {
                url = url + "&targetTenantId=" + targetTenantId;
            }
            return url;
        }
        return null;
    }
}

