/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterRepositoryCustom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class TaskFilterRepositoryImpl
implements TaskFilterRepositoryCustom {
    private static final Logger logger = LoggerFactory.getLogger(TaskFilterRepositoryImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    @Cacheable(cacheNames={"taskFilterList"}, cacheManager="systemCacheManager", key="#root.targetClass.simpleName + ':' + #version")
    public List<TaskFilter> listValidInAthena(String version) {
        logger.debug("cache miss in list taskFilters...invoke find by source and valid property...");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"source").is((Object)"athena")).addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return this.mongoTemplate.find(query, TaskFilter.class).stream().filter(filter -> filter.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
    }

    @CacheEvict(cacheNames={"taskFilterList"}, cacheManager="systemCacheManager", key="#root.targetClass.simpleName + ':' + #version")
    public void deleteByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.findAllAndRemove(query, TaskFilter.class);
        this.secondMongoTemplate.findAllAndRemove(query, TaskFilter.class);
    }

    public List<TaskFilter> selectByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List list = this.mongoTemplate.find(query, TaskFilter.class);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    @CacheEvict(cacheNames={"taskFilterList"}, cacheManager="systemCacheManager", key="#root.targetClass.simpleName + ':' + #version")
    public void batchInsert(List<TaskFilter> taskFilters, String version) {
        if (CollectionUtils.isEmpty(taskFilters)) {
            return;
        }
        this.mongoTemplate.insertAll(taskFilters);
        this.secondMongoTemplate.insertAll(taskFilters);
    }
}

