/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.DataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardConfigItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardConfigItemSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcGroup;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcLabel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcOrder;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoList;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.TaskExtraParameter;
import com.digiwin.mobile.mobileuibot.task.model.TaskPerson;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskSummary
implements Serializable {
    private static final long serialVersionUID = -4831571307134460840L;
    private String contentUrl;
    private Boolean emergency;
    private String endTime;
    private String startTime;
    private String eocName;
    private Boolean exception;
    private TaskExtraParameter extraParameter;
    private String dataId;
    private Boolean importance;
    private String jumpPageId;
    private String jumpPageTitle;
    private String name;
    private String subName;
    private Boolean newly;
    private String projectName;
    private Boolean proxy;
    private TaskPerson proxyPerson;
    private String sourceTenantName;
    private String state;
    private Action action;
    private Boolean finished;
    private String calenderTeamName;
    private String executorName;
    private Boolean teamEnter = false;
    private Boolean isTeamTask = false;
    private Boolean isPccTask = false;
    private Boolean hasAppPermission = true;
    private Boolean engineHasWaittingData = true;
    private Boolean reexecute = false;
    private Boolean addTask = false;
    private Boolean reassign = false;
    private Boolean dataChangeRead;
    private Boolean hasDataChanged;
    private String approvalStateCode;
    private Boolean handover = false;
    private Boolean pinning;
    private String dataChangeStatus;
    private String taskStatusMsg;
    private String tmActivityId;
    private String tmActivityName;
    private String originProjectName;
    private String showPlanEndTimeMin;
    private String showPlanEndTimeMax;
    private Boolean overdue;
    private List<DigiwinAtmcLabel> labels;
    private DigiwinAtmcOrder order;
    private DigiwinAtmcGroup group;
    private List<DigiwinAtmcCardConfigItem> cardConfig;
    private Map<String, Object> businessMessage;
    private Boolean isTripartiteTodo = false;
    private String subTitle;
    private String description;

    public Boolean getIsPccTask() {
        if (ObjectUtils.isNotEmpty((Object)this.extraParameter) && StringUtil.isNotEmpty((CharSequence)this.extraParameter.getTmTaskId()) && StringUtil.isNotEmpty((CharSequence)this.extraParameter.getTmActivityId())) {
            return TaskStringUtil.isPccTask((String)this.extraParameter.getTmTaskId(), (String)this.extraParameter.getTmActivityId());
        }
        return this.isPccTask;
    }

    public static TaskSummary create(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog, String jumpPageId, List<CustomTaskConfig> customTaskConfigList, boolean isMyCalender, String currentUserId, boolean isTeamTask, String url, Map<String, Integer> taskTypeData, Map<String, Integer> taskFlowData, Map<String, Integer> taskReadStatusData, Map<String, Integer> taskStatusData, Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter, Map<String, Set<String>> customSelectOptionMap, Set<String> orderCodeSetFromBacklogs, LocaleService localeService) {
        TaskSummary taskSummary = TaskSummary.create((String)locale, (String)iamUserToken, (DigiwinAtmcBacklog)digiwinAtmcBacklog, (String)jumpPageId, customTaskConfigList, (boolean)isMyCalender, (String)currentUserId, (boolean)isTeamTask, (LocaleService)localeService);
        taskTypeData.put(digiwinAtmcBacklog.getTmActivityId() + "_" + digiwinAtmcBacklog.getBacklogId(), 1);
        taskFlowData.put(TaskSummary.buildFlowKey((DigiwinAtmcBacklog)digiwinAtmcBacklog), 1);
        taskReadStatusData.put(TaskSummary.buildReadStatusKey((DigiwinAtmcBacklog)digiwinAtmcBacklog), 1);
        taskStatusData.put(TaskSummary.buildStatusKey((DigiwinAtmcBacklog)digiwinAtmcBacklog), 1);
        if (!CollectionUtils.isEmpty((Collection)digiwinAtmcBacklog.getCardConfig())) {
            digiwinAtmcBacklog.getCardConfig().stream().forEach(item -> {
                Optional<DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigOrder> cardConfigOrderOpt;
                String aliasField = item.getAliasField();
                Optional<DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> cardConfigFilterOpt = Optional.ofNullable(item).map(DigiwinAtmcCardConfigItem::getConfig).map(DigiwinAtmcCardConfigItemSetInfo::getFilter);
                if (cardConfigFilterOpt.isPresent()) {
                    List aliasFieldValList;
                    customFilter.putIfAbsent(aliasField, cardConfigFilterOpt.get());
                    if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilterOpt.get().getDataType()) && !CollectionUtils.isEmpty((Map)digiwinAtmcBacklog.getBusinessMessage()) && !CollectionUtils.isEmpty((Collection)(aliasFieldValList = (List)MapUtil.getOrDefault((Map)digiwinAtmcBacklog.getBusinessMessage(), (String)aliasField, Collections.emptyList())))) {
                        Set customSelectOptionList = (Set)customSelectOptionMap.get(aliasField);
                        customSelectOptionList = CollectionUtils.isEmpty((Collection)customSelectOptionList) ? new HashSet() : customSelectOptionList;
                        customSelectOptionList.addAll(aliasFieldValList);
                        customSelectOptionMap.put(aliasField, customSelectOptionList);
                    }
                }
                if ((cardConfigOrderOpt = Optional.ofNullable(item).map(DigiwinAtmcCardConfigItem::getConfig).map(DigiwinAtmcCardConfigItemSetInfo::getOrder)).isPresent()) {
                    orderCodeSetFromBacklogs.add(aliasField);
                }
            });
        }
        return taskSummary;
    }

    private static String buildStatusKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        if (digiwinAtmcBacklog.getOverdue().booleanValue() || digiwinAtmcBacklog.getException().booleanValue()) {
            key.append("overdueException");
        } else if (digiwinAtmcBacklog.getEmergency().booleanValue()) {
            key.append("emergency");
        } else if (digiwinAtmcBacklog.getHasDataChanged().booleanValue()) {
            key.append("dataChangeRead");
        } else if (digiwinAtmcBacklog.getImportance().booleanValue()) {
            key.append("importance");
        } else if (BooleanUtils.isNotTrue((Boolean)digiwinAtmcBacklog.getHasAppPermission())) {
            key.append("hasAppPermission");
        } else if (digiwinAtmcBacklog.getReexecute().booleanValue()) {
            key.append("reexecute");
        } else if (digiwinAtmcBacklog.getAddTask().booleanValue()) {
            key.append("addTask");
        } else {
            key.append("other");
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    private static String buildFlowKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        if (digiwinAtmcBacklog.getReassign().booleanValue()) {
            key.append("reassign");
        } else if ("handover".equalsIgnoreCase(digiwinAtmcBacklog.getApprovalStateCode()) || BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getHandover())) {
            key.append("handover");
        } else if (!digiwinAtmcBacklog.getIsOwner().booleanValue()) {
            key.append("agent");
        } else if (BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getPinning())) {
            key.append("pinning");
        } else {
            key.append("other");
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    private static String buildReadStatusKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        if (digiwinAtmcBacklog.getReadCount() == 0L) {
            key.append("unread");
        } else {
            key.append("read");
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    public static TaskSummary create(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog, String jumpPageId, List<CustomTaskConfig> customTaskConfigList, boolean isMyCalender, String currentUserId, boolean isTeamTask, LocaleService localeService) {
        TaskSummary taskSummary = new TaskSummary();
        String urlTemplate = AppContext.getBaseUrl() + "/mobile/v1/task/card/content?dataId=%s&iamUserToken=%s&tenantId=%s&locale=%s&tmCategory=%s&tmPattern=%s&type=%s&tmTaskId=%s&tmActivityId=%s&proxyToken=%s";
        taskSummary.setContentUrl(String.format(urlTemplate, digiwinAtmcBacklog.getBacklogId(), iamUserToken, digiwinAtmcBacklog.getTenantId(), locale, digiwinAtmcBacklog.getTmCategory(), digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getType() + "", digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getProxyToken() == null ? "" : digiwinAtmcBacklog.getProxyToken()));
        taskSummary.setEmergency(digiwinAtmcBacklog.getEmergency());
        taskSummary.setEndTime(digiwinAtmcBacklog.getEndTime());
        taskSummary.setStartTime(digiwinAtmcBacklog.getStartTime());
        taskSummary.setEocName(digiwinAtmcBacklog.getEocName());
        taskSummary.setException(digiwinAtmcBacklog.getException());
        taskSummary.setExtraParameter(new TaskExtraParameter(digiwinAtmcBacklog.getAppCode(), digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmCategory(), digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmTaskId()));
        taskSummary.setDataId(digiwinAtmcBacklog.getBacklogId() + "");
        taskSummary.setImportance(digiwinAtmcBacklog.getImportance());
        if (digiwinAtmcBacklog.isTypeOfManualTask()) {
            jumpPageId = PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString();
            taskSummary.setJumpPageId(jumpPageId);
        } else if (TestV1ToV2Util.exist((String)digiwinAtmcBacklog.getTmActivityId())) {
            taskSummary.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
        } else {
            taskSummary.setJumpPageId(Optional.ofNullable(jumpPageId).orElse(""));
        }
        taskSummary.setSourceTenantName(StringUtils.hasLength((String)digiwinAtmcBacklog.getSourceTenantName()) ? digiwinAtmcBacklog.getSourceTenantName() : null);
        taskSummary.setName(digiwinAtmcBacklog.getName());
        if (TaskStringUtil.isNeedSubName((DigiwinAtmcBacklog)digiwinAtmcBacklog)) {
            taskSummary.setSubName(digiwinAtmcBacklog.getSubName());
        }
        taskSummary.setNewly(Boolean.valueOf(digiwinAtmcBacklog.getReadCount() == 0L));
        taskSummary.setProxy(Boolean.valueOf(digiwinAtmcBacklog.getIsOwner() == null ? false : digiwinAtmcBacklog.getIsOwner() == false));
        taskSummary.setProxyPerson(TaskPerson.create((String)locale, (DigiwinAtmcBacklog)digiwinAtmcBacklog, (boolean)isMyCalender));
        taskSummary.setOriginProjectName(digiwinAtmcBacklog.getProjectName());
        taskSummary.setTmActivityId(digiwinAtmcBacklog.getTmActivityId());
        taskSummary.setTmActivityName(digiwinAtmcBacklog.getTmActivityName());
        taskSummary.setState(TaskStringUtil.getTaskStateText((DigiwinAtmcBacklog)digiwinAtmcBacklog) == null ? "" : TaskStringUtil.getTaskStateText((DigiwinAtmcBacklog)digiwinAtmcBacklog));
        taskSummary.setDataChangeStatus(TaskStringUtil.getDataChangeStatusText((DigiwinAtmcBacklog)digiwinAtmcBacklog, (LocaleService)localeService, (String)locale));
        taskSummary.setIsTeamTask(Boolean.valueOf(isTeamTask));
        taskSummary.setHasAppPermission(digiwinAtmcBacklog.getHasAppPermission());
        taskSummary.setPinning(digiwinAtmcBacklog.getPinning());
        taskSummary.setEngineHasWaittingData(digiwinAtmcBacklog.getEngineHasWaittingData());
        taskSummary.setReexecute(digiwinAtmcBacklog.getReexecute());
        taskSummary.setAddTask(digiwinAtmcBacklog.getAddTask());
        taskSummary.setReassign(digiwinAtmcBacklog.getReassign());
        taskSummary.setDataChangeRead(digiwinAtmcBacklog.getDataChangeRead());
        taskSummary.setHasDataChanged(digiwinAtmcBacklog.getHasDataChanged());
        taskSummary.setApprovalStateCode(digiwinAtmcBacklog.getApprovalStateCode());
        taskSummary.setHandover(digiwinAtmcBacklog.getHandover());
        taskSummary.setOverdue(digiwinAtmcBacklog.getOverdue());
        if (BooleanUtils.isNotTrue((Boolean)digiwinAtmcBacklog.getMerge())) {
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getEndTime());
        } else if (Objects.equals(digiwinAtmcBacklog.getPlanEndTimeMin(), digiwinAtmcBacklog.getPlanEndTimeMax())) {
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getPlanEndTimeMax());
        } else {
            taskSummary.setShowPlanEndTimeMin(digiwinAtmcBacklog.getPlanEndTimeMin());
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getPlanEndTimeMax());
        }
        taskSummary.setTaskStatusMsg(TaskSummary.buildTaskStatusMsg((DigiwinAtmcBacklog)digiwinAtmcBacklog, (LocaleService)localeService, (String)locale));
        if (!CollectionUtils.isEmpty((Collection)digiwinAtmcBacklog.getLabels())) {
            List sortedLabels = digiwinAtmcBacklog.getLabels().stream().filter(e -> StringUtils.hasLength((String)e.getOrderWeight())).sorted(Comparator.comparing(DigiwinAtmcLabel::getOrderWeight, Comparator.comparingInt(Integer::parseInt))).collect(Collectors.toList());
            sortedLabels.addAll(digiwinAtmcBacklog.getLabels().stream().filter(e -> !StringUtils.hasLength((String)e.getOrderWeight())).collect(Collectors.toList()));
            taskSummary.setLabels(sortedLabels);
        }
        taskSummary.setGroup(digiwinAtmcBacklog.getGroup());
        taskSummary.setOrder(digiwinAtmcBacklog.getOrder());
        taskSummary.setBusinessMessage(digiwinAtmcBacklog.getBusinessMessage());
        taskSummary.setCardConfig(digiwinAtmcBacklog.getCardConfig());
        taskSummary.setProjectName(ProjectStringUtil.getProjectNameOnCard((String)locale, (String)digiwinAtmcBacklog.getProjectStartTime(), (String)digiwinAtmcBacklog.getProjectEndTime(), (String)digiwinAtmcBacklog.getProjectName(), (boolean)TaskStringUtil.isPccTask((String)digiwinAtmcBacklog.getTmTaskId(), (String)digiwinAtmcBacklog.getTmActivityId())));
        if (digiwinAtmcBacklog.getExtendData() != null && digiwinAtmcBacklog.getExtendData().getFinished().booleanValue()) {
            taskSummary.setFinished(Boolean.valueOf(true));
        } else {
            taskSummary.setFinished(Boolean.valueOf(false));
        }
        taskSummary.setCalenderTeamName(digiwinAtmcBacklog.getCalenderTeamName());
        if (!isMyCalender) {
            taskSummary.setTeamEnter(Boolean.valueOf(true));
            if (digiwinAtmcBacklog.getOwnerUserId().equals(currentUserId)) {
                taskSummary.setExecutorName("");
            } else {
                taskSummary.setExecutorName(digiwinAtmcBacklog.getOwnerUserName());
            }
        } else {
            taskSummary.setTeamEnter(Boolean.valueOf(false));
        }
        taskSummary.setAction(TaskSummary.buildAction((DigiwinAtmcBacklog)digiwinAtmcBacklog, customTaskConfigList, (String)locale, (String)iamUserToken, (String)taskSummary.getJumpPageId(), (boolean)isTeamTask, (boolean)false));
        return taskSummary;
    }

    public static Action buildAction(DigiwinAtmcBacklog digiwinAtmcBacklog, List<CustomTaskConfig> customTaskConfigList, String locale, String iamUserToken, String jumpPageId, boolean isTeamTask, boolean isNeedTaskExtraParameter) {
        boolean isCustomH5Task;
        CustomTaskConfig targetCustomTaskConfig = null;
        for (CustomTaskConfig tempCustomTaskConfig : customTaskConfigList) {
            String tmActivityId;
            String tmTaskId = tempCustomTaskConfig.getTmTaskId();
            if (!digiwinAtmcBacklog.isEqualWithBacklogInTaskIdAndActivityId(tmTaskId, tmActivityId = tempCustomTaskConfig.getTmActivityId())) continue;
            targetCustomTaskConfig = tempCustomTaskConfig;
            break;
        }
        Action action = new Action();
        boolean bl = isCustomH5Task = targetCustomTaskConfig != null;
        if (isCustomH5Task) {
            String requestUrl = targetCustomTaskConfig.getCustomTaskUrl(locale, iamUserToken, digiwinAtmcBacklog);
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            action.setRequestUrl(requestUrl);
            action.setIsThirdPartyRequestUrl(Boolean.valueOf(true));
        } else if (StringUtils.hasLength((String)jumpPageId)) {
            action.setDataId(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
            action.setJumpPageId(jumpPageId);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            JSONObject rawData = new JSONObject(2);
            if (StringUtils.hasLength((String)digiwinAtmcBacklog.getProxyToken())) {
                rawData.put("digi-proxy-token", (Object)digiwinAtmcBacklog.getProxyToken());
            }
            rawData.put("isTeamTask", (Object)isTeamTask);
            rawData.put("pinning", (Object)digiwinAtmcBacklog.getPinning());
            if (isNeedTaskExtraParameter) {
                rawData.put("taskExtraParameter", (Object)new TaskExtraParameter(digiwinAtmcBacklog.getAppCode(), digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmCategory(), digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmTaskId()));
            }
            action.setRawData((Object)rawData);
        } else {
            action.setDataId(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
            action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
            DigiwinAtmcSearchResult result = new DigiwinAtmcSearchResult();
            result.setEndTime(digiwinAtmcBacklog.getEndTime());
            result.setId(digiwinAtmcBacklog.getBacklogId());
            result.setName(digiwinAtmcBacklog.getName());
            result.setStartTime(digiwinAtmcBacklog.getStartTime());
            result.setType("TASK");
            result.setCode(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
            result.setEngineType("TaskEngine");
            action.setRawData((Object)result);
        }
        return action;
    }

    private static String buildTaskStatusMsg(DigiwinAtmcBacklog digiwinAtmcBacklog, LocaleService localeService, String locale) {
        if (BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getPinning())) {
            return String.format(localeService.getLanguageValue(locale, "\u7531%s\u5206\u4eab"), digiwinAtmcBacklog.getOwnerUserName());
        }
        if (BooleanUtils.isFalse((Boolean)digiwinAtmcBacklog.getIsOwner()) && StringUtils.hasLength((String)digiwinAtmcBacklog.getAuxiliaryTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "\u4ee3%s\u5904\u7406, \u8f85\u52a9%s"), digiwinAtmcBacklog.getOwnerUserName(), digiwinAtmcBacklog.getAuxiliaryTenantName());
        }
        if (BooleanUtils.isFalse((Boolean)digiwinAtmcBacklog.getIsOwner())) {
            return String.format(localeService.getLanguageValue(locale, "\u4ee3%s\u5904\u7406"), digiwinAtmcBacklog.getOwnerUserName());
        }
        if (StringUtils.hasLength((String)digiwinAtmcBacklog.getAuxiliaryTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "\u8f85\u52a9%s"), digiwinAtmcBacklog.getAuxiliaryTenantName());
        }
        if (BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getReassign())) {
            return String.format(localeService.getLanguageValue(locale, "\u8f6c\u6d3e"), new Object[0]);
        }
        if (StringUtils.hasLength((String)digiwinAtmcBacklog.getSourceTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "\u6765\u81ea%s"), digiwinAtmcBacklog.getSourceTenantName());
        }
        if (StringUtils.hasLength((String)digiwinAtmcBacklog.getCrossTenantError())) {
            return digiwinAtmcBacklog.getCrossTenantError();
        }
        return "";
    }

    public static List<TaskSummary> createByBacklogs(List<DigiwinAtmcBacklog> teamBacklogs, TaskFilterService taskFilterService, CustomTaskConfigService customTaskConfigService, PageTaskRelationService pageTaskRelationService, String locale, String iamUserToken, String userId, LocaleService localeService, String tenantId, ActivityFilterService activityFilterService, String tenantVersion) {
        List pageTaskRelationList = activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);
        List customTaskConfigList = customTaskConfigService.listCustomTaskConfig();
        List<TaskSummary> taskSummaries = teamBacklogs.stream().map(digiwinAtmcBacklog -> {
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId())).findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory())).findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ? optPageTaskRelationTaskIdAndActivityId.get().getPageId() : (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
            return TaskSummary.create((String)locale, (String)iamUserToken, (DigiwinAtmcBacklog)digiwinAtmcBacklog, (String)jumpPageId, (List)customTaskConfigList, (boolean)true, (String)userId, (boolean)true, (LocaleService)localeService);
        }).collect(Collectors.toList());
        return taskSummaries;
    }

    public static List<TaskSummary> sortTeamList(List<TaskSummary> teamList) {
        return teamList.stream().sorted((o1, o2) -> {
            LocalDateTime o2EndTime;
            if (o1.getNewly() ^ o2.getNewly()) {
                return o1.getNewly() != false ? -1 : 1;
            }
            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getEndTime());
            if (!o1EndTime.isEqual(o2EndTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getEndTime()))) {
                return o1EndTime.isBefore(o2EndTime) ? -1 : 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public static TaskSummary createTripartiteTodo(String locale, TodoList todoData, LocaleService localeService) {
        TaskSummary taskSummary = new TaskSummary();
        taskSummary.setDataId(String.valueOf(todoData.getId()));
        taskSummary.setIsTripartiteTodo(Boolean.valueOf(true));
        taskSummary.setHasAppPermission(Boolean.valueOf(true));
        taskSummary.setNewly(Boolean.valueOf(todoData.getIsRead() == 0));
        Action action = new Action();
        if (StringUtil.isNotEmpty((CharSequence)todoData.getMobileUrl())) {
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            action.setRequestUrl(todoData.getMobileUrl());
            action.setOpenWebPageTitle(todoData.getAppName());
        } else {
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(localeService.getLanguageValue(locale, "\u79fb\u52a8\u7aef\u6682\u4e0d\u652f\u6301,\u8bf7\u524d\u5f80PC\u7aef\u67e5\u770b"));
        }
        taskSummary.setAction(action);
        if (StringUtil.isEmpty((CharSequence)todoData.getMobileMainTitle()) && StringUtil.isEmpty((CharSequence)todoData.getMobileSubTitle()) && StringUtil.isEmpty((CharSequence)todoData.getMobileLabel()) && StringUtil.isNotEmpty((CharSequence)todoData.getToDoData())) {
            Map map = (Map)JsonUtil.jsonStringToObject((String)todoData.getToDoData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList valueList = new ArrayList(map.values());
            int size = valueList.size();
            if (1 == size) {
                taskSummary.setName(localeService.getLanguageValue(locale, (String)valueList.get(0)));
            }
            if (2 == size) {
                taskSummary.setName(localeService.getLanguageValue(locale, (String)valueList.get(0)));
                taskSummary.setSubTitle(localeService.getLanguageValue(locale, (String)valueList.get(1)));
            }
            if (size > 2) {
                taskSummary.setName(localeService.getLanguageValue(locale, (String)valueList.get(0)));
                taskSummary.setSubTitle(localeService.getLanguageValue(locale, (String)valueList.get(1)));
                String description = String.join((CharSequence)"; ", valueList.subList(2, valueList.size()));
                taskSummary.setDescription(localeService.getLanguageValue(locale, description));
            }
        } else {
            taskSummary.setName(localeService.getLanguageValue(locale, todoData.getMobileMainTitle()));
            taskSummary.setSubTitle(todoData.getMobileSubTitle());
            taskSummary.setDescription(todoData.getMobileLabel());
        }
        return taskSummary;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public Boolean getEmergency() {
        return this.emergency;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEocName() {
        return this.eocName;
    }

    public Boolean getException() {
        return this.exception;
    }

    public TaskExtraParameter getExtraParameter() {
        return this.extraParameter;
    }

    public String getDataId() {
        return this.dataId;
    }

    public Boolean getImportance() {
        return this.importance;
    }

    public String getJumpPageId() {
        return this.jumpPageId;
    }

    public String getJumpPageTitle() {
        return this.jumpPageTitle;
    }

    public String getName() {
        return this.name;
    }

    public String getSubName() {
        return this.subName;
    }

    public Boolean getNewly() {
        return this.newly;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Boolean getProxy() {
        return this.proxy;
    }

    public TaskPerson getProxyPerson() {
        return this.proxyPerson;
    }

    public String getSourceTenantName() {
        return this.sourceTenantName;
    }

    public String getState() {
        return this.state;
    }

    public Action getAction() {
        return this.action;
    }

    public Boolean getFinished() {
        return this.finished;
    }

    public String getCalenderTeamName() {
        return this.calenderTeamName;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public Boolean getTeamEnter() {
        return this.teamEnter;
    }

    public Boolean getIsTeamTask() {
        return this.isTeamTask;
    }

    public Boolean getHasAppPermission() {
        return this.hasAppPermission;
    }

    public Boolean getEngineHasWaittingData() {
        return this.engineHasWaittingData;
    }

    public Boolean getReexecute() {
        return this.reexecute;
    }

    public Boolean getAddTask() {
        return this.addTask;
    }

    public Boolean getReassign() {
        return this.reassign;
    }

    public Boolean getDataChangeRead() {
        return this.dataChangeRead;
    }

    public Boolean getHasDataChanged() {
        return this.hasDataChanged;
    }

    public String getApprovalStateCode() {
        return this.approvalStateCode;
    }

    public Boolean getHandover() {
        return this.handover;
    }

    public Boolean getPinning() {
        return this.pinning;
    }

    public String getDataChangeStatus() {
        return this.dataChangeStatus;
    }

    public String getTaskStatusMsg() {
        return this.taskStatusMsg;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public String getTmActivityName() {
        return this.tmActivityName;
    }

    public String getOriginProjectName() {
        return this.originProjectName;
    }

    public String getShowPlanEndTimeMin() {
        return this.showPlanEndTimeMin;
    }

    public String getShowPlanEndTimeMax() {
        return this.showPlanEndTimeMax;
    }

    public Boolean getOverdue() {
        return this.overdue;
    }

    public List<DigiwinAtmcLabel> getLabels() {
        return this.labels;
    }

    public DigiwinAtmcOrder getOrder() {
        return this.order;
    }

    public DigiwinAtmcGroup getGroup() {
        return this.group;
    }

    public List<DigiwinAtmcCardConfigItem> getCardConfig() {
        return this.cardConfig;
    }

    public Map<String, Object> getBusinessMessage() {
        return this.businessMessage;
    }

    public Boolean getIsTripartiteTodo() {
        return this.isTripartiteTodo;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public void setEmergency(Boolean emergency) {
        this.emergency = emergency;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEocName(String eocName) {
        this.eocName = eocName;
    }

    public void setException(Boolean exception) {
        this.exception = exception;
    }

    public void setExtraParameter(TaskExtraParameter extraParameter) {
        this.extraParameter = extraParameter;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public void setImportance(Boolean importance) {
        this.importance = importance;
    }

    public void setJumpPageId(String jumpPageId) {
        this.jumpPageId = jumpPageId;
    }

    public void setJumpPageTitle(String jumpPageTitle) {
        this.jumpPageTitle = jumpPageTitle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public void setNewly(Boolean newly) {
        this.newly = newly;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProxy(Boolean proxy) {
        this.proxy = proxy;
    }

    public void setProxyPerson(TaskPerson proxyPerson) {
        this.proxyPerson = proxyPerson;
    }

    public void setSourceTenantName(String sourceTenantName) {
        this.sourceTenantName = sourceTenantName;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public void setCalenderTeamName(String calenderTeamName) {
        this.calenderTeamName = calenderTeamName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public void setTeamEnter(Boolean teamEnter) {
        this.teamEnter = teamEnter;
    }

    public void setIsTeamTask(Boolean isTeamTask) {
        this.isTeamTask = isTeamTask;
    }

    public void setIsPccTask(Boolean isPccTask) {
        this.isPccTask = isPccTask;
    }

    public void setHasAppPermission(Boolean hasAppPermission) {
        this.hasAppPermission = hasAppPermission;
    }

    public void setEngineHasWaittingData(Boolean engineHasWaittingData) {
        this.engineHasWaittingData = engineHasWaittingData;
    }

    public void setReexecute(Boolean reexecute) {
        this.reexecute = reexecute;
    }

    public void setAddTask(Boolean addTask) {
        this.addTask = addTask;
    }

    public void setReassign(Boolean reassign) {
        this.reassign = reassign;
    }

    public void setDataChangeRead(Boolean dataChangeRead) {
        this.dataChangeRead = dataChangeRead;
    }

    public void setHasDataChanged(Boolean hasDataChanged) {
        this.hasDataChanged = hasDataChanged;
    }

    public void setApprovalStateCode(String approvalStateCode) {
        this.approvalStateCode = approvalStateCode;
    }

    public void setHandover(Boolean handover) {
        this.handover = handover;
    }

    public void setPinning(Boolean pinning) {
        this.pinning = pinning;
    }

    public void setDataChangeStatus(String dataChangeStatus) {
        this.dataChangeStatus = dataChangeStatus;
    }

    public void setTaskStatusMsg(String taskStatusMsg) {
        this.taskStatusMsg = taskStatusMsg;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public void setTmActivityName(String tmActivityName) {
        this.tmActivityName = tmActivityName;
    }

    public void setOriginProjectName(String originProjectName) {
        this.originProjectName = originProjectName;
    }

    public void setShowPlanEndTimeMin(String showPlanEndTimeMin) {
        this.showPlanEndTimeMin = showPlanEndTimeMin;
    }

    public void setShowPlanEndTimeMax(String showPlanEndTimeMax) {
        this.showPlanEndTimeMax = showPlanEndTimeMax;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    public void setLabels(List<DigiwinAtmcLabel> labels) {
        this.labels = labels;
    }

    public void setOrder(DigiwinAtmcOrder order) {
        this.order = order;
    }

    public void setGroup(DigiwinAtmcGroup group) {
        this.group = group;
    }

    public void setCardConfig(List<DigiwinAtmcCardConfigItem> cardConfig) {
        this.cardConfig = cardConfig;
    }

    public void setBusinessMessage(Map<String, Object> businessMessage) {
        this.businessMessage = businessMessage;
    }

    public void setIsTripartiteTodo(Boolean isTripartiteTodo) {
        this.isTripartiteTodo = isTripartiteTodo;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSummary)) {
            return false;
        }
        TaskSummary other = (TaskSummary)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$emergency = this.getEmergency();
        Boolean other$emergency = other.getEmergency();
        if (this$emergency == null ? other$emergency != null : !((Object)this$emergency).equals(other$emergency)) {
            return false;
        }
        Boolean this$exception = this.getException();
        Boolean other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        Boolean this$importance = this.getImportance();
        Boolean other$importance = other.getImportance();
        if (this$importance == null ? other$importance != null : !((Object)this$importance).equals(other$importance)) {
            return false;
        }
        Boolean this$newly = this.getNewly();
        Boolean other$newly = other.getNewly();
        if (this$newly == null ? other$newly != null : !((Object)this$newly).equals(other$newly)) {
            return false;
        }
        Boolean this$proxy = this.getProxy();
        Boolean other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Boolean this$finished = this.getFinished();
        Boolean other$finished = other.getFinished();
        if (this$finished == null ? other$finished != null : !((Object)this$finished).equals(other$finished)) {
            return false;
        }
        Boolean this$teamEnter = this.getTeamEnter();
        Boolean other$teamEnter = other.getTeamEnter();
        if (this$teamEnter == null ? other$teamEnter != null : !((Object)this$teamEnter).equals(other$teamEnter)) {
            return false;
        }
        Boolean this$isTeamTask = this.getIsTeamTask();
        Boolean other$isTeamTask = other.getIsTeamTask();
        if (this$isTeamTask == null ? other$isTeamTask != null : !((Object)this$isTeamTask).equals(other$isTeamTask)) {
            return false;
        }
        Boolean this$isPccTask = this.getIsPccTask();
        Boolean other$isPccTask = other.getIsPccTask();
        if (this$isPccTask == null ? other$isPccTask != null : !((Object)this$isPccTask).equals(other$isPccTask)) {
            return false;
        }
        Boolean this$hasAppPermission = this.getHasAppPermission();
        Boolean other$hasAppPermission = other.getHasAppPermission();
        if (this$hasAppPermission == null ? other$hasAppPermission != null : !((Object)this$hasAppPermission).equals(other$hasAppPermission)) {
            return false;
        }
        Boolean this$engineHasWaittingData = this.getEngineHasWaittingData();
        Boolean other$engineHasWaittingData = other.getEngineHasWaittingData();
        if (this$engineHasWaittingData == null ? other$engineHasWaittingData != null : !((Object)this$engineHasWaittingData).equals(other$engineHasWaittingData)) {
            return false;
        }
        Boolean this$reexecute = this.getReexecute();
        Boolean other$reexecute = other.getReexecute();
        if (this$reexecute == null ? other$reexecute != null : !((Object)this$reexecute).equals(other$reexecute)) {
            return false;
        }
        Boolean this$addTask = this.getAddTask();
        Boolean other$addTask = other.getAddTask();
        if (this$addTask == null ? other$addTask != null : !((Object)this$addTask).equals(other$addTask)) {
            return false;
        }
        Boolean this$reassign = this.getReassign();
        Boolean other$reassign = other.getReassign();
        if (this$reassign == null ? other$reassign != null : !((Object)this$reassign).equals(other$reassign)) {
            return false;
        }
        Boolean this$dataChangeRead = this.getDataChangeRead();
        Boolean other$dataChangeRead = other.getDataChangeRead();
        if (this$dataChangeRead == null ? other$dataChangeRead != null : !((Object)this$dataChangeRead).equals(other$dataChangeRead)) {
            return false;
        }
        Boolean this$hasDataChanged = this.getHasDataChanged();
        Boolean other$hasDataChanged = other.getHasDataChanged();
        if (this$hasDataChanged == null ? other$hasDataChanged != null : !((Object)this$hasDataChanged).equals(other$hasDataChanged)) {
            return false;
        }
        Boolean this$handover = this.getHandover();
        Boolean other$handover = other.getHandover();
        if (this$handover == null ? other$handover != null : !((Object)this$handover).equals(other$handover)) {
            return false;
        }
        Boolean this$pinning = this.getPinning();
        Boolean other$pinning = other.getPinning();
        if (this$pinning == null ? other$pinning != null : !((Object)this$pinning).equals(other$pinning)) {
            return false;
        }
        Boolean this$overdue = this.getOverdue();
        Boolean other$overdue = other.getOverdue();
        if (this$overdue == null ? other$overdue != null : !((Object)this$overdue).equals(other$overdue)) {
            return false;
        }
        Boolean this$isTripartiteTodo = this.getIsTripartiteTodo();
        Boolean other$isTripartiteTodo = other.getIsTripartiteTodo();
        if (this$isTripartiteTodo == null ? other$isTripartiteTodo != null : !((Object)this$isTripartiteTodo).equals(other$isTripartiteTodo)) {
            return false;
        }
        String this$contentUrl = this.getContentUrl();
        String other$contentUrl = other.getContentUrl();
        if (this$contentUrl == null ? other$contentUrl != null : !this$contentUrl.equals(other$contentUrl)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$eocName = this.getEocName();
        String other$eocName = other.getEocName();
        if (this$eocName == null ? other$eocName != null : !this$eocName.equals(other$eocName)) {
            return false;
        }
        TaskExtraParameter this$extraParameter = this.getExtraParameter();
        TaskExtraParameter other$extraParameter = other.getExtraParameter();
        if (this$extraParameter == null ? other$extraParameter != null : !this$extraParameter.equals(other$extraParameter)) {
            return false;
        }
        String this$dataId = this.getDataId();
        String other$dataId = other.getDataId();
        if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
            return false;
        }
        String this$jumpPageId = this.getJumpPageId();
        String other$jumpPageId = other.getJumpPageId();
        if (this$jumpPageId == null ? other$jumpPageId != null : !this$jumpPageId.equals(other$jumpPageId)) {
            return false;
        }
        String this$jumpPageTitle = this.getJumpPageTitle();
        String other$jumpPageTitle = other.getJumpPageTitle();
        if (this$jumpPageTitle == null ? other$jumpPageTitle != null : !this$jumpPageTitle.equals(other$jumpPageTitle)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$subName = this.getSubName();
        String other$subName = other.getSubName();
        if (this$subName == null ? other$subName != null : !this$subName.equals(other$subName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        TaskPerson this$proxyPerson = this.getProxyPerson();
        TaskPerson other$proxyPerson = other.getProxyPerson();
        if (this$proxyPerson == null ? other$proxyPerson != null : !this$proxyPerson.equals(other$proxyPerson)) {
            return false;
        }
        String this$sourceTenantName = this.getSourceTenantName();
        String other$sourceTenantName = other.getSourceTenantName();
        if (this$sourceTenantName == null ? other$sourceTenantName != null : !this$sourceTenantName.equals(other$sourceTenantName)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$calenderTeamName = this.getCalenderTeamName();
        String other$calenderTeamName = other.getCalenderTeamName();
        if (this$calenderTeamName == null ? other$calenderTeamName != null : !this$calenderTeamName.equals(other$calenderTeamName)) {
            return false;
        }
        String this$executorName = this.getExecutorName();
        String other$executorName = other.getExecutorName();
        if (this$executorName == null ? other$executorName != null : !this$executorName.equals(other$executorName)) {
            return false;
        }
        String this$approvalStateCode = this.getApprovalStateCode();
        String other$approvalStateCode = other.getApprovalStateCode();
        if (this$approvalStateCode == null ? other$approvalStateCode != null : !this$approvalStateCode.equals(other$approvalStateCode)) {
            return false;
        }
        String this$dataChangeStatus = this.getDataChangeStatus();
        String other$dataChangeStatus = other.getDataChangeStatus();
        if (this$dataChangeStatus == null ? other$dataChangeStatus != null : !this$dataChangeStatus.equals(other$dataChangeStatus)) {
            return false;
        }
        String this$taskStatusMsg = this.getTaskStatusMsg();
        String other$taskStatusMsg = other.getTaskStatusMsg();
        if (this$taskStatusMsg == null ? other$taskStatusMsg != null : !this$taskStatusMsg.equals(other$taskStatusMsg)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        String this$tmActivityName = this.getTmActivityName();
        String other$tmActivityName = other.getTmActivityName();
        if (this$tmActivityName == null ? other$tmActivityName != null : !this$tmActivityName.equals(other$tmActivityName)) {
            return false;
        }
        String this$originProjectName = this.getOriginProjectName();
        String other$originProjectName = other.getOriginProjectName();
        if (this$originProjectName == null ? other$originProjectName != null : !this$originProjectName.equals(other$originProjectName)) {
            return false;
        }
        String this$showPlanEndTimeMin = this.getShowPlanEndTimeMin();
        String other$showPlanEndTimeMin = other.getShowPlanEndTimeMin();
        if (this$showPlanEndTimeMin == null ? other$showPlanEndTimeMin != null : !this$showPlanEndTimeMin.equals(other$showPlanEndTimeMin)) {
            return false;
        }
        String this$showPlanEndTimeMax = this.getShowPlanEndTimeMax();
        String other$showPlanEndTimeMax = other.getShowPlanEndTimeMax();
        if (this$showPlanEndTimeMax == null ? other$showPlanEndTimeMax != null : !this$showPlanEndTimeMax.equals(other$showPlanEndTimeMax)) {
            return false;
        }
        List this$labels = this.getLabels();
        List other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        DigiwinAtmcOrder this$order = this.getOrder();
        DigiwinAtmcOrder other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        DigiwinAtmcGroup this$group = this.getGroup();
        DigiwinAtmcGroup other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        List this$cardConfig = this.getCardConfig();
        List other$cardConfig = other.getCardConfig();
        if (this$cardConfig == null ? other$cardConfig != null : !((Object)this$cardConfig).equals(other$cardConfig)) {
            return false;
        }
        Map this$businessMessage = this.getBusinessMessage();
        Map other$businessMessage = other.getBusinessMessage();
        if (this$businessMessage == null ? other$businessMessage != null : !((Object)this$businessMessage).equals(other$businessMessage)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $emergency = this.getEmergency();
        result = result * 59 + ($emergency == null ? 43 : ((Object)$emergency).hashCode());
        Boolean $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        Boolean $importance = this.getImportance();
        result = result * 59 + ($importance == null ? 43 : ((Object)$importance).hashCode());
        Boolean $newly = this.getNewly();
        result = result * 59 + ($newly == null ? 43 : ((Object)$newly).hashCode());
        Boolean $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Boolean $finished = this.getFinished();
        result = result * 59 + ($finished == null ? 43 : ((Object)$finished).hashCode());
        Boolean $teamEnter = this.getTeamEnter();
        result = result * 59 + ($teamEnter == null ? 43 : ((Object)$teamEnter).hashCode());
        Boolean $isTeamTask = this.getIsTeamTask();
        result = result * 59 + ($isTeamTask == null ? 43 : ((Object)$isTeamTask).hashCode());
        Boolean $isPccTask = this.getIsPccTask();
        result = result * 59 + ($isPccTask == null ? 43 : ((Object)$isPccTask).hashCode());
        Boolean $hasAppPermission = this.getHasAppPermission();
        result = result * 59 + ($hasAppPermission == null ? 43 : ((Object)$hasAppPermission).hashCode());
        Boolean $engineHasWaittingData = this.getEngineHasWaittingData();
        result = result * 59 + ($engineHasWaittingData == null ? 43 : ((Object)$engineHasWaittingData).hashCode());
        Boolean $reexecute = this.getReexecute();
        result = result * 59 + ($reexecute == null ? 43 : ((Object)$reexecute).hashCode());
        Boolean $addTask = this.getAddTask();
        result = result * 59 + ($addTask == null ? 43 : ((Object)$addTask).hashCode());
        Boolean $reassign = this.getReassign();
        result = result * 59 + ($reassign == null ? 43 : ((Object)$reassign).hashCode());
        Boolean $dataChangeRead = this.getDataChangeRead();
        result = result * 59 + ($dataChangeRead == null ? 43 : ((Object)$dataChangeRead).hashCode());
        Boolean $hasDataChanged = this.getHasDataChanged();
        result = result * 59 + ($hasDataChanged == null ? 43 : ((Object)$hasDataChanged).hashCode());
        Boolean $handover = this.getHandover();
        result = result * 59 + ($handover == null ? 43 : ((Object)$handover).hashCode());
        Boolean $pinning = this.getPinning();
        result = result * 59 + ($pinning == null ? 43 : ((Object)$pinning).hashCode());
        Boolean $overdue = this.getOverdue();
        result = result * 59 + ($overdue == null ? 43 : ((Object)$overdue).hashCode());
        Boolean $isTripartiteTodo = this.getIsTripartiteTodo();
        result = result * 59 + ($isTripartiteTodo == null ? 43 : ((Object)$isTripartiteTodo).hashCode());
        String $contentUrl = this.getContentUrl();
        result = result * 59 + ($contentUrl == null ? 43 : $contentUrl.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $eocName = this.getEocName();
        result = result * 59 + ($eocName == null ? 43 : $eocName.hashCode());
        TaskExtraParameter $extraParameter = this.getExtraParameter();
        result = result * 59 + ($extraParameter == null ? 43 : $extraParameter.hashCode());
        String $dataId = this.getDataId();
        result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
        String $jumpPageId = this.getJumpPageId();
        result = result * 59 + ($jumpPageId == null ? 43 : $jumpPageId.hashCode());
        String $jumpPageTitle = this.getJumpPageTitle();
        result = result * 59 + ($jumpPageTitle == null ? 43 : $jumpPageTitle.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $subName = this.getSubName();
        result = result * 59 + ($subName == null ? 43 : $subName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        TaskPerson $proxyPerson = this.getProxyPerson();
        result = result * 59 + ($proxyPerson == null ? 43 : $proxyPerson.hashCode());
        String $sourceTenantName = this.getSourceTenantName();
        result = result * 59 + ($sourceTenantName == null ? 43 : $sourceTenantName.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $calenderTeamName = this.getCalenderTeamName();
        result = result * 59 + ($calenderTeamName == null ? 43 : $calenderTeamName.hashCode());
        String $executorName = this.getExecutorName();
        result = result * 59 + ($executorName == null ? 43 : $executorName.hashCode());
        String $approvalStateCode = this.getApprovalStateCode();
        result = result * 59 + ($approvalStateCode == null ? 43 : $approvalStateCode.hashCode());
        String $dataChangeStatus = this.getDataChangeStatus();
        result = result * 59 + ($dataChangeStatus == null ? 43 : $dataChangeStatus.hashCode());
        String $taskStatusMsg = this.getTaskStatusMsg();
        result = result * 59 + ($taskStatusMsg == null ? 43 : $taskStatusMsg.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        String $tmActivityName = this.getTmActivityName();
        result = result * 59 + ($tmActivityName == null ? 43 : $tmActivityName.hashCode());
        String $originProjectName = this.getOriginProjectName();
        result = result * 59 + ($originProjectName == null ? 43 : $originProjectName.hashCode());
        String $showPlanEndTimeMin = this.getShowPlanEndTimeMin();
        result = result * 59 + ($showPlanEndTimeMin == null ? 43 : $showPlanEndTimeMin.hashCode());
        String $showPlanEndTimeMax = this.getShowPlanEndTimeMax();
        result = result * 59 + ($showPlanEndTimeMax == null ? 43 : $showPlanEndTimeMax.hashCode());
        List $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        DigiwinAtmcOrder $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        DigiwinAtmcGroup $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        List $cardConfig = this.getCardConfig();
        result = result * 59 + ($cardConfig == null ? 43 : ((Object)$cardConfig).hashCode());
        Map $businessMessage = this.getBusinessMessage();
        result = result * 59 + ($businessMessage == null ? 43 : ((Object)$businessMessage).hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "TaskSummary(contentUrl=" + this.getContentUrl() + ", emergency=" + this.getEmergency() + ", endTime=" + this.getEndTime() + ", startTime=" + this.getStartTime() + ", eocName=" + this.getEocName() + ", exception=" + this.getException() + ", extraParameter=" + this.getExtraParameter() + ", dataId=" + this.getDataId() + ", importance=" + this.getImportance() + ", jumpPageId=" + this.getJumpPageId() + ", jumpPageTitle=" + this.getJumpPageTitle() + ", name=" + this.getName() + ", subName=" + this.getSubName() + ", newly=" + this.getNewly() + ", projectName=" + this.getProjectName() + ", proxy=" + this.getProxy() + ", proxyPerson=" + this.getProxyPerson() + ", sourceTenantName=" + this.getSourceTenantName() + ", state=" + this.getState() + ", action=" + this.getAction() + ", finished=" + this.getFinished() + ", calenderTeamName=" + this.getCalenderTeamName() + ", executorName=" + this.getExecutorName() + ", teamEnter=" + this.getTeamEnter() + ", isTeamTask=" + this.getIsTeamTask() + ", isPccTask=" + this.getIsPccTask() + ", hasAppPermission=" + this.getHasAppPermission() + ", engineHasWaittingData=" + this.getEngineHasWaittingData() + ", reexecute=" + this.getReexecute() + ", addTask=" + this.getAddTask() + ", reassign=" + this.getReassign() + ", dataChangeRead=" + this.getDataChangeRead() + ", hasDataChanged=" + this.getHasDataChanged() + ", approvalStateCode=" + this.getApprovalStateCode() + ", handover=" + this.getHandover() + ", pinning=" + this.getPinning() + ", dataChangeStatus=" + this.getDataChangeStatus() + ", taskStatusMsg=" + this.getTaskStatusMsg() + ", tmActivityId=" + this.getTmActivityId() + ", tmActivityName=" + this.getTmActivityName() + ", originProjectName=" + this.getOriginProjectName() + ", showPlanEndTimeMin=" + this.getShowPlanEndTimeMin() + ", showPlanEndTimeMax=" + this.getShowPlanEndTimeMax() + ", overdue=" + this.getOverdue() + ", labels=" + this.getLabels() + ", order=" + this.getOrder() + ", group=" + this.getGroup() + ", cardConfig=" + this.getCardConfig() + ", businessMessage=" + this.getBusinessMessage() + ", isTripartiteTodo=" + this.getIsTripartiteTodo() + ", subTitle=" + this.getSubTitle() + ", description=" + this.getDescription() + ")";
    }
}

