/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.service;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListBaseOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSortrSelectedOption;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mapper.PersonalConfigurationMapper;
import com.digiwin.mobile.mobileuibot.model.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.model.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcDomain;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskCardAbstract;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBTaskCard;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.SaveCardSwitchRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveCommonrFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveGroupRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveModuleInfoRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveSeniorFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.TaskContentResult;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="taskService")
public class TaskServiceImpl
implements TaskService {
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Resource
    private PersonalConfigurationMapper personalConfigurationMapper;
    @Resource
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private UserTaskFilterService userTaskFilterService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public TaskContentResult getTaskContentResult(String dataId, String iamUserToken, String tenantId, String locale, String tmCategory, String tmPattern, String type, String tmTaskId, String tmActivityId, String proxyToken) {
        String message = "";
        String abnormalMsg = "";
        List messageList = new ArrayList();
        List cardState = new ArrayList();
        DigiwinAtmcBacklog atmcBacklogForFilter = new DigiwinAtmcBacklog();
        atmcBacklogForFilter.setTmCategory(tmCategory);
        atmcBacklogForFilter.setTmPattern(tmPattern);
        atmcBacklogForFilter.setTmTaskId(tmTaskId);
        atmcBacklogForFilter.setTmActivityId(tmActivityId);
        atmcBacklogForFilter.setType(Integer.valueOf(Integer.parseInt(type)));
        DigiwinAtmcTaskCardAbstract detail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogCardAbstract(locale, iamUserToken, tenantId, dataId, proxyToken);
        message = detail.getTaskContentMsg();
        abnormalMsg = detail.getAbnormaContentMsg();
        messageList = detail.getTaskContentMsgList();
        cardState = detail.getCardState();
        return new TaskContentResult(Boolean.valueOf(!CollectionUtils.isEmpty(cardState)), message, messageList, abnormalMsg);
    }

    public List<TaskProgress> getTaskProgressList(String locale, String iamUserToken, String tenantId, Map<String, Object> requestData, TaskProgressStateEnum taskProgressStateEnum) {
        List digiwinAtmcTaskProgressList = this.digiwinAtmcProxyService.getApprovalTaskSignoffProgress(locale, iamUserToken, tenantId, requestData);
        List<TaskProgress> taskProgressList = digiwinAtmcTaskProgressList.stream().map(digiwinAtmcTaskProcess -> TaskProgress.create((String)locale, (DigiwinAtmcTaskProgress)digiwinAtmcTaskProcess)).collect(Collectors.toList());
        if (null != taskProgressStateEnum) {
            taskProgressList = taskProgressList.stream().filter(taskProgress -> taskProgress.getState().equals(taskProgressStateEnum.getValue())).collect(Collectors.toList());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (TaskProgress taskProgress2 : taskProgressList) {
            if (taskProgress2.getPersonList() == null || taskProgress2.getPersonList().size() <= 0) continue;
            for (TaskProgressPerson taskProgressPerson : taskProgress2.getPersonList()) {
                userIds.add(taskProgressPerson.getUserId());
            }
        }
        List iamUserInfos = this.digiwinIamProxyService.userList(userIds, iamUserToken, locale);
        if (iamUserInfos != null && iamUserInfos.size() > 0) {
            for (TaskProgress taskProgress3 : taskProgressList) {
                if (taskProgress3.getPersonList() == null || taskProgress3.getPersonList().size() <= 0) continue;
                block3: for (TaskProgressPerson taskProgressPerson : taskProgress3.getPersonList()) {
                    for (DigiwinIamUserInfo digiwinIamUserInfo : iamUserInfos) {
                        if (!digiwinIamUserInfo.getId().equals(taskProgressPerson.getUserId())) continue;
                        taskProgressPerson.setDigiwinIamUserInfo(digiwinIamUserInfo);
                        continue block3;
                    }
                }
            }
        }
        return taskProgressList;
    }

    public List<DigiwinAtmcBacklog> getDigiwinAtmcBacklogList(ApiRequest apiRequest) throws IOException {
        List<DigiwinAtmcBacklog> myBacklogs = this.digiwinAtmcProxyService.listMyBacklog(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (myBacklogs.isEmpty()) {
            return myBacklogs;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List filterList = this.activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        if ((myBacklogs = myBacklogs.stream().filter(backlog -> this.taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList)).collect(Collectors.toList())).isEmpty()) {
            return myBacklogs;
        }
        myBacklogs.sort((o1, o2) -> {
            LocalDateTime o2EndTime;
            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getEndTime());
            if (o1EndTime.isBefore(o2EndTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getEndTime()))) {
                return -1;
            }
            if (o1EndTime.isEqual(o2EndTime)) {
                return 0;
            }
            return 1;
        });
        return myBacklogs;
    }

    public List<ZTBTaskCard> getZtbFloatTaskCard(ApiRequest apiRequest) throws IOException {
        List myBacklogs = this.getDigiwinAtmcBacklogList(apiRequest);
        List departures = myBacklogs.stream().filter(log -> TaskStringUtil.isZtbDepartureTaskCard((String)log.getTmTaskId(), (String)log.getTmActivityId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(departures)) {
            departures = myBacklogs.stream().filter(log -> TaskStringUtil.isZtbTransportTaskCard((String)log.getTmTaskId(), (String)log.getTmActivityId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(departures)) {
            return Collections.emptyList();
        }
        String endTime = ((DigiwinAtmcBacklog)departures.get(0)).getEndTime();
        String hour = endTime.substring(0, endTime.length() - 6);
        if ((departures = departures.stream().filter(log -> hour.equals(log.getEndTime().substring(0, log.getEndTime().length() - 6))).collect(Collectors.toList())).size() > 5) {
            departures = departures.subList(0, 5);
        }
        return departures.stream().map(backlog -> {
            ZTBTaskCard card = new ZTBTaskCard();
            card.setTaskCardType(Integer.valueOf(1));
            BeanUtils.copyProperties((Object)backlog, (Object)card);
            if (TaskStringUtil.isZtbDepartureTaskCard((String)card.getTmTaskId(), (String)card.getTmActivityId())) {
                card.setTaskCardType(Integer.valueOf(0));
            }
            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("digi-proxy-token", (Object)card.getProxyToken());
            UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), StringUtil.valueOf((Object)card.getBacklogId()), card.getTmTaskId(), card.getTmActivityId(), apiRawData);
            String taskNo = "";
            String transportNo = "";
            List deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information");
            if (!CollectionUtils.isEmpty((Collection)deliveryDetailList)) {
                taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
                transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
            }
            DigiwinTransportResponse transportMainInfo = this.digiwinEspProxyService.getTransportMainInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo);
            card.setPcUiBotModel(pcUiBotModel);
            card.setTransport(transportMainInfo);
            card.setTaskNo(taskNo);
            card.setTransportNo(transportNo);
            return card;
        }).collect(Collectors.toList());
    }

    public long getZtbTransportTaskCardCount(ApiRequest apiRequest) throws IOException {
        List myBacklogs = this.getDigiwinAtmcBacklogList(apiRequest);
        return myBacklogs.stream().filter(log -> TaskStringUtil.isZtbTransportTaskCard((String)log.getTmTaskId(), (String)log.getTmActivityId())).count();
    }

    public Boolean taskImportance(ApiRequest apiRequest, Boolean isCare) {
        String importanceValue = BooleanUtils.isTrue((Boolean)isCare) ? "1" : "0";
        Boolean isSuccess = null;
        try {
            isSuccess = this.digiwinAtmcProxyService.backlogImportance(apiRequest.getDataId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), importanceValue);
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl taskImportance error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Boolean cancelPinning(ApiRequest apiRequest) {
        HashMap<String, Object> cancelPinningParamMap = new HashMap<String, Object>();
        cancelPinningParamMap.put("mainTaskId", Long.valueOf(apiRequest.getDataId()));
        cancelPinningParamMap.put("pinningUser", apiRequest.getUserId());
        cancelPinningParamMap.put("type", 2);
        Boolean isSuccess = null;
        try {
            isSuccess = this.digiwinAtmcProxyService.cancelPinning(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), cancelPinningParamMap);
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl cancelPinning error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Boolean saveSwitchGroupRecord(SaveGroupRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            isSuccess = this.userTaskFilterService.insertUserTaskFilterByGroupFilterIds(userTaskFilter, apiRequest.getGroupKey());
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl saveSwitchGroupRecord error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Boolean saveModuleInfo(SaveModuleInfoRequest apiRequest) {
        Boolean isSuccess = null;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        String sortFilter = "";
        if (!CollectionUtils.isEmpty((Collection)apiRequest.getSortFilterList())) {
            List cardListSortrSelectedOptionList = apiRequest.getSortFilterList().stream().map(item -> {
                CardListSortrSelectedOption cardListSortrSelectedOption = new CardListSortrSelectedOption();
                cardListSortrSelectedOption.setCode(item.getFilterId());
                if (!CollectionUtils.isEmpty((Collection)item.getFilterOptionList())) {
                    List selectOptionList = item.getFilterOptionList().stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getIsSelect())).map(CardListBaseOption::getFilterOptionId).collect(Collectors.toList());
                    cardListSortrSelectedOption.setValueOptionList(selectOptionList);
                }
                return cardListSortrSelectedOption;
            }).collect(Collectors.toList());
            sortFilter = JsonUtil.javaObjectToJsonString(cardListSortrSelectedOptionList);
        }
        try {
            isSuccess = this.userTaskFilterService.insertUserTaskFilterBySortFilterIds(userTaskFilter, sortFilter);
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl saveModuleInfo error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Boolean saveCardSwitch(SaveCardSwitchRequest apiRequest) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("userId", apiRequest.getUserId());
        params.put("tenantId", apiRequest.getTenantId());
        PersonalConfiguration personalConfiguration = this.personalConfigurationMapper.getByMap(params);
        Date currentTime = new Date(System.currentTimeMillis());
        if (null == personalConfiguration) {
            personalConfiguration = new PersonalConfiguration();
            personalConfiguration.setUserId(apiRequest.getUserId());
            personalConfiguration.setTenantId(apiRequest.getTenantId());
            personalConfiguration.setCreateTime(currentTime);
            this.handlePersonalConfiguration(apiRequest, personalConfiguration);
            return this.personalConfigurationMapper.insertData(personalConfiguration);
        }
        personalConfiguration.setUpdateTime(currentTime);
        this.handlePersonalConfiguration(apiRequest, personalConfiguration);
        return this.personalConfigurationMapper.updateData(personalConfiguration);
    }

    public Boolean saveCommonFilterRecord(SaveCommonrFilterRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            String commonFilter = "";
            if (!CollectionUtils.isEmpty((Collection)apiRequest.getSelectedOptionList())) {
                commonFilter = JsonUtil.javaObjectToJsonString((Object)apiRequest.getSelectedOptionList());
            }
            isSuccess = this.userTaskFilterService.insertUserTaskFilterByCommonFilter(userTaskFilter, commonFilter);
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl saveCommonFilterRecord error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Boolean saveSeniorFilterRecord(SaveSeniorFilterRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            String seniorFilter = "";
            if (!CollectionUtils.isEmpty((Collection)apiRequest.getSelectedOptionList())) {
                seniorFilter = JsonUtil.javaObjectToJsonString((Object)apiRequest.getSelectedOptionList());
            }
            isSuccess = this.userTaskFilterService.insertUserTaskFilterBySeniorFilter(userTaskFilter, seniorFilter);
        }
        catch (Exception e) {
            logger.error("TaskServiceImpl saveSwitchGroupRecord error :", (Throwable)e);
        }
        return isSuccess;
    }

    public Action buildQrCodeSearchTaskAction(ApiRequest apiRequest, Map<String, Object> condition) {
        String kw;
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_QRCODE_SEARCH_TODO_LIST.toString());
        action.setJumpPageTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u4efb\u52a1\u67e5\u8be2"));
        if (ObjectUtils.isEmpty((Object)condition.get("d"))) {
            return action;
        }
        Map data = (Map)condition.get("d");
        if (data.containsKey("kw") && StringUtils.isNotEmpty((CharSequence)(kw = MapUtils.getString((Map)data, (Object)"kw")))) {
            kw = kw.replaceAll("&", " ");
            Set searchedBacklogIds = this.digiwinAtmcProxyService.taskSearch(kw, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getClientId());
            return this.buildResp(searchedBacklogIds, action, apiRequest);
        }
        if (data.containsKey("bk")) {
            Map bk = (Map)MapUtil.getOrDefault((Map)data, (String)"bk", Collections.emptyMap());
            HashMap<String, String> domainSearchMap = new HashMap<String, String>();
            domainSearchMap.put("method", "withBK");
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("domainType", "task");
            parameterMap.put("domainSearch", domainSearchMap);
            HashMap<String, Map> param = new HashMap<String, Map>(2);
            param.put("parameter", parameterMap);
            param.put("data", bk);
            DigiwinAtmcDomain domainSearchResp = this.digiwinAtmcProxyService.domainSearch(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), param);
            if (Objects.nonNull(domainSearchResp)) {
                Set searchedBacklogIds = domainSearchResp.getDomainList().stream().map(e -> e.getDomainId().toString()).collect(Collectors.toSet());
                return this.buildResp(searchedBacklogIds, action, apiRequest);
            }
        }
        return action;
    }

    private Action buildResp(Set<String> searchedBacklogIds, Action action, ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty(searchedBacklogIds)) {
            return action;
        }
        List digiwinAtmcBacklogList = this.digiwinAtmcProxyService.getBacklogListByIds(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), new ArrayList<String>(searchedBacklogIds));
        if (CollectionUtils.isEmpty((Collection)digiwinAtmcBacklogList)) {
            return action;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List filterList = this.activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        if (CollectionUtils.isEmpty(digiwinAtmcBacklogList = digiwinAtmcBacklogList.stream().filter(backlog -> this.taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList)).collect(Collectors.toList()))) {
            return action;
        }
        if (digiwinAtmcBacklogList.size() == 1) {
            TodoList todoList = new TodoList();
            this.uiBotModelBuildMyTaskListStrategy.paddingMobileTaskListFormWithOutFilterList(apiRequest, digiwinAtmcBacklogList, todoList, false, tenantVersion);
            return Optional.ofNullable(todoList.getTodoList()).map(e -> (TaskSummary)e.get(0)).map(TaskSummary::getAction).orElse(action);
        }
        HashMap rawDataMap = new HashMap(1);
        rawDataMap.put("searchedBacklogList", digiwinAtmcBacklogList);
        action.setRawData(rawDataMap);
        return action;
    }

    private void handlePersonalConfiguration(SaveCardSwitchRequest apiRequest, PersonalConfiguration personalConfiguration) {
        if ("eocName".equalsIgnoreCase(apiRequest.getId())) {
            personalConfiguration.setShowEoc(apiRequest.getIsSelect());
        }
        if ("engineHasWaittingData".equalsIgnoreCase(apiRequest.getId())) {
            personalConfiguration.setShowHandledCard(apiRequest.getIsSelect());
        }
    }
}

