/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component(value="taskDetailBuildBizAssistanStrategy")
public class TaskDetailBuildBizAssistanStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildBizAssistanStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private TitleBodyBizReportBuilder titleBodyBizReportBuilder;
    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    private Boolean hasEditableColumn = false;

    public String getTaskDetailType() {
        return "BUSINESS_ASSISTAN_ASSISTAN";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
        int dynamicComponentPlaceholderIndex = 0;
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        block14: for (int i = 0; i < pageSettingModel.getLayout().size(); ++i) {
            String type;
            UiBotLayout pageSettingLayout = (UiBotLayout)pageSettingModel.getLayout().get(i);
            switch (type = pageSettingLayout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizReport.put((Object)pageSettingLayout.getSchema(), (Object)this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    continue block14;
                }
                case "${COMPONENT_TYPE}": {
                    dynamicComponentPlaceholderIndex = i;
                    this.handleHead(pcUiBotModel, taskDetailBizReport, true);
                    continue block14;
                }
                case "TABS": {
                    ArrayList<String> tableTargetLayoutTypeList = new ArrayList<String>();
                    tableTargetLayoutTypeList.add("TABLE");
                    ArrayList<String> tableParentLayoutTypeList = new ArrayList<String>();
                    tableParentLayoutTypeList.add("FORM_LIST");
                    UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
                    UiBotPageData tablePageData = tableUiBotModel.getPageData();
                    List tableLayoutList = tableUiBotModel.getLayout();
                    if (tableLayoutList.isEmpty()) continue block14;
                    ArrayList<String> contentTargetLayoutTypeList = new ArrayList<String>();
                    contentTargetLayoutTypeList.add("CONTENT_QUERY_BUTTON");
                    UiBotModel contentUiBotModel = pcUiBotModel.searchPcTargetModel(contentTargetLayoutTypeList, new ArrayList(), true);
                    List queryButtonList = Optional.ofNullable(contentUiBotModel.getLayout().stream().findFirst().orElse(new UiBotLayout()).getQueryButtons()).orElse(new ArrayList());
                    if (queryButtonList.size() < 1) continue block14;
                    String tabTitle1 = queryButtonList.stream().findFirst().orElse(new UiBotQueryButton()).getQueryTitle();
                    tabTitle1 = tabTitle1 == null ? "" : tabTitle1;
                    TabsComponent tabsComponent = TabsComponent.build((UiBotLayout)((UiBotLayout)tableLayoutList.get(0)), (UiBotPageData)tablePageData, (String)tabTitle1);
                    if (queryButtonList.size() > 1) {
                        for (int j = 1; j < queryButtonList.size(); ++j) {
                            Map map = (Map)JsonUtil.objectToJavaObject(queryButtonList.get(j), Map.class);
                            map.put("executeContext", pcUiBotModel.getExecuteContext());
                            UiBotModel tabUibotModel = this.digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)map));
                            UiBotModel tableUiBotModel2 = tabUibotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
                            tabsComponent.addTab((UiBotLayout)tableUiBotModel2.getLayout().get(0), tableUiBotModel2.getPageData(), ((UiBotQueryButton)queryButtonList.get(j)).getQueryTitle());
                            this.handleHead(tabUibotModel, taskDetailBizReport, false);
                        }
                    }
                    taskDetailBizReport.put((Object)pageSettingLayout.getSchema(), (Object)tabsComponent);
                    continue block14;
                }
                case "BOTTOM_BUTTON": {
                    taskDetailBizReport.put((Object)pageSettingLayout.getSchema(), (Object)this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, BottomButtonList.class, args));
                    continue block14;
                }
                case "BLANK_AREA": {
                    taskDetailBizReport.put((Object)pageSettingLayout.getSchema(), JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)pageSettingModel.getPageData().get((Object)pageSettingLayout.getSchema())), BlankArea.class));
                    continue block14;
                }
            }
        }
        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex, taskDetailBizReport.getActualLayoutList());
        pageSettingModel.getLayout().remove(dynamicComponentPlaceholderIndex + taskDetailBizReport.getActualLayoutList().size());
        return taskDetailBizReport;
    }

    void handleHead(UiBotModel uiBotModel, TaskDetailBizReport taskDetailBizReport, boolean first) {
        ArrayList<String> targetLayoutTypeList = new ArrayList<String>();
        targetLayoutTypeList.add("LABEL");
        ArrayList<String> parentLayoutTypeList = new ArrayList<String>();
        parentLayoutTypeList.add("FORM_LIST");
        UiBotModel labelUiBotModel = uiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        List labelLayoutList = labelUiBotModel.getLayout();
        for (UiBotLayout layout : labelLayoutList) {
            Field field = Field.create((String)layout.getHeaderName(), (String)layout.getType(), (String)((String)labelUiBotModel.getPageData().get((Object)layout.getSchema())), (String)layout.getSchema());
            if (StringUtils.hasLength((String)field.getValue())) {
                field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                field.setLabelStyleType(Integer.valueOf(1));
                field.setValueStyleType(Integer.valueOf(2));
                taskDetailBizReport.put((Object)layout.getSchema(), (Object)field);
            }
            if (!first) continue;
            UiBotLayout applayout = new UiBotLayout();
            applayout.setSchema(layout.getSchema());
            applayout.setType("FIELD");
            taskDetailBizReport.addActualLayout(applayout);
        }
    }

    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pageSettingModel, TaskDetailBizReport taskDetailBizReport, Object ... args) {
        String locale = apiRequest.getLocale();
        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();
        if (!searchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = searchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else {
            return;
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout, Object ... args) {
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        if (bizDataList.size() != 1) {
            taskDetailBizReport.addEmptyComponent(apiRequest);
            return;
        }
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List scriptFilterList = pcDataLayout.getScriptFilters();
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        for (Map bizData : bizDataList) {
            taskDetailBizReport.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout, Object ... args) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(mobileRuleList);
        List tableColumns = pcFieldLayoutList.stream().map(UiBotLayout::parseToTableColumn).collect(Collectors.toList());
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        taskDetailBizReport.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
    }

    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, UiBotLayout layout, TaskDetailBizReport taskDetailBizReport, Object ... args) {
        PageDescBuilder pageDescBuilder = this.pageDescBuilderFactory.get("BUSINESS_REPORT");
        if (layout.getType().equalsIgnoreCase(pageDescBuilder.getMobileComponentType())) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)pageDescBuilder.buildEmpty());
        } else if (layout.getType().equalsIgnoreCase(this.titleBodyBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
        } else if (layout.getType().equalsIgnoreCase(this.bottomButtonBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, BottomButtonList.class, args));
        } else if (layout.getType().equalsIgnoreCase("TABS")) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)new TabsComponent());
        }
    }
}

