/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButtonLabelStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.OperatorData;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgressWorkItem;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="taskDetailBuildBizReportStrategy")
public class TaskDetailBuildBizReportStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildBizReportStrategy.class);
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private TitleBodyBizReportBuilder titleBodyBizReportBuilder;
    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    private Boolean hasEditableColumn = false;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    public String getTaskDetailType() {
        return "BUSINESS_REPORT";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        int dynamicComponentPlaceholderIndex = 0;
        for (int i = 0; i < pageSettingModel.getLayout().size(); ++i) {
            UiBotLayout pageSettingLayout = (UiBotLayout)pageSettingModel.getLayout().get(i);
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(pageSettingLayout.getType())) {
                dynamicComponentPlaceholderIndex = i;
                this.processDynamicComponents(apiRequest, pcUiBotModel, pageSettingLayout, taskDetailBizReport, args);
                continue;
            }
            this.processFixedComponents(apiRequest, pageSetting, pcUiBotModel, pageSettingLayout, taskDetailBizReport, args);
        }
        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex, taskDetailBizReport.getActualLayoutList());
        pageSettingModel.getLayout().remove(dynamicComponentPlaceholderIndex + taskDetailBizReport.getActualLayoutList().size());
        return taskDetailBizReport;
    }

    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pageSettingModel, TaskDetailBizReport taskDetailBizReport, Object ... args) {
        UiBotLayout pcDataLayout;
        DigiwinAtmcTaskProgress latestAtmcTaskProgress;
        String locale = apiRequest.getLocale();
        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();
        if (!searchResult.found()) {
            return;
        }
        List digiwinAtmcTaskProgressList = ((List)args[1]).stream().filter(taskProgress -> TaskProgressStateEnum.getByPcStateNumber((Integer)taskProgress.getState()) == TaskProgressStateEnum.DONE && !CollectionUtils.isEmpty((Collection)taskProgress.getWorkitemList())).collect(Collectors.toList());
        int taskProgressListSize = digiwinAtmcTaskProgressList.size();
        DigiwinAtmcTaskProgress digiwinAtmcTaskProgress = latestAtmcTaskProgress = taskProgressListSize > 0 ? (DigiwinAtmcTaskProgress)digiwinAtmcTaskProgressList.get(taskProgressListSize - 1) : null;
        if (null != latestAtmcTaskProgress && args[0] instanceof DigiwinAtmcBacklogDetail) {
            String time;
            String comment;
            String performerName = ((DigiwinAtmcTaskProgressWorkItem)latestAtmcTaskProgress.getWorkitemList().get(0)).getPerformerName();
            if (!StringUtils.hasLength((String)performerName)) {
                performerName = "-";
            }
            if (!StringUtils.hasLength((String)(comment = ((DigiwinAtmcTaskProgressWorkItem)latestAtmcTaskProgress.getWorkitemList().get(0)).getComment()))) {
                comment = "-";
            }
            if (!StringUtils.hasLength((String)(time = ((DigiwinAtmcTaskProgressWorkItem)latestAtmcTaskProgress.getWorkitemList().get(0)).getClosedTime()))) {
                time = "-";
            }
            DigiwinAtmcBacklogDetail backlogDetail = (DigiwinAtmcBacklogDetail)args[0];
            LinkedHashMap<String, String> schemaAndNameMap = new LinkedHashMap<String, String>(3);
            schemaAndNameMap.put("performerName", LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u4eba"));
            schemaAndNameMap.put("comment", LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u539f\u56e0"));
            schemaAndNameMap.put("time", LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u65f6\u95f4"));
            for (String schema : schemaAndNameMap.keySet()) {
                String fieldLabel = backlogDetail.getApprovalState() + (Locale.US.toString().equals(apiRequest.getLocale()) ? " " : "") + (String)schemaAndNameMap.get(schema);
                Object mobileComponent = null;
                mobileComponent = schema.equals("performerName") ? InputSingleText.create((String)fieldLabel, (String)performerName, (boolean)false) : (schema.equals("comment") ? TextMulti.create((String)fieldLabel, (String)comment, (String)apiRequest.getLocale()) : InputSingleText.create((String)fieldLabel, (String)time, (boolean)false));
                taskDetailBizReport.addMobileComponent(schema, (MobileComponent)mobileComponent);
            }
            UiBotLayout firstActualLayout = (UiBotLayout)taskDetailBizReport.getActualLayoutList().get(0);
            if (taskDetailBizReport.get((Object)firstActualLayout.getSchema()) instanceof BaseInputMobileComponent) {
                taskDetailBizReport.addMobileComponent((MobileComponent)Divider.create((DividerTypeEnum)DividerTypeEnum.BLOCK_DIVIDER));
            }
        }
        if ((pcDataLayout = searchResult.getTargetUiBotLayout()).isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else {
            return;
        }
        Map approvalDescription = Optional.ofNullable(pcUiBotModel).map(UiBotModel::getPageData).map(UiBotPageData::getUiBotApprovalDescription).orElse(new HashMap());
        String beforeTaskNo = (String)MapUtil.getOrDefault((Map)approvalDescription, (String)"before_task_no", (Object)"");
        if (StringUtils.hasLength((String)beforeTaskNo)) {
            PageButton pageButton = new PageButton();
            pageButton.setName(this.localeService.getLanguageValue(locale, "\u67e5\u770b\u524d\u7f6e\u4efb\u52a1"));
            pageButton.setStyle(Integer.valueOf(2));
            pageButton.setLabelStyle(PageButtonLabelStyleEnum.EDIT.getType());
            Action pageButtonAction = new Action();
            pageButtonAction.setJumpPageTitle(pageButton.getName());
            pageButtonAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PREVIOUS_MANUAL_TASK_DETAIL.toString());
            pageButtonAction.setType(Integer.valueOf(2));
            HashMap rawData = new HashMap(2);
            rawData.put("project_no", approvalDescription.get("project_no"));
            rawData.put("task_no", approvalDescription.get("task_no"));
            pageButtonAction.setRawData(rawData);
            pageButton.setAction(pageButtonAction);
            taskDetailBizReport.addMobileComponent(8, (MobileComponent)pageButton);
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout, Object ... args) {
        JSONArray operations;
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        String tmActivityId = Optional.ofNullable(pcUiBotModel.getExecuteContext()).map(e -> e.getString("tmActivityId")).orElse("");
        if (CollectionUtils.isEmpty((Collection)bizDataList) && Objects.equals(tmActivityId, "manual_DTD_Assignment")) {
            taskDetailBizReport.addCustomContentComponent(apiRequest);
            return;
        }
        if (bizDataList.size() != 1) {
            taskDetailBizReport.addEmptyComponent(apiRequest);
            return;
        }
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List scriptFilterList = pcDataLayout.getScriptFilters();
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        Optional.ofNullable(pcUiBotModel).map(UiBotModel::getActions).ifPresent(actions -> {
            if (!CollectionUtils.isEmpty((Collection)actions)) {
                pcUiBotModel.getVariableMaps().put("withdraw", actions.stream().anyMatch(item -> Objects.equals("esp_bm.pisc.task.update", item.getActionId())));
            }
        });
        pcUiBotModel.getVariableMaps().put("progressCancel", this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "progressCancel"));
        pcUiBotModel.getVariableMaps().put("isWorkReportRequired", this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "isWorkReportRequired"));
        Map variableListSimpleMap = this.digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), Arrays.asList("isworkHourZero", "isAllowReportAfter"));
        Boolean isworkHourZero = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean((Map)map, (Object)"isworkHourZero")).orElse(true);
        pcUiBotModel.getVariableMaps().put("isworkHourZero", isworkHourZero);
        for (Map bizData : bizDataList) {
            taskDetailBizReport.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
        }
        variableListSimpleMap = Optional.ofNullable(variableListSimpleMap).orElseGet(HashMap::new);
        variableListSimpleMap.put("withdraw", pcUiBotModel.getVariableMaps().get("withdraw"));
        this.handleTaskDetailBizReportRule(taskDetailBizReport, variableListSimpleMap);
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        if (!taskInReadOnlyMode && !CollectionUtils.isEmpty((Collection)(operations = pcDataLayout.getOperations()))) {
            LinkedList<AutoFillData> autoFillDataList = new LinkedList<AutoFillData>();
            String reportAtOnceName = this.localeService.getLanguageValue(locale, "\u4e00\u952e\u62a5\u5de5");
            for (int i = 0; i < operations.size(); ++i) {
                String title = operations.getJSONObject(i).getString("title").trim();
                if (!Objects.equals(title, reportAtOnceName)) continue;
                autoFillDataList.add(AutoFillData.create((String)reportAtOnceName, (UiBotLayout)pcDataLayout, (Map)((Map)bizDataList.get(0)), (Map)variableListSimpleMap));
            }
            String taskCategory = (String)MapUtil.getOrDefault((Map)((Map)bizDataList.get(0)), (String)"task_category", (Object)"");
            Boolean isExistReplaceReport = this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "reportWorkByTaskLiable");
            if (BooleanUtils.isTrue((Boolean)isExistReplaceReport) && "ORD".equalsIgnoreCase(taskCategory)) {
                autoFillDataList.add(AutoFillData.create((ApiRequest)apiRequest, (TaskDetailBizReport)taskDetailBizReport, (LocaleService)this.localeService, (Boolean)isworkHourZero));
            }
            AutoFill autoFill = new AutoFill();
            autoFill.setData(autoFillDataList);
            taskDetailBizReport.addMobileComponent(0, (MobileComponent)autoFill);
        }
    }

    private void handleTaskDetailBizReportRule(TaskDetailBizReport taskDetailBizReport, Map<String, Object> variableListSimpleMap) {
        List ruleList;
        RelationRule relationRule;
        InputCalendar actualStartDate;
        Boolean withdraw = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean((Map)map, (Object)"withdraw")).orElse(false);
        if (BooleanUtils.isTrue((Boolean)withdraw)) {
            return;
        }
        if (taskDetailBizReport.containsKey((Object)"report_type_name")) {
            taskDetailBizReport.remove((Object)"report_type_name");
        }
        Boolean isworkHourZero = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean((Map)map, (Object)"isworkHourZero")).orElse(true);
        if (Objects.nonNull(taskDetailBizReport.get((Object)"work_hours")) && BooleanUtils.isTrue((Boolean)isworkHourZero)) {
            InputNumeric workHours = (InputNumeric)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"work_hours"), InputNumeric.class);
            workHours.setRequired(Boolean.valueOf(true));
            taskDetailBizReport.put((Object)"work_hours", (Object)workHours);
        }
        Boolean isAllowReportAfter = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean((Map)map, (Object)"isAllowReportAfter")).orElse(false);
        if (Objects.nonNull(taskDetailBizReport.get((Object)"report_date"))) {
            InputCalendar reportDate = (InputCalendar)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"report_date"), InputCalendar.class);
            if (BooleanUtils.isTrue((Boolean)isAllowReportAfter)) {
                if (Objects.nonNull(taskDetailBizReport.get((Object)"actual_start_date"))) {
                    actualStartDate = (InputCalendar)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"actual_start_date"), InputCalendar.class);
                    if (CollectionUtils.isEmpty((Collection)actualStartDate.getDateValueList())) {
                        reportDate.setMinDateSelectable(reportDate.getMinDate());
                    } else {
                        reportDate.setMinDateSelectable((InputCalendarDate)actualStartDate.getDateValueList().get(0));
                    }
                }
                reportDate.setRequired(Boolean.valueOf(true));
                reportDate.setMaxDateSelectable(InputCalendarDate.createToday());
            } else {
                reportDate.setEnable(Boolean.valueOf(false));
                ArrayList<InputCalendarDate> dateValueList = new ArrayList<InputCalendarDate>(1);
                dateValueList.add(InputCalendarDate.createToday());
                reportDate.setDateValueList(dateValueList);
            }
            reportDate.getDateValueList().add(InputCalendarDate.createToday());
            taskDetailBizReport.put((Object)"report_date", (Object)reportDate);
        }
        if (Objects.nonNull(taskDetailBizReport.get((Object)"actual_start_date"))) {
            InputCalendar actualStartDate2 = (InputCalendar)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"actual_start_date"), InputCalendar.class);
            relationRule = Optional.ofNullable(actualStartDate2.getRelationRule()).orElse(new RelationRule());
            ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList());
            CommonRule commonRule1 = new CommonRule();
            commonRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
            commonRule1.setTargetSchema("actual_finish_date");
            commonRule1.setTargetText("");
            commonRule1.setTargetHidden(null);
            commonRule1.setTargetEnable(Boolean.valueOf(true));
            ArrayList<TargetDatetime> targetDatetimes = new ArrayList<TargetDatetime>();
            TargetDatetime targetDatetime1 = new TargetDatetime();
            targetDatetime1.setDatetimeType(Integer.valueOf(1));
            targetDatetime1.setLinkageSchema("actual_start_date");
            targetDatetimes.add(targetDatetime1);
            commonRule1.setTargetDatetime(targetDatetimes);
            ruleList.add(commonRule1);
            if (BooleanUtils.isTrue((Boolean)isAllowReportAfter)) {
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("report_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime targetDatetime = new TargetDatetime();
                targetDatetime.setLinkageSchema("actual_start_date");
                targetDatetime.setDatetimeType(Integer.valueOf(1));
                commonRule.setTargetDatetime(Collections.singletonList(targetDatetime));
                ruleList.add(commonRule);
            } else {
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                commonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
                OperatorData operatorData = new OperatorData();
                operatorData.setOperatorSchema("complete_rate");
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(Boolean.valueOf(false));
                commonRule.setTargetEnable(Boolean.valueOf(false));
                commonRule.setTargetRequired(Boolean.valueOf(false));
                ruleList.add(commonRule);
            }
            relationRule.setRuleList(ruleList);
            actualStartDate2.setRelationRule(relationRule);
            taskDetailBizReport.put((Object)"actual_start_date", (Object)actualStartDate2);
        }
        if (Objects.nonNull(taskDetailBizReport.get((Object)"actual_finish_date"))) {
            InputCalendar actualFinishDate = (InputCalendar)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"actual_finish_date"), InputCalendar.class);
            if (BooleanUtils.isTrue((Boolean)isAllowReportAfter)) {
                if (Objects.nonNull(taskDetailBizReport.get((Object)"actual_start_date"))) {
                    actualStartDate = (InputCalendar)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"actual_start_date"), InputCalendar.class);
                    if (CollectionUtils.isEmpty((Collection)actualStartDate.getDateValueList())) {
                        actualFinishDate.setMinDateSelectable(actualFinishDate.getMinDate());
                    } else {
                        actualFinishDate.setMinDateSelectable((InputCalendarDate)actualStartDate.getDateValueList().get(0));
                    }
                }
                actualFinishDate.setMaxDateSelectable(InputCalendarDate.createToday());
            } else {
                actualFinishDate.setEnable(Boolean.valueOf(false));
                actualFinishDate.setDateValueList(Collections.singletonList(InputCalendarDate.createToday()));
            }
            taskDetailBizReport.put((Object)"actual_finish_date", (Object)actualFinishDate);
        }
        if (Objects.nonNull(taskDetailBizReport.get((Object)"complete_rate"))) {
            OperatorData operatorData;
            CommonRule commonRule;
            InputNumeric completeRate = (InputNumeric)JsonUtil.objectToJavaObject((Object)taskDetailBizReport.get((Object)"complete_rate"), InputNumeric.class);
            relationRule = Optional.ofNullable(completeRate.getRelationRule()).orElse(new RelationRule());
            ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList());
            if (BooleanUtils.isTrue((Boolean)isAllowReportAfter)) {
                commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                operatorData = new OperatorData();
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(Boolean.valueOf(false));
                commonRule.setTargetEnable(Boolean.valueOf(true));
                commonRule.setTargetRequired(Boolean.valueOf(true));
                ruleList.add(commonRule);
            } else {
                commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                commonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
                operatorData = new OperatorData();
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(Boolean.valueOf(false));
                commonRule.setTargetEnable(Boolean.valueOf(false));
                commonRule.setTargetRequired(Boolean.valueOf(false));
                ruleList.add(commonRule);
            }
            relationRule.setRuleList(ruleList);
            completeRate.setRelationRule(relationRule);
            taskDetailBizReport.put((Object)"complete_rate", (Object)completeRate);
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout, Object ... args) {
        JSONArray operations;
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(mobileRuleList);
        List tableColumns = pcFieldLayoutList.stream().map(UiBotLayout::parseToTableColumn).collect(Collectors.toList());
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        if (taskInReadOnlyMode && !CollectionUtils.isEmpty((Collection)(operations = pcDataLayout.getOperations()))) {
            LinkedList<AutoFillData> autoFillDataList = new LinkedList<AutoFillData>();
            String reportAtOnceName = this.localeService.getLanguageValue(locale, "\u4e00\u952e\u62a5\u5de5");
            for (int i = 0; i < operations.size(); ++i) {
                String title = operations.getJSONObject(i).getString("title").trim();
                if (!Objects.equals(title, reportAtOnceName)) continue;
                autoFillDataList.add(AutoFillData.create((String)reportAtOnceName, (UiBotLayout)pcDataLayout, (Map)bizData, Collections.emptyMap()));
            }
            AutoFill autoFill = new AutoFill();
            autoFill.setData(autoFillDataList);
            taskDetailBizReport.addMobileComponent(0, (MobileComponent)autoFill);
        }
        pcUiBotModel.getVariableMaps().put("progressCancel", this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "progressCancel"));
        pcUiBotModel.getVariableMaps().put("isWorkReportRequired", this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "isWorkReportRequired"));
        taskDetailBizReport.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
    }

    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, UiBotLayout layout, TaskDetailBizReport taskDetailBizReport, Object ... args) {
        PageDescBuilder pageDescBuilder = this.pageDescBuilderFactory.get("BUSINESS_REPORT");
        if (layout.getType().equalsIgnoreCase(pageDescBuilder.getMobileComponentType())) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)pageDescBuilder.buildEmpty());
        } else if (layout.getType().equalsIgnoreCase(this.titleBodyBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
        } else if (layout.getType().equalsIgnoreCase(this.bottomButtonBizReportBuilder.getMobileComponentType())) {
            List uiBotActions = pcUiBotModel.getActions();
            if (!CollectionUtils.isEmpty((Collection)uiBotActions)) {
                uiBotActions.forEach(e -> {
                    if (BottomButtonBizReportBuilder.BUTTON_MAP.containsKey(e.getActionId())) {
                        e.put((Object)"confirmPop_content", (Object)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f"));
                    }
                });
            }
            taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, BottomButtonList.class, args));
        }
    }
}

