/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDetailBuildBizSmartAdjustStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildBizSmartAdjustStrategy.class);
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;
    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;
    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PageSettingService pageSettingService;

    public String getTaskDetailType() {
        return "custom_task_code_smart_adjust";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType;
            switch (layoutType = layout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)pcUiBotModel.getPageData(), (DigiwinAtmcBacklogDetail)((DigiwinAtmcBacklogDetail)args[0]), (ApiRequest)apiRequest, (Boolean)true, (Boolean)true));
                    break;
                }
                case "PAGE_DESC": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.pageDescBuilderFactory.get("BUSINESS_APPROVAL").build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                }
                case "CARD_ONE": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel, CardOne.class, args));
                    break;
                }
                case "TABS": {
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.buildAllTabs(apiRequest, pcUiBotModel);
                    tabs.forEach(tab -> tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode()));
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)tabs);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    break;
                }
            }
        }
        return taskDetailBizApproval;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        PageSetting newPageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_MY_BIZ_SMART_ADJUST_TASK_DETAIL.name());
        TaskDetail taskDetail = this.build(apiRequest, newPageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(newPageSetting, (Object)taskDetail, Boolean.valueOf(true));
        uiBotModel.setBeforeAction(this.buildBeforeAction(apiRequest.getLocale()));
        return uiBotModel;
    }

    private Action<Map<String, Object>> buildBeforeAction(String locale) {
        Action action = new Action();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(this.localeService.getLanguageValue(locale, "\u63d0\u793a"));
        popPromptMsg.setContent(this.localeService.getLanguageValue(locale, "\u6b64\u4f5c\u4e1a\u672a\u914d\u7f6e\u79fb\u52a8\u7aef\u754c\u9762\uff0c\u6682\u4e0d\u652f\u6301\u63d0\u4ea4\u64cd\u4f5c\n\u8bf7\u524d\u5f80Web\u7aef\u67e5\u9605\u5904\u7406"));
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u786e\u5b9a"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }
}

