/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="taskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy")
public class TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("transferQuantity");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        List paramList = TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy.getMaps((ApiRequest)apiRequest);
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject jsonObject = rawData.getJSONObject("datas");
        int remainingQty = (int)Double.parseDouble(jsonObject.get((Object)"transfer_qty").toString());
        List qtyInfoList = this.digiwinEspProxyService.getTransferQuantityInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, paramList);
        stopWatch.start("Build TransferQuantity Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "SINGLE_SELECT_LIST": {
                    if (!CollUtil.isNotEmpty((Collection)qtyInfoList)) break;
                    SingleSelectList singleSelectList = new SingleSelectList();
                    ArrayList<SingleSelectListOption> optionList = new ArrayList<SingleSelectListOption>();
                    for (Map stringObjectMap : qtyInfoList) {
                        int transferQty = (int)Double.parseDouble(stringObjectMap.get("transfer_qty").toString());
                        boolean selected = transferQty == remainingQty;
                        int qty = Integer.parseInt(stringObjectMap.get("transfer_qty").toString());
                        optionList.add(SingleSelectListOption.transferQuantityCreate((int)qty, (Boolean)selected, (Boolean)false, (int)0, (String)""));
                    }
                    singleSelectList.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9009\u62e9\u8f6c\u79fb\u6570\u91cf"));
                    singleSelectList.setType(Integer.valueOf(1));
                    singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                    singleSelectList.setOptionList(optionList);
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)singleSelectList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    rawData.put("pageId", (Object)apiRequest.getPageId());
                    bottomButtonList.add(BottomButtonDigiwinAthena.createTransferQuantitySubmitButton((String)locale, (Map)rawData));
                    uiBotModel.getPageData().put((Object)fieldSchema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    @NotNull
    private static List<Map<String, Object>> getMaps(ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        Map map = (Map)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"datas"), Map.class);
        return Collections.singletonList(map);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted!", (Throwable)e);
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/mobile_athena_apc_project_schedule_report_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

