/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcWorkHourQuantityConfirmStrategy")
public class TaskDetailBuildApcWorkHourQuantityConfirmStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcWorkHourQuantityConfirmStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        JSONArray woInfoJsonArray = apiRawData.getJSONObject("parameter").getJSONArray("wo_op_report_info");
        JSONObject woInfoJsonObject = woInfoJsonArray.getJSONObject(0);
        List qtyInfoList = this.digiwinEspProxyService.getWoOpReportQtyInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, this.buildApcRequest(woInfoJsonObject));
        stopWatch.start("Build TaskDetailBuildApcWorkHourQuantityConfirmStrategy Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "SINGLE_SELECT_LIST": {
                    if (CollectionUtils.isEmpty((Collection)qtyInfoList)) break;
                    List reportQtyList = qtyInfoList.stream().map(e -> (Integer)e.get("report_qty")).sorted(Collections.reverseOrder()).collect(Collectors.toList());
                    SingleSelectList singleSelectList = new SingleSelectList();
                    ArrayList<SingleSelectListOption> optionList = new ArrayList<SingleSelectListOption>();
                    for (int i = 0; i < reportQtyList.size(); ++i) {
                        boolean selected = i == 0;
                        optionList.add(SingleSelectListOption.create((int)((Integer)reportQtyList.get(i)), (Boolean)selected, (Boolean)false, (int)0, (String)"", (String)""));
                    }
                    singleSelectList.setTitle(this.localeService.getLanguageValue(locale, "\u62a5\u5de5\u6570\u91cf"));
                    singleSelectList.setStyle(Integer.valueOf(1));
                    singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                    singleSelectList.setOptionList(optionList);
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)singleSelectList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    uiBotModel.getPageData().put((Object)fieldSchema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private Map<String, Object> buildApcRequest(JSONObject woInfoJsonObject) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("eoc_company_id", (Object)woInfoJsonObject.getString("eoc_company_id"));
        woReportData.put("eoc_site_id", (Object)woInfoJsonObject.getString("eoc_site_id"));
        woReportData.put("wo_no", (Object)woInfoJsonObject.getString("wo_no"));
        woReportData.put("plot_no", (Object)woInfoJsonObject.getString("plot_no"));
        woReportData.put("op_seq", (Object)woInfoJsonObject.getString("op_seq"));
        woReportData.put("category", (Object)woInfoJsonObject.getString("category"));
        woReportData.put("plan_source", (Object)woInfoJsonObject.getString("plan_source"));
        woReportData.put("remaining_qty", (Object)woInfoJsonObject.getString("remaining_qty"));
        woReportData.put("report_qty", (Object)woInfoJsonObject.getDouble("report_qty"));
        JSONArray array = new JSONArray();
        array.add((Object)woReportData);
        requestMap.put("wo_op_report_data", array);
        return requestMap;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted!", (Throwable)e);
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/mobile_athena_apc_project_schedule_report_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

