/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildApcHandelBottomStrategy")
public class UiBotModelBuildApcHandelBottomStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcHandelBottomStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc handel Bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        stopWatch.start("Build ApcAbnormalReport Handel Bottom Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        Boolean abnormalReturns = this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "abnormalAllowsUploadingAttachments");
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "INPUT_MULTI": {
                    InputMultiText inputMultiText = new InputMultiText();
                    inputMultiText.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165..."));
                    inputMultiText.setRequired(Boolean.valueOf(true));
                    inputMultiText.setText("");
                    inputMultiText.setTitle(this.localeService.getLanguageValue(locale, layout.getLabel()));
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)inputMultiText);
                    break;
                }
                case "ATTACHMENT": {
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)Attachment.create((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)AttachmentStyleTypeEnum.TITLE_NORMAL.getValue(), (Integer)SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_TWO.getValue(), (Integer)AttachmentTypeEnum.READ_AND_WRITE.getValue(), (Boolean)abnormalReturns));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)uiBotModel.getPageData().get((Object)fieldSchema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (!bottomButton.getIsCheckButton().booleanValue()) continue;
                        HashMap<String, Object> newRawData = new HashMap<String, Object>(8);
                        newRawData.putAll((Map<String, Object>)rawData);
                        Action action = bottomButton.getAction();
                        if (BottomButtonStyleEnum.NORMAL.getValue().intValue() == bottomButton.getType().intValue()) {
                            newRawData.put("isReply", true);
                            newRawData.put("actionId", "wo.op.report.abnormal.reply");
                            ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButton, (String)apiRequest.getRefreshPageId());
                        } else {
                            ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButton, (String)"");
                        }
                        action.setRawData(newRawData);
                    }
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)buttons);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

