/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApcSupportNeedsStrategy")
public class UiBotModelBuildApcSupportNeedsStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcSupportNeedsStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "apc_support_needs_workshop_plan_syn_userproject";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        StopWatch stopWatch = new StopWatch("Build Apc support needs");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        ApiRawData apiRawData;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData2 = apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        List datas = (List)pcUiBotModel.getPageData().get((Object)"wo_op_request_support_demand_info");
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)locale);
        }
        if (datas == null) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.createApc((DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (UiBotModel)pcUiBotModel, (String)locale);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Card.class);
                    Card.handle((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Card)card);
                    pageData.put((Object)layout.getSchema(), (Object)card);
                    break;
                }
                case "FIELD": {
                    Field field = (Field)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Field.class);
                    field.setValue(this.localeService.getLanguageValue(locale, field.getValue()) + " " + datas.size());
                    pageData.put((Object)layout.getSchema(), (Object)field);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup parentCustomGroup = new CustomGroup();
                    parentCustomGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING.getValue());
                    CustomGroupContent parentContent = new CustomGroupContent();
                    List parentLayous = parentContent.getLayout();
                    UiBotPageData parentPageDte = parentContent.getPageData();
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    parentCustomGroup.setName(this.localeService.getLanguageValue(locale, customGroup.getName()) + " " + datas.size());
                    ArrayList<UiBotLayout> newUiBotLayoutList = new ArrayList<UiBotLayout>();
                    List uiBotLayoutList = customGroup.getContent().getLayout();
                    for (Map data : datas) {
                        CustomGroup dataGroup = new CustomGroup();
                        dataGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_INPUT_FORM.getValue());
                        CustomGroupContent content = new CustomGroupContent();
                        String dataSchema = UUIDUtil.getUuid();
                        parentLayous.add(new UiBotLayout(dataSchema, "CUSTOM_GROUP"));
                        content.setLayout(newUiBotLayoutList);
                        UiBotPageData dataPageData = new UiBotPageData();
                        for (UiBotLayout uiBotLayout : uiBotLayoutList) {
                            UiBotLayout newLayout = new UiBotLayout();
                            newLayout.setType(uiBotLayout.getType());
                            String layoutSchema = uiBotLayout.getSchema();
                            String newSchema = layoutSchema + "_mobile_" + dataSchema;
                            newLayout.setSchema(newSchema);
                            if ("FIELD".equals(uiBotLayout.getType())) {
                                if (StringUtils.hasLength((String)uiBotLayout.getLabel())) {
                                    String value = data.get(layoutSchema) instanceof Double ? Double.toString((Double)data.get(layoutSchema)) : (data.get(layoutSchema) instanceof String ? (String)data.get(layoutSchema) : String.valueOf(data.get(layoutSchema)));
                                    dataPageData.put((Object)newSchema, (Object)Field.createLabelLeftValueRightFieldBy18PX((String)uiBotLayout.getLabel(), (String)value, (Integer)2, (Integer)1));
                                } else {
                                    dataPageData.put((Object)newSchema, (Object)Field.createLabelValueLeftField((String)"", (String)((String)data.get(layoutSchema)), (Integer)1, (Integer)3, (String)((String)data.get("op_no"))));
                                }
                            } else if ("WINDOW_MULTI_SELECT".equals(uiBotLayout.getType())) {
                                uiBotLayout.setLabel(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
                                HashMap<String, Object> rawData = new HashMap<String, Object>(3);
                                if ("supporter_info".equals(layoutSchema)) {
                                    rawData.put("isAPC", true);
                                    rawData.put("team_no", data.get("team_no"));
                                    rawData.put("team_name", data.get("team_name"));
                                    data.put("dataSchema", dataSchema);
                                    rawData.put("webData", data);
                                    dataPageData.put((Object)newSchema, (Object)InputWindowMultiSelect.create((UiBotLayout)uiBotLayout, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), rawData, (String)locale, (Integer)1, (Integer)InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(), (Boolean)false, (Boolean)false, (LocaleService)this.localeService));
                                } else {
                                    dataPageData.put((Object)newSchema, (Object)InputWindowMultiSelect.create((UiBotLayout)uiBotLayout, (UiBotRule)new UiBotRule(), (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), (String)locale, (UiBotExecuteContext)pcUiBotModel.getExecuteContext()));
                                }
                            }
                            newUiBotLayoutList.add(newLayout);
                        }
                        content.setPageData(dataPageData);
                        dataGroup.setContent(content);
                        parentPageDte.put((Object)dataSchema, (Object)dataGroup);
                    }
                    parentCustomGroup.setContent(parentContent);
                    pageData.put((Object)schema, (Object)parentCustomGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    HashMap buttonRawData = new HashMap(6);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        Action action;
                        String jumpPageTitle;
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        if (StringUtils.hasLength((String)(jumpPageTitle = (action = bottomButtonDigiwinAthena.getAction()).getJumpPageTitle()))) {
                            action.setJumpPageTitle(this.localeService.getLanguageValue(locale, jumpPageTitle));
                        }
                        ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButtonDigiwinAthena, (String)"");
                        buttonRawData.put("data", datas);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        buttonRawData.put("action", pcUiBotModel.getLayout().stream().filter(action1 -> "apc_support_needs-task-detail-waitting".equalsIgnoreCase(action1.getType())).findFirst().map(UiBotLayout::getActions).map(e -> (UiBotAction)e.get(0)).orElse(new UiBotAction()));
                        buttonRawData.put("pageId", apiRequest.getPageId());
                        action.setRawData((Object)buttonRawData);
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }
}

