/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApcWorkShopOnlineStrategy")
public class UiBotModelBuildApcWorkShopOnlineStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcWorkShopOnlineStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc work shop online");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        boolean isTeamTask = BooleanUtils.isTrue((Boolean)apiRawData.getBoolean("isTeamTask"));
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)locale);
        }
        String path = UiBotModel.getAthenaTableSchema((List)pcUiBotModel.getLayout());
        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout((List)pcUiBotModel.getLayout());
        Map bodyMap = (Map)JsonUtil.objectToJavaObject(uiBotLayout.getQueryButtons().get(1), Map.class);
        bodyMap.put("executeContext", pcUiBotModel.getExecuteContext());
        UiBotModel completeUibotModle = this.digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString((Object)bodyMap));
        List datas = (List)pcUiBotModel.getPageData().get((Object)path);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    UiBotLayout findLayout = UiBotModel.getApprovalDesriptionLayout((List)pcUiBotModel.getLayout());
                    Map data = Collections.emptyMap();
                    if (!CollectionUtils.isEmpty((Collection)datas)) {
                        data = (Map)datas.get(0);
                    } else if (ObjectUtil.isNotEmpty((Object)pcUiBotModel.getPageData().get((Object)PcLayoutEnum.APPROVAL_DESCRIPTION.getValue()))) {
                        data = (Map)pcUiBotModel.getPageData().get((Object)PcLayoutEnum.APPROVAL_DESCRIPTION.getValue());
                    }
                    TitleBody titleBody = TitleBody.createApc((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (UiBotLayout)findLayout, (Map)data);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    boolean isProductGatewayE10orT100 = this.digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    Map dataInfo = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)datas)) {
                        dataInfo = (Map)datas.get(0);
                    } else {
                        List complateDatas = (List)completeUibotModle.getPageData().get((Object)path);
                        if (!CollectionUtils.isEmpty((Collection)complateDatas)) {
                            dataInfo = (Map)complateDatas.get(0);
                        }
                    }
                    List contents = card.getContent();
                    Iterator iterator = contents.iterator();
                    while (iterator.hasNext()) {
                        CardContent content = (CardContent)iterator.next();
                        content.setLabel(this.localeService.getLanguageValue(locale, content.getLabel()));
                        if (("item_feature_no".equalsIgnoreCase(content.getSchema()) || "item_feature_spec".equalsIgnoreCase(content.getSchema())) && !isProductGatewayE10orT100) {
                            iterator.remove();
                            continue;
                        }
                        content.setValue((String)dataInfo.get(content.getSchema()));
                    }
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "BLANK_AREA": {
                    BlankArea area = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BlankArea.class);
                    pageData.put((Object)schema, (Object)area);
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomTabs.class);
                    pageData.put((Object)layout.getSchema(), (Object)customTabs.detailApcMessage(customTabs, pcUiBotModel, completeUibotModle, path, locale, this.localeService, apiRequest.getPageId(), Boolean.valueOf(isTeamTask)));
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

