/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReconciliationProgressCallPaymentStrategy")
public class TaskDetailBuildReconciliationProgressCallPaymentStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressCallPaymentStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress CallPayment Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map data = (Map)JsonUtil.objectToJavaObject((Object)apiRawData.get((Object)"ar_data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "INPUT_SINGLE": {
                    pageData.put((Object)schema, (Object)this.createInputSingleText(schema, locale, data));
                    break;
                }
                case "INPUT_NUMERIC": {
                    pageData.put((Object)schema, (Object)this.createInputNumeric(schema, locale, data));
                    break;
                }
                case "INPUT_MULTI": {
                    InputMultiText inputMultiText = this.buildInputMultiText(schema, locale);
                    pageData.put((Object)schema, (Object)inputMultiText);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = this.buildButton(apiRawData, locale, pageData, schema);
                    pageData.put((Object)schema, (Object)buttonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private InputNumeric createInputNumeric(String schema, String locale, Map<String, Object> data) {
        InputNumeric input = new InputNumeric();
        if ("process_hours".equalsIgnoreCase(schema)) {
            input.setTitle(this.localeService.getLanguageValue(locale, "\u65f6\u6570"));
            BigDecimal processWorkHours = new BigDecimal(String.valueOf(data.get("process_work_hours"))).stripTrailingZeros();
            BigDecimal processHours = new BigDecimal(String.valueOf(data.get("process_hours"))).stripTrailingZeros();
            BigDecimal bigDecimal = processWorkHours.subtract(processHours);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                input.setText("0");
            } else {
                input.setText(String.valueOf(bigDecimal));
            }
        } else if ("local_curr_price".equalsIgnoreCase(schema)) {
            input.setTitle(this.localeService.getLanguageValue(locale, "\u5355\u4ef7"));
            input.setText(String.valueOf(data.get(schema)));
        }
        input.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
        input.setRequired(Boolean.valueOf(true));
        input.setSchema(schema);
        input.setPrecision(Integer.valueOf(3));
        return input;
    }

    private InputSingleText createInputSingleText(String schema, String locale, Map<String, Object> data) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(this.localeService.getLanguageValue(locale, "\u53d1\u7968\u5ba2\u6237"));
        inputSingleText.setText(String.valueOf(data.get(schema)));
        inputSingleText.setSchema(schema);
        inputSingleText.setRequired(Boolean.valueOf(true));
        inputSingleText.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
        return inputSingleText;
    }

    private InputMultiText buildInputMultiText(String schema, String locale) {
        return InputMultiText.create((String)schema, (String)this.localeService.getLanguageValue(locale, "\u5f00\u7968\u5907\u6ce8"), (String)"", (Boolean)true, (Boolean)false, (Boolean)true, (String)locale);
    }

    private List<BottomButtonDigiwinAthena> buildButton(ApiRawData apiRawData, String locale, UiBotPageData pageData, String schema) {
        List buttonList = (List)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (BottomButtonDigiwinAthena bottomButton : buttonList) {
            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
            Action buttonAction = bottomButton.getAction();
            if (!ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue().equals(buttonAction.getType())) continue;
            buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/reconciliationProgress/submit");
            apiRawData.put("buttonType", (Object)"noticePay");
            buttonAction.setRawData((Object)apiRawData);
        }
        return buttonList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

