/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReconciliationProgressNoticeListStrategy")
public class TaskDetailBuildReconciliationProgressNoticeListStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressNoticeListStrategy.class);
    @Autowired
    private LocaleService localeService;
    private static final String HIGH_CREDITLEVEL = "ABC";
    private static final String MEDIUM_CREDITLEVEL = "DEF";

    public String getTaskDetailType() {
        return "aacr_AccountReconciliationReport_Project_aacr_AccountReconciliationReport_TaskCard";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel uiBotModel;
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Notice List Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData.booleanValue() && !modelTypeShow.booleanValue()) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)JsonUtil.objectToJavaObject((Object)args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "ZTB_VIEW_LIST": {
                    ZtbViewList ztbViewList = (ZtbViewList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), ZtbViewList.class);
                    ztbViewList = this.buildZtbViewList(pcUiBotModel, ztbViewList, locale);
                    pageData.put((Object)schema, (Object)ztbViewList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private ZtbViewList buildZtbViewList(UiBotModel pcUiBotModel, ZtbViewList ztbViewList, String locale) {
        ztbViewList.setTitle(this.localeService.getLanguageValue(locale, ztbViewList.getTitle()));
        List ztbViewCardList = ztbViewList.getData();
        Card cardTemplate = (Card)ztbViewCardList.get(0);
        Map nameMap = this.buildNameMap(locale);
        List arDataList = (List)pcUiBotModel.getPageData().get((Object)"ar_data");
        ArrayList<Card> cardList = new ArrayList<Card>();
        for (Map arData : arDataList) {
            Tag riskLevelTag;
            Tag creditLevelTag;
            LinkedList<Tag> tagList = new LinkedList<Tag>();
            if (!StringUtils.isEmpty((CharSequence)((String)MapUtil.getOrDefault((Map)arData, (String)"credit_level_no", (Object)""))) && !Objects.isNull(creditLevelTag = this.buildCreditLevelTag((String)arData.get("credit_level_no"), nameMap))) {
                tagList.add(creditLevelTag);
            }
            if (!StringUtils.isEmpty((CharSequence)((String)MapUtil.getOrDefault((Map)arData, (String)"risk_level_id", (Object)""))) && !Objects.isNull(riskLevelTag = this.buildRiskLevelTag((String)arData.get("risk_level_id")))) {
                tagList.add(riskLevelTag);
            }
            LinkedList<CardContent> contentList = new LinkedList<CardContent>();
            for (CardContent cardContentTemplate : cardTemplate.getContent()) {
                if (cardContentTemplate.getHiddenLabel().booleanValue()) {
                    contentList.add(this.buildCardContent("", arData.get(cardContentTemplate.getSchema()), Boolean.valueOf(true)));
                    continue;
                }
                contentList.add(this.buildCardContent(this.localeService.getLanguageValue(locale, cardContentTemplate.getLabel()), (Object)this.buildHour(arData, nameMap, cardContentTemplate.getSchema()), Boolean.valueOf(false)));
            }
            String customerName = (String)MapUtil.getOrDefault((Map)arData, (String)cardTemplate.getTitle(), (Object)"");
            String uuid = UUIDUtil.getUuid();
            HashMap<String, Object> rawDataMap = new HashMap<String, Object>();
            rawDataMap.put("ar_data_detail", arData);
            rawDataMap.put("refreshDataId", uuid);
            TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
            tabItemCardDetailPage.setDataId(uuid);
            tabItemCardDetailPage.setPageTitle(customerName);
            tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
            tabItemCardDetailPage.setRawData(rawDataMap);
            Card card = Card.create((String)customerName, contentList, tagList, (TabItemCardDetailPage)tabItemCardDetailPage);
            card.setDataId(UUIDUtil.getUuid());
            cardList.add(card);
        }
        ztbViewList.setData(cardList);
        return ztbViewList;
    }

    private Map<String, String> buildNameMap(String locale) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String mediumRiskName = this.localeService.getLanguageValue(locale, "\u4e00\u822c\u98ce\u9669");
        nameMap.put("mediumRiskName", mediumRiskName);
        String creditLevel = this.localeService.getLanguageValue(locale, "\u4fe1\u7528\u7b49\u7ea7");
        nameMap.put("creditLevel", creditLevel);
        String hour = this.localeService.getLanguageValue(locale, "\u5c0f\u65f6");
        nameMap.put("hour", hour);
        return nameMap;
    }

    private Tag buildCreditLevelTag(String creditLevelNo, Map<String, String> nameMap) {
        Tag creditLevelTag = null;
        String creditLevel = creditLevelNo.substring(0, 1).toUpperCase();
        creditLevelTag = HIGH_CREDITLEVEL.indexOf(creditLevel) > -1 ? Tag.createNoRiskTag((String)(nameMap.get("creditLevel") + creditLevelNo)) : (MEDIUM_CREDITLEVEL.indexOf(creditLevel) > -1 ? Tag.createMediumRiskTag((String)(nameMap.get("creditLevel") + creditLevelNo)) : Tag.createHighRiskTag((String)(nameMap.get("creditLevel") + creditLevelNo)));
        return creditLevelTag;
    }

    private Tag buildRiskLevelTag(String riskLevelData) {
        String riskLevelType;
        Tag riskLevelTag = null;
        String[] riskLevelArg = riskLevelData.split("\\.");
        if (riskLevelArg.length < 2) {
            return null;
        }
        String tagName = riskLevelArg[1];
        switch (riskLevelType = riskLevelArg[0]) {
            case "30": {
                riskLevelTag = Tag.createHighRiskTag((String)tagName);
                break;
            }
            case "20": {
                riskLevelTag = Tag.createMediumRiskTag((String)tagName);
                break;
            }
            case "10": {
                riskLevelTag = Tag.createNoRiskTag((String)tagName);
                break;
            }
        }
        return riskLevelTag;
    }

    private CardContent buildCardContent(String name, Object value, Boolean hiddenLabel) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), hiddenLabel, Integer.valueOf(1));
    }

    private String buildHour(Map<String, Object> arData, Map<String, String> nameMap, String labelName) {
        String value = String.valueOf(MapUtil.getOrDefault(arData, (String)labelName, (Object)"0"));
        value = new BigDecimal(value).stripTrailingZeros().toPlainString();
        String hour = value + nameMap.get("hour");
        return hour;
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

