/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildMaterialNoticeStrategy")
public class TaskDetailBuildMaterialNoticeStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildMaterialNoticeStrategy.class);
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "ItemPickingNotice_caCimAp_outSourcing_purchaseReport_userProject";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel uiBotModel;
        StopWatch stopWatch = new StopWatch("Build Materia lNotice Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData.booleanValue() && !modelTypeShow.booleanValue()) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)JsonUtil.objectToJavaObject((Object)args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        if (pcUiBotModel.getPageData().get((Object)"uiBot__activity") == null) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        String digiProxyToken = "";
        ApiRawData apiRawData = apiRequest.getRawData();
        if (!Objects.isNull(apiRawData)) {
            digiProxyToken = apiRawData.getString("digi-proxy-token");
        }
        List issueNoticeList = (List)pcUiBotModel.getPageData().get((Object)"issue_notice");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CUSTOM_GROUP": {
                    if ("custom_group_attachment".equalsIgnoreCase(schema)) {
                        CustomGroup attachmentCustomGroup = this.buildAttachmentFile(issueNoticeList, locale);
                        if (attachmentCustomGroup == null) break;
                        pageData.put((Object)schema, (Object)attachmentCustomGroup);
                        break;
                    }
                    if ("custom_group_cardlist".equalsIgnoreCase(schema)) {
                        CustomGroup cardListCustomGroup = this.buildCardList(issueNoticeList, locale);
                        pageData.put((Object)schema, (Object)cardListCustomGroup);
                        break;
                    }
                }
                case "BOTTOM_BUTTON": {
                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
                    HashMap<String, Object> rawDataMap = new HashMap<String, Object>();
                    rawDataMap.put("digi-proxy-token", digiProxyToken);
                    rawDataMap.put("actionId", "ca.cim.issue.notice.info.update");
                    HashMap<String, List> issueNoticeMap = new HashMap<String, List>(1);
                    issueNoticeMap.put("issue_notice", issueNoticeList);
                    rawDataMap.put("data", issueNoticeMap);
                    UiBotAction pcUiBotAction = pcUiBotModel.getActions().stream().filter(item -> item.getType().equalsIgnoreCase("ESP")).findFirst().orElse(null);
                    rawDataMap.put("action", pcUiBotAction);
                    buttonAction.setRawData(rawDataMap);
                    ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(1);
                    BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
                    button.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                    button.setAction(buttonAction);
                    button.setShowDot(Boolean.valueOf(true));
                    button.setType(BottomButtonStyleEnum.STRESS.getValue());
                    buttonList.add(button);
                    pageData.put((Object)schema, buttonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildAttachmentFile(List<Map<String, Object>> issueNoticeList, String locale) {
        Set fileIdList = issueNoticeList.stream().filter(item -> item.get("issue_no_id") != null && StringUtils.isNotEmpty((CharSequence)((String)item.get("issue_no_id")))).map(item -> (String)item.get("issue_no_id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(fileIdList)) {
            return null;
        }
        ArrayList<AttachmentFile> attachmentFileList = new ArrayList<AttachmentFile>();
        AttachmentFile attachmentFile = null;
        for (String fileId : fileIdList) {
            attachmentFile = new AttachmentFile();
            attachmentFile.setFileId(fileId);
            attachmentFile.setFileName(fileId + ".pdf");
            attachmentFile.setFileExtension("pdf");
            attachmentFileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setTitle(this.localeService.getLanguageValue(locale, "\u9644\u4ef6"));
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        attachment.setFileList(attachmentFileList);
        CustomGroupContent customGroupContent = new CustomGroupContent();
        String attachmentSchemaId = UUIDUtil.getUuid();
        UiBotLayout uiBotLayout = new UiBotLayout(attachmentSchemaId, "ATTACHMENT");
        LinkedList<UiBotLayout> uiBotLayoutList = new LinkedList<UiBotLayout>();
        uiBotLayoutList.add(uiBotLayout);
        customGroupContent.setLayout(uiBotLayoutList);
        UiBotPageData uiBotPageData = new UiBotPageData();
        uiBotPageData.put((Object)attachmentSchemaId, (Object)attachment);
        customGroupContent.setPageData(uiBotPageData);
        CustomGroup customGroup = CustomGroup.create((String)"", (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_INPUT_FORM, (CustomGroupContent)customGroupContent);
        return customGroup;
    }

    private CustomGroup buildCardList(List<Map<String, Object>> issueNoticeList, String locale) {
        String cardlistName = this.localeService.getLanguageValue(locale, "\u7269\u6599\u6e05\u5355");
        if (CollectionUtils.isEmpty(issueNoticeList)) {
            return CustomGroup.createEmptyGroup((String)locale, (String)cardlistName);
        }
        LinkedList<UiBotLayout> uiBotLayoutList = new LinkedList<UiBotLayout>();
        UiBotLayout uiBotLayout = null;
        UiBotPageData uiBotPageData = new UiBotPageData();
        String issueQty = this.localeService.getLanguageValue(locale, "\u53d1\u6599\u91cf");
        String issueNo = this.localeService.getLanguageValue(locale, "\u9886\u6599\u5355\u53f7");
        String woNo = this.localeService.getLanguageValue(locale, "\u5de5\u5355\u5355\u53f7");
        LinkedHashMap<String, Object> cardContentMap = new LinkedHashMap<String, Object>(3);
        CustomGroupContent customGroupContent = new CustomGroupContent();
        for (Map<String, Object> issueNoticeMap : issueNoticeList) {
            issueNoticeMap.put("uibot_checked", true);
            String schemaId = UUIDUtil.getUuid();
            uiBotLayout = new UiBotLayout(schemaId, "CARD");
            uiBotLayoutList.add(uiBotLayout);
            cardContentMap.put(issueQty, issueNoticeMap.get("issue_qty") + " " + issueNoticeMap.get("unit_name"));
            cardContentMap.put(issueNo, issueNoticeMap.get("issue_no"));
            cardContentMap.put(woNo, issueNoticeMap.get("wo_no"));
            String title = issueNoticeMap.get("material_item_no") + " " + issueNoticeMap.get("material_name") + " " + issueNoticeMap.get("material_spec");
            uiBotPageData.put((Object)schemaId, (Object)Card.create((String)title, cardContentMap));
        }
        customGroupContent.setLayout(uiBotLayoutList);
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create((String)cardlistName, (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING, (CustomGroupContent)customGroupContent);
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

