/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.ValidateRuleLevelEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildOutSourceWorkReportDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportDetailStrategy.class);
    @Autowired
    private LocaleService localeService;
    private static final String OUTSOURCINGTYPE = "1";

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map outsourcingReportData = (Map)apiRawData.get((Object)"outsourcing_report");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    for (UiBotLayout uiBotLayout : customGroupContent.getLayout()) {
                        this.handleCustomGroup(uiBotLayout, customGroupContent.getPageData(), outsourcingReportData, apiRawData, locale);
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "PAGE_BUTTON": {
                    if (!OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type"))) break;
                    PageButton pageButton = new PageButton();
                    pageButton.setName(this.localeService.getLanguageValue(locale, layout.getLabel()));
                    Action action = new Action();
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString());
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, layout.getLabel()));
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setDataId(UUIDUtil.getUuid());
                    HashMap<String, Object> rawDataMap = new HashMap<String, Object>(3);
                    rawDataMap.put("outsourcing_report", outsourcingReportData);
                    Map executeContextMap = (Map)apiRawData.get((Object)"executeContext");
                    String proxyToken = (String)executeContextMap.get("proxyToken");
                    rawDataMap.put("digi-proxy-token", proxyToken);
                    Map businessUnitMap = (Map)executeContextMap.get("businessUnit");
                    rawDataMap.put("eoc_company_id", businessUnitMap.get("eoc_company_id"));
                    action.setRawData(rawDataMap);
                    pageButton.setAction(action);
                    pageData.put((Object)schema, (Object)pageButton);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    this.buildButton(locale, schema, outsourcingReportData, pageData, apiRawData);
                }
            }
        }
        return uiBotModel;
    }

    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, Map<String, Object> outsourcingReportData, ApiRawData apiRawData, String locale) {
        String schema = layout.getSchema();
        String label = layout.getLabel();
        switch (layout.getType()) {
            case "FIELD": {
                Field field = this.buildField(outsourcingReportData, schema, label, locale);
                pageData.put((Object)schema, (Object)field);
                break;
            }
            case "INPUT_CALENDAR": {
                InputCalendar inputCalendar = this.buildInputCalendar(layout, locale, schema);
                pageData.put((Object)schema, (Object)inputCalendar);
                break;
            }
            case "INPUT_NUMERIC": {
                InputNumeric inputNumeric = this.buildInputNumeric(outsourcingReportData, schema, label, locale);
                pageData.put((Object)schema, (Object)inputNumeric);
                break;
            }
            case "WINDOW_SINGLE_SELECT": {
                InputWindowSingleSelect inputWindowSingleSelect = this.buildInputWindowSingleSelect(outsourcingReportData, apiRawData, schema, label, locale);
                pageData.put((Object)schema, (Object)inputWindowSingleSelect);
                break;
            }
        }
    }

    private Field buildField(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        String schemaData;
        String name = this.localeService.getLanguageValue(locale, label);
        String string = schemaData = outsourcingReportData.get(schema) != null ? String.valueOf(outsourcingReportData.get(schema)) : "";
        if ("item_no".equalsIgnoreCase(schema)) {
            schemaData = outsourcingReportData.get("item_no") + " " + outsourcingReportData.get("item_name") + " " + outsourcingReportData.get("item_spec");
        }
        if ("operation_section_name".equalsIgnoreCase(schema)) {
            schemaData = String.valueOf(outsourcingReportData.get(schema));
        }
        if ("outsourcing_type".equalsIgnoreCase(schema)) {
            schemaData = OUTSOURCINGTYPE.equals(outsourcingReportData.get(schema)) ? this.localeService.getLanguageValue(locale, "\u5382\u5185\u5916\u534f") : this.localeService.getLanguageValue(locale, "\u5382\u5916\u5916\u534f");
        }
        if ("plan_delivery_date".equalsIgnoreCase(schema) && StringUtils.isNotEmpty((CharSequence)schemaData)) {
            schemaData = schemaData.substring(0, 10);
        }
        if ("overrun_rate".equalsIgnoreCase(schema) && StringUtils.isNotEmpty((CharSequence)schemaData)) {
            schemaData = schemaData + "%";
        }
        Field field = Field.createLabelLeftValueRightField((String)name, (String)schemaData);
        return field;
    }

    private InputCalendar buildInputCalendar(UiBotLayout layout, String locale, String schema) {
        layout.setHeaderName(this.localeService.getLanguageValue(locale, layout.getLabel()));
        InputCalendar inputCalendar = InputCalendar.create((UiBotLayout)layout, null, (String)locale);
        inputCalendar.setMaxDateSelectable(InputCalendarDate.createToday());
        ArrayList<InputCalendarDate> calendarDateList = new ArrayList<InputCalendarDate>();
        calendarDateList.add(InputCalendarDate.createToday());
        inputCalendar.setDateValueList(calendarDateList);
        inputCalendar.setRequired(Boolean.valueOf(true));
        ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>(1);
        ValidateRule validateRule1 = new ValidateRule();
        validateRule1.setSchema(schema);
        validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
        validateRule1.setType(ValidateRuleTypeEnum.DATE.getType());
        validateRule1.setOperatorType(Integer.valueOf(2));
        validateRule1.setParameterDataType(RuleDataTypeEnum.DATE.getDataType());
        validateRule1.setParameterDate(DateTimeUtil.getNowDateMap());
        validateRule1.setLevel(ValidateRuleLevelEnum.WARNING_LEVEL_VERIFICATION.getLevelType());
        validateRule1.setWarningMessage(this.localeService.getLanguageValue(locale, "\u62a5\u5de5\u65e5\u671f\u4e0d\u662f\u5f53\u5929\uff0c\u8bf7\u786e\u5b9a\u65e5\u671f\u662f\u5426\u6b63\u786e"));
        validateRuleList.add(validateRule1);
        inputCalendar.setValidateRuleList(validateRuleList);
        return inputCalendar;
    }

    private InputNumeric buildInputNumeric(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        ParseFieldData fieldData;
        InputNumeric inputNumeric = null;
        if ("report_qty".equalsIgnoreCase(schema)) {
            inputNumeric = this.buildReportQty(locale, outsourcingReportData, schema, label);
        }
        if ("shift_no".equalsIgnoreCase(schema) || "others_qty".equalsIgnoreCase(schema)) {
            fieldData = new ParseFieldData();
            fieldData.setLabel(this.localeService.getLanguageValue(locale, label));
            inputNumeric = InputNumeric.create((String)locale, (ParseFieldData)fieldData, Collections.emptyList());
            inputNumeric.setText("");
            inputNumeric.setPrecision(Integer.valueOf(0));
            inputNumeric.setRequired(Boolean.valueOf(OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type"))));
        }
        if ("work_procedure_type".equalsIgnoreCase(schema)) {
            fieldData = new ParseFieldData();
            fieldData.setLabel(this.localeService.getLanguageValue(locale, label));
            inputNumeric = InputNumeric.create((String)locale, (ParseFieldData)fieldData, Collections.emptyList());
            inputNumeric.setText("");
            inputNumeric.setHidden(Boolean.valueOf(true));
        }
        return inputNumeric;
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(Map<String, Object> outsourcingReportData, ApiRawData apiRawData, String schema, String label, String locale) {
        UiBotLayout uiBotFieldLayout = new UiBotLayout();
        uiBotFieldLayout.setSchema(schema);
        uiBotFieldLayout.setHeaderName(this.localeService.getLanguageValue(locale, label));
        List operations = (List)apiRawData.get((Object)"operations");
        Optional<Map> optional = operations.stream().filter(e -> "openwindow".equalsIgnoreCase((String)e.get("operate"))).findFirst();
        Map uiBotFieldMap = new HashMap();
        if (optional.isPresent()) {
            uiBotFieldMap = optional.get();
        }
        JSONArray oerationList = new JSONArray();
        oerationList.add(uiBotFieldMap);
        uiBotFieldLayout.setOperations(oerationList);
        InputWindowSingleSelect windowSingleSelect = InputWindowSingleSelect.create((UiBotLayout)uiBotFieldLayout, null, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema), (String)locale, (UiBotExecuteContext)((UiBotExecuteContext)JSONObject.parseObject((String)JSONObject.toJSONString((Object)apiRawData.get((Object)"executeContext")), UiBotExecuteContext.class)));
        windowSingleSelect.getRawData().put("isOutSource", true);
        windowSingleSelect.getRawData().put("parameter", outsourcingReportData);
        windowSingleSelect.setRequired(Boolean.valueOf(OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type"))));
        return windowSingleSelect;
    }

    private InputNumeric buildReportQty(String locale, Map<String, Object> outsourcingReportData, String schema, String label) {
        Integer unitDecimal = (Integer)MapUtil.getOrDefault(outsourcingReportData, (String)"unit_decimal_places", (Object)0);
        String remainingReportQty = String.format("%." + unitDecimal + "f", MapUtil.getOrDefault(outsourcingReportData, (String)"remaining_report_qty", (Object)0.0));
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u540c\u62a5\u5de5\u5269\u4f59\u6570\u91cf"));
        button.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
        ParseFieldData fieldData = new ParseFieldData();
        fieldData.setLabel(this.localeService.getLanguageValue(locale, label));
        ArrayList uiBotRuleList = new ArrayList();
        InputNumeric inputNumeric = InputNumeric.create((String)locale, (ParseFieldData)fieldData, uiBotRuleList, (Button)button, (String)remainingReportQty, (boolean)true);
        List validateRuleList = this.buidlReportQtyRules(locale, outsourcingReportData, schema);
        inputNumeric.setValidateRuleList(validateRuleList);
        return inputNumeric;
    }

    private List<ValidateRule> buidlReportQtyRules(String locale, Map<String, Object> outsourcingReportData, String schema) {
        Integer unitDecimal = (Integer)outsourcingReportData.get("unit_decimal_places");
        ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>(2);
        ValidateRule validateRule1 = new ValidateRule();
        validateRule1.setSchema(schema);
        validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
        validateRule1.setType(ValidateRuleTypeEnum.PATTERN.getType());
        if (unitDecimal > 0) {
            validateRule1.setParameter("^[0-9]+(.[0-9]{1," + unitDecimal + "})?$");
            validateRule1.setErrorMessage(this.localeService.getLanguageValue(locale, "\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u548c\u5c0f\u6570\uff0c\u5c0f\u6570\u4f4d\u9650\u5236" + unitDecimal + "\u4f4d"));
        } else {
            validateRule1.setParameter("^(0|[1-9][0-9]*)$");
            validateRule1.setErrorMessage(this.localeService.getLanguageValue(locale, "\u53ea\u80fd\u8f93\u5165\u6574\u6570"));
        }
        validateRuleList.add(validateRule1);
        String totalReportQty = String.valueOf(outsourcingReportData.get("total_report_qty"));
        String purchaseQty = String.valueOf(outsourcingReportData.get("purchase_qty"));
        String overrunRate = String.valueOf(outsourcingReportData.get("overrun_rate"));
        if (StringUtils.isNotEmpty((CharSequence)overrunRate)) {
            BigDecimal overrunRateBigDecimal = new BigDecimal(String.valueOf(overrunRate));
            BigDecimal rate = overrunRateBigDecimal.divide(new BigDecimal(String.valueOf(100))).add(new BigDecimal(1));
            BigDecimal maxReportQty = rate.multiply(new BigDecimal(String.valueOf(purchaseQty))).subtract(new BigDecimal(totalReportQty));
            ValidateRule validateMaxNumRule = new ValidateRule();
            validateMaxNumRule.setSchema(schema);
            validateMaxNumRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateMaxNumRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateMaxNumRule.setParameter(maxReportQty.toString());
            validateMaxNumRule.setOperatorType(Integer.valueOf(4));
            validateMaxNumRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateMaxNumRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u7d2f\u8ba1\u62a5\u5de5\u6570\u91cf\u5df2\u8d85\u8fc7\u8d85\u4ea4\u7387" + overrunRate + "%\u7684\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
            validateRuleList.add(validateMaxNumRule);
        }
        return validateRuleList;
    }

    private void buildButton(String locale, String schema, Map<String, Object> outsourcingReportData, UiBotPageData pageData, ApiRawData apiRawData) {
        ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale);
        buttonList.add(cancelButton);
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        HashMap<String, Object> rawDataMap = new HashMap<String, Object>();
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(1);
        dataMap.put("outsourcing_report", Collections.singletonList(outsourcingReportData));
        rawDataMap.put("data", dataMap);
        rawDataMap.put("action", apiRawData.get((Object)"action"));
        HashMap<String, Object> verCheckDataMap = new HashMap<String, Object>(1);
        HashMap verCheckDataParameterMap = new HashMap(1);
        HashMap<String, Object> versionInfoMap = new HashMap<String, Object>(2);
        versionInfoMap.put("id", outsourcingReportData.get("id"));
        versionInfoMap.put("version", 0);
        verCheckDataParameterMap.put("version_info", Collections.singletonList(versionInfoMap));
        verCheckDataMap.put("parameter", verCheckDataParameterMap);
        verCheckDataMap.put("actionId", "ca.cim.outsourcing.report.ver.check");
        rawDataMap.put("verCheckData", verCheckDataMap);
        HashMap<String, Object> detailInfoCheckDataMap = new HashMap<String, Object>(1);
        HashMap detailInfoCheckDataParameterMap = new HashMap(1);
        HashMap<String, Object> reportInfoMap = new HashMap<String, Object>(2);
        reportInfoMap.put("outsourcing_report_id", outsourcingReportData.get("id"));
        detailInfoCheckDataParameterMap.put("report_info", Collections.singletonList(reportInfoMap));
        detailInfoCheckDataMap.put("parameter", detailInfoCheckDataParameterMap);
        detailInfoCheckDataMap.put("actionId", "ca.cim.outsourcing.report.detail.info.check");
        rawDataMap.put("detailInfoCheckData", detailInfoCheckDataMap);
        HashMap<String, String> reportInfoUpdateDataMap = new HashMap<String, String>(1);
        reportInfoUpdateDataMap.put("actionId", "ca.cim.outsourcing.report.info.update");
        rawDataMap.put("reportInfoUpdateData", reportInfoUpdateDataMap);
        Map executeContextMap = (Map)apiRawData.get((Object)"executeContext");
        String proxyToken = (String)executeContextMap.get("proxyToken");
        rawDataMap.put("digi-proxy-token", proxyToken);
        buttonAction.setRawData(rawDataMap);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4"));
        button.setAction(buttonAction);
        button.setShowDot(Boolean.valueOf(true));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        pageData.put((Object)schema, buttonList);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

