/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildOutSourceWorkReportListStrategy")
public class TaskDetailBuildOutSourceWorkReportListStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportListStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "outSourcingWorkReport_caCimAp_outSourcing_purchaseReport_userProject";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel uiBotModel;
        StopWatch stopWatch = new StopWatch("Build OutSource Work List Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData.booleanValue() && !modelTypeShow.booleanValue()) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)JsonUtil.objectToJavaObject((Object)args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        ApiRawData apiRawData = apiRequest.getRawData();
        String digiProxyToken = apiRawData.getString("digi-proxy-token");
        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout((List)pcUiBotModel.getLayout());
        Map bodyMap = (Map)JsonUtil.objectToJavaObject(uiBotLayout.getQueryButtons().get(1), Map.class);
        bodyMap.put("executeContext", pcUiBotModel.getExecuteContext());
        UiBotModel completeUibotModle = this.digiwinPcUiBotProxyService.actionShowByProxyToken(locale, apiRequest.getTenantId(), digiProxyToken, iamUserToken, JsonUtil.javaObjectToJsonString((Object)bodyMap));
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = new CustomTabs();
                    this.buildCustomTabs(pcUiBotModel, customTabs, false, locale);
                    this.buildCustomTabs(completeUibotModle, customTabs, true, locale);
                    pageData.put((Object)schema, (Object)customTabs);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private void buildCustomTabs(UiBotModel pcUiBotModel, CustomTabs customTabs, boolean isComplete, String locale) {
        if (pcUiBotModel.getPageData().get((Object)"outsourcing_report") == null) {
            customTabs.add((Object)this.buidlEmptyTab(isComplete, locale));
            return;
        }
        List outsourcingReportList = (List)pcUiBotModel.getPageData().get((Object)"outsourcing_report");
        int needHandleNum = outsourcingReportList.size();
        String tabName = this.localeService.getLanguageValue(locale, isComplete ? "\u5df2\u5b8c\u6210" : "\u5f85\u5904\u7406") + "(" + needHandleNum + ")";
        ArrayList<CustomTabContentContainer> customTabContentContainerList = new ArrayList<CustomTabContentContainer>();
        if (!CollectionUtils.isEmpty((Collection)outsourcingReportList)) {
            String reportRemainName = this.localeService.getLanguageValue(locale, "\u62a5\u5de5\u5269\u4f59\u6570\u91cf");
            String operationSeqName = this.localeService.getLanguageValue(locale, "\u5de5\u827a\u5e8f");
            String handleName = this.localeService.getLanguageValue(locale, "\u53bb\u5904\u7406");
            Map<String, List<Map>> needHandleMapByWoNo = outsourcingReportList.stream().collect(Collectors.groupingBy(item -> (String)item.get("wo_no")));
            CustomTabContentContainer customTabContentContainer = null;
            for (Map.Entry<String, List<Map>> needHandleMap : needHandleMapByWoNo.entrySet()) {
                customTabContentContainer = new CustomTabContentContainer();
                ArrayList<BaseMobileComponentWrapper> retracableContentContainerList = new ArrayList<BaseMobileComponentWrapper>();
                for (Map needHandleItem : needHandleMap.getValue()) {
                    needHandleItem.put("uibot_checked", true);
                    HashMap<String, String> cardContentMap = new HashMap<String, String>();
                    ArrayList<Button> buttonList = new ArrayList<Button>();
                    HashMap<String, Object> rawDataMap = new HashMap<String, Object>();
                    rawDataMap.put("outsourcing_report", needHandleItem);
                    rawDataMap.put("isComplete", needHandleItem);
                    String buttonId = UUIDUtil.getUuid();
                    if (!isComplete) {
                        Action action = new Action();
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
                        action.setJumpPageTitle("");
                        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
                        action.setParentComponent("RETRACYABLE");
                        action.setUseParentAction(Boolean.valueOf(true));
                        Optional<UiBotLayout> defaultOption = pcUiBotModel.getLayout().stream().filter(e -> "CONTENT_QUERY_BUTTON".equalsIgnoreCase(e.getType())).findFirst();
                        if (defaultOption.isPresent()) {
                            List uiBotQueryButtonList = defaultOption.get().getQueryButtons();
                            Optional<UiBotQueryButton> innerOption = uiBotQueryButtonList.stream().filter(e -> "waitting".equalsIgnoreCase(e.getDataStateCode())).findFirst();
                            if (innerOption.isPresent()) {
                                List operationList = innerOption.get().getOperations();
                                rawDataMap.put("operations", operationList);
                            }
                        } else {
                            rawDataMap.put("operations", null);
                        }
                        rawDataMap.put("executeContext", pcUiBotModel.getExecuteContext());
                        UiBotAction pcUiBotAction = pcUiBotModel.getActions().stream().filter(item -> item.getType().equalsIgnoreCase("TaskEngine")).findFirst().orElse(null);
                        rawDataMap.put("action", pcUiBotAction);
                        action.setRawData(rawDataMap);
                        buttonList.add(Button.createButton((String)handleName, (String)buttonId, (Integer)BottomButtonStyleEnum.NORMAL.getValue(), (Action)action));
                    }
                    String cardTitle = needHandleItem.get("operation_name") + " " + needHandleItem.get("operation_no");
                    cardContentMap.put(reportRemainName, MapUtil.getOrDefault((Map)needHandleItem, (String)"remaining_report_qty", (Object)"0") + " " + needHandleItem.get("unit_name"));
                    cardContentMap.put(operationSeqName, (String)needHandleItem.get("operation_seq"));
                    Card card = Card.create((String)cardTitle, cardContentMap, buttonList, (boolean)isComplete);
                    TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
                    tabItemCardDetailPage.setDataId(buttonId);
                    if (isComplete) {
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_COMPLETE_DETAIL.toString());
                    } else {
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
                    }
                    tabItemCardDetailPage.setRawData(rawDataMap);
                    card.setDetailPage(tabItemCardDetailPage);
                    retracableContentContainerList.add(new BaseMobileComponentWrapper((BaseMobileComponent)card, "CARD"));
                }
                Map needHandleData = needHandleMap.getValue().get(0);
                String titleDesc = needHandleData.get("item_no") + " " + needHandleData.get("item_name") + " " + needHandleData.get("item_spec");
                Retractable retractable = new Retractable();
                retractable.setTitle(needHandleMap.getKey());
                retractable.setStyle(Integer.valueOf(2));
                retractable.setAlignmentType(Integer.valueOf(2));
                retractable.setDesc(titleDesc);
                retractable.setContent(retracableContentContainerList);
                customTabContentContainer.setData((Object)retractable);
                customTabContentContainer.setContentCmptType("RETRACYABLE");
                customTabContentContainerList.add(customTabContentContainer);
            }
        }
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        customTab.setContent(customTabContentContainerList);
        customTabs.add((Object)customTab);
    }

    private CustomTab buidlEmptyTab(boolean isComplete, String locale) {
        String tabName = this.localeService.getLanguageValue(locale, isComplete ? "\u5df2\u5b8c\u6210" : "\u5f85\u5904\u7406") + "(0)";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        customTab.setContent(Collections.emptyList());
        return customTab;
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

