/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="taskDetailBuildPreviousManualTaskDetailStrategy")
public class TaskDetailBuildPreviousManualTaskDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildPreviousManualTaskDetailStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        HashMap taskInfoMap = new HashMap(2);
        taskInfoMap.put("project_no", rawData.get("project_no"));
        taskInfoMap.put("task_no", rawData.get("task_no"));
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));
        HashMap<String, Object> rawDataMap = new HashMap<String, Object>(2);
        rawDataMap.put("parameter", parameterMap);
        rawDataMap.put("actionId", "before.task.info.get");
        DigiwinAthenaApiResponse beforeTaskResp = null;
        try {
            beforeTaskResp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", rawDataMap);
        }
        catch (Exception e2) {
            logger.error("get before task info error: ", (Throwable)e2);
        }
        List beforeTaskInfoList = Optional.ofNullable(beforeTaskResp).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List)e.get((Object)"before_task_info")).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(beforeTaskInfoList)) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        ArrayList<UiBotLayout> newLayouts = new ArrayList<UiBotLayout>();
        UiBotPageData newPageData = new UiBotPageData();
        block10: for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case "CARD": {
                    Card cardPageData = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Card.class);
                    for (Map beforeTaskInfo : beforeTaskInfoList) {
                        String uuid = UUIDUtil.getUuid();
                        UiBotLayout copyUiBotLayout = new UiBotLayout();
                        BeanUtils.copyProperties((Object)layout, (Object)copyUiBotLayout);
                        copyUiBotLayout.setSchema(uuid);
                        newLayouts.add(copyUiBotLayout);
                        Card copyCardPageData = (Card)JsonUtil.objectToJavaObject((Object)cardPageData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                        copyCardPageData.setTitle((String)MapUtil.getOrDefault((Map)beforeTaskInfo, (String)copyCardPageData.getTitle(), (Object)""));
                        copyCardPageData.setSubTitle((String)MapUtil.getOrDefault((Map)beforeTaskInfo, (String)copyCardPageData.getSubTitle(), (Object)""));
                        List copyCardContent = copyCardPageData.getContent();
                        for (CardContent cardContent : copyCardContent) {
                            String label = this.localeService.getLanguageValue(locale, cardContent.getLabel());
                            if ("manualAssignmentDelivery".equalsIgnoreCase(cardContent.getSchema()) || "manualAssignmentAttachment".equalsIgnoreCase(cardContent.getSchema())) {
                                Map attachment = (Map)MapUtil.getOrDefault((Map)beforeTaskInfo, (String)"attachment", Collections.emptyMap());
                                List attachmentData = (List)MapUtil.getOrDefault((Map)attachment, (String)"data", Collections.emptyList());
                                List displayAttachment = attachmentData.stream().filter(e -> cardContent.getSchema().equals(e.get("category"))).collect(Collectors.toList());
                                if (CollectionUtils.isEmpty(displayAttachment)) {
                                    cardContent.setFile(null);
                                    cardContent.setValue("-");
                                    cardContent.setValueStyleType(Integer.valueOf(1));
                                    cardContent.setLabel(label);
                                    continue;
                                }
                                Attachment file = cardContent.getFile();
                                cardContent.setFile(Attachment.createAttachment(displayAttachment, (Attachment)file, (String)label));
                                continue;
                            }
                            cardContent.setLabel(label);
                            cardContent.setValue((String)MapUtil.getOrDefault((Map)beforeTaskInfo, (String)cardContent.getSchema(), (Object)""));
                            cardContent.setValueStyleType(Integer.valueOf(1));
                        }
                        newPageData.put((Object)copyUiBotLayout.getSchema(), (Object)copyCardPageData);
                    }
                    continue block10;
                }
                case "BOTTOM_BUTTON": {
                    newLayouts.add(layout);
                    newPageData.put((Object)layout.getSchema(), Collections.singletonList(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale)));
                    break;
                }
            }
        }
        uiBotModel.setLayout(newLayouts);
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

