/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReplaceReportTaskDetailStrategy")
public class TaskDetailBuildReplaceReportTaskDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReplaceReportTaskDetailStrategy.class);
    private static final String ESP_EMPLOYEE_INFO_PROCESS = "esp_employee.info.process";
    private static final String EMPLOYEE_INFO_PROCESS = "employee.info.process";
    private static final String GROUPID_PREFIX = "Group";
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Replace Report Task Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        InputWindowMultiSelect executor;
        List selectDetailList;
        Optional<ActionSubmitParam> workHoursOpt;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map rawData = apiRawData.getInnerMap();
        List executorInfoByGroupList = (List)JsonUtil.objectToJavaObject(rawData.get("executorInfoByGroupList"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List actionSubmitParamList = apiRequest.getSubmitParam();
        if (!CollectionUtils.isEmpty((Collection)actionSubmitParamList) && (workHoursOpt = actionSubmitParamList.stream().filter(e -> "executor".equalsIgnoreCase(e.getSchema())).findFirst()).isPresent() && Objects.nonNull(workHoursOpt.get().getParams()) && !CollectionUtils.isEmpty((Collection)(selectDetailList = (List)JsonUtil.objectToJavaObject((Object)(executor = (InputWindowMultiSelect)JsonUtil.objectToJavaObject((Object)workHoursOpt.get().getParams(), InputWindowMultiSelect.class)).getSelectDetailList(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            Map<String, List> executorInfoByGroupMapById = !CollectionUtils.isEmpty((Collection)executorInfoByGroupList) ? executorInfoByGroupList.stream().collect(Collectors.toMap(e -> {
                Optional<ActionSubmitParam> inputWindowSingleSelectOpt = e.stream().filter(item -> "WINDOW_SINGLE_SELECT".equalsIgnoreCase(item.getType())).findFirst();
                if (inputWindowSingleSelectOpt.isPresent()) {
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)inputWindowSingleSelectOpt.get().getParams(), InputWindowSingleSelect.class);
                    return inputWindowSingleSelect.getSelectId();
                }
                return "";
            }, e -> e, (c1, c2) -> c1)) : null;
            executorInfoByGroupList = selectDetailList.stream().map(selectDetail -> {
                String selectId = MapUtils.getString((Map)selectDetail, (Object)"employee_no") + "_" + MapUtils.getString((Map)selectDetail, (Object)"department_no");
                String selectName = MapUtils.getString((Map)selectDetail, (Object)"employee_name");
                if (Objects.isNull(executorInfoByGroupMapById) || !executorInfoByGroupMapById.containsKey(selectId)) {
                    ActionSubmitParam actionSubmitParam = new ActionSubmitParam();
                    actionSubmitParam.setType("WINDOW_SINGLE_SELECT");
                    actionSubmitParam.setSchema("executor_no");
                    InputWindowSingleSelect inputWindowSingleSelect = new InputWindowSingleSelect();
                    inputWindowSingleSelect.setSelectId(selectId);
                    inputWindowSingleSelect.setTitle(selectName);
                    actionSubmitParam.setParams((Object)inputWindowSingleSelect);
                    return Collections.singletonList(actionSubmitParam);
                }
                return (List)executorInfoByGroupMapById.get(selectId);
            }).collect(Collectors.toList());
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    Object executorInfoByGroup2;
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List uiBotLayoutList = customGroupContent.getLayout();
                    ArrayList<String> initGroupIds = new ArrayList<String>();
                    LinkedList uiBotLayoutCopyLinkedList = new LinkedList();
                    int suffixIndex = 0;
                    if (!CollectionUtils.isEmpty((Collection)executorInfoByGroupList)) {
                        for (Object executorInfoByGroup2 : executorInfoByGroupList) {
                            List uiBotLayoutCopyList = this.handleUiBotLayoutList(uiBotLayoutList, customGroupContent, (List)executorInfoByGroup2, locale, suffixIndex, true, apiRawData);
                            uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                            initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                            ++suffixIndex;
                        }
                    } else {
                        List uiBotLayoutCopyList = this.handleUiBotLayoutList(uiBotLayoutList, customGroupContent, Collections.emptyList(), locale, suffixIndex, false, apiRawData);
                        uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                        initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                    }
                    customGroup.setInitGroupIds(initGroupIds);
                    customGroupContent.setLayout(uiBotLayoutCopyLinkedList);
                    CustomGroupContent customGroupCopyContent = customGroup.getContentCopy();
                    executorInfoByGroup2 = customGroupCopyContent.getLayout().iterator();
                    while (executorInfoByGroup2.hasNext()) {
                        UiBotLayout uiBotLayout = (UiBotLayout)executorInfoByGroup2.next();
                        this.handleCustomGroup(uiBotLayout, customGroupCopyContent.getPageData(), locale, false, null, apiRawData);
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = this.buildButton(locale, apiRequest);
                    pageData.put((Object)schema, (Object)buttonList);
                }
            }
        }
        return uiBotModel;
    }

    private List<UiBotLayout> handleUiBotLayoutList(List<UiBotLayout> uiBotLayoutList, CustomGroupContent customGroupContent, List<ActionSubmitParam> executorInfo, String locale, int suffixIndex, boolean hasInitVal, ApiRawData apiRawData) {
        List<UiBotLayout> uiBotLayoutCopyList = uiBotLayoutList.stream().map(e -> {
            UiBotLayout uiBotLayoutCopy = new UiBotLayout();
            BeanUtils.copyProperties((Object)e, (Object)uiBotLayoutCopy);
            return uiBotLayoutCopy;
        }).collect(Collectors.toList());
        for (UiBotLayout uiBotLayoutCopyDetail : uiBotLayoutCopyList) {
            Optional<ActionSubmitParam> executorInfoOpt;
            String customGroupContentSchema = uiBotLayoutCopyDetail.getSchema();
            if (StringUtils.isNotEmpty((CharSequence)customGroupContentSchema)) {
                uiBotLayoutCopyDetail.setSchema(customGroupContentSchema + "_" + GROUPID_PREFIX + suffixIndex);
            }
            uiBotLayoutCopyDetail.setGroupId(GROUPID_PREFIX + suffixIndex);
            ActionSubmitParam actionSubmitParam = null;
            if (hasInitVal && (executorInfoOpt = executorInfo.stream().filter(e -> uiBotLayoutCopyDetail.getType().equals(e.getType())).findFirst()).isPresent()) {
                actionSubmitParam = executorInfoOpt.get();
            }
            this.handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale, hasInitVal, actionSubmitParam, apiRawData);
        }
        return uiBotLayoutCopyList;
    }

    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, String locale, boolean hasInitVal, ActionSubmitParam actionSubmitParam, ApiRawData apiRawData) {
        String schema = layout.getSchema();
        switch (layout.getType()) {
            case "INPUT_NUMERIC": {
                String value = "";
                if (hasInitVal && actionSubmitParam != null) {
                    InputNumeric initInputNumeric = (InputNumeric)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputNumeric.class);
                    value = initInputNumeric.getText();
                }
                InputNumeric inputNumeric = this.buildInputNumeric(layout, value, locale, apiRawData);
                pageData.put((Object)schema, (Object)inputNumeric);
                break;
            }
            case "WINDOW_SINGLE_SELECT": {
                String defaultSelectId = "";
                String defaultShowValue = "";
                if (hasInitVal && actionSubmitParam != null) {
                    InputWindowSingleSelect initInputWindowSingleSelect = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputWindowSingleSelect.class);
                    defaultSelectId = initInputWindowSingleSelect.getSelectId();
                    defaultShowValue = initInputWindowSingleSelect.getTitle();
                }
                InputWindowSingleSelect inputWindowSingleSelect = this.buildInputWindowSingleSelect(layout, schema, defaultSelectId, defaultShowValue, locale);
                pageData.put((Object)schema, (Object)inputWindowSingleSelect);
                break;
            }
        }
    }

    private InputNumeric buildInputNumeric(UiBotLayout uiBotLayout, String value, String locale, ApiRawData apiRawData) {
        InputNumeric inputNumeric = InputNumeric.create((Integer)99999999, (Integer)2, (String)value, (String)this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()), (Integer)InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue(), (Boolean)true, (String)"");
        inputNumeric.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
        Object isworkHourZero = apiRawData.get((Object)"isworkHourZero");
        if (ObjectUtils.isNotEmpty((Object)isworkHourZero) && ((Boolean)isworkHourZero).booleanValue() && uiBotLayout.getSchema().contains("work_hours")) {
            ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>(1);
            ValidateRule validateRule = new ValidateRule();
            validateRule.setSchema(uiBotLayout.getSchema());
            validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateRule.setOperatorType(Integer.valueOf(2));
            validateRule.setParameter("0");
            validateRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u5de5\u65f6\u4e0d\u80fd\u7b49\u4e8e0"));
            validateRule.setOrder(Integer.valueOf(1));
            validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateRuleList.add(validateRule);
            inputNumeric.setValidateRuleList(validateRuleList);
        }
        return inputNumeric;
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(UiBotLayout uiBotLayout, String schema, String defaultSelectId, String defaultShowValue, String locale) {
        Map rawDataMap = this.buildEmployeeDataSourceList();
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getLabel());
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType("WINDOW_SINGLE_SELECT");
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        if (StringUtils.isNotEmpty((CharSequence)defaultSelectId)) {
            windowSingleSelect.setDefaultSelectId(defaultSelectId);
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultShowValue)) {
            windowSingleSelect.setDefaultShowValue(defaultShowValue);
        }
        windowSingleSelect.setRequired(Boolean.valueOf(true));
        return windowSingleSelect;
    }

    private List<BottomButtonDigiwinAthena> buildButton(String locale, ApiRequest apiRequest) {
        Map rawData = apiRequest.getRawData().getInnerMap();
        ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale, (String)"\u4e0a\u4e00\u6b65");
        buttonList.add(cancelButton);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(this.localeService.getLanguageValue(locale, "\u4fdd\u5b58"));
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/handleAction");
        HashMap<String, Object> rawDataMap = new HashMap<String, Object>();
        rawDataMap.put("isReplaceReportExecutorSave", true);
        rawDataMap.put("detailInfo", apiRequest.getSubmitParam());
        rawDataMap.put("totalWorkHours", rawData.get("totalWorkHours"));
        Map requestRawDataMap = apiRequest.getRawData().getInnerMap();
        if (!CollectionUtils.isEmpty((Map)requestRawDataMap)) {
            rawDataMap.putAll(requestRawDataMap);
        }
        buttonAction.setRawData(rawDataMap);
        button.setAction(buttonAction);
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        return buttonList;
    }

    private Map<String, Object> buildEmployeeDataSourceList() {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_EMPLOYEE_INFO_PROCESS);
        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setCategory("ESP");
        pcUiBotQueryAction.setActionId(ESP_EMPLOYEE_INFO_PROCESS);
        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setName(EMPLOYEE_INFO_PROCESS);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);
        HashMap<String, String> projectMemberInfoMap = new HashMap<String, String>(1);
        projectMemberInfoMap.put("project_no", "");
        HashMap parasMap = new HashMap(1);
        parasMap.put("project_member_info", Collections.singletonList(projectMemberInfoMap));
        pcUiBotQueryAction.setParas(parasMap);
        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);
        HashMap<String, List<PcUiBotDataSourceDTO>> dataSourceListMap = new HashMap<String, List<PcUiBotDataSourceDTO>>(1);
        dataSourceListMap.put("dataSourceList", Collections.singletonList(pcUiBotDataSourceDTO));
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        return paramMap;
    }

    public Action handleSaveAction(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map apiRawDataMap = apiRequestSubmit.getRawData().getInnerMap();
        String totalWorkHoursStr = MapUtils.getString((Map)apiRawDataMap, (Object)"totalWorkHours");
        BigDecimal totalWorkHours = new BigDecimal(StringUtils.isNotBlank((CharSequence)totalWorkHoursStr) ? totalWorkHoursStr : "0");
        BigDecimal sumWorkHours = new BigDecimal(0);
        List groupSubmitParamList = apiRequestSubmit.getGroupSubmitParamList();
        if (!CollectionUtils.isEmpty((Collection)groupSubmitParamList)) {
            HashSet<String> employeeNos = new HashSet<String>();
            for (List groupSubmitParam : groupSubmitParamList) {
                for (ActionSubmitParam groupSubmitParamDetail : groupSubmitParam) {
                    switch (groupSubmitParamDetail.getType()) {
                        case "WINDOW_SINGLE_SELECT": {
                            InputWindowSingleSelect employeeNoInputWindowSingleSelect = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)groupSubmitParamDetail.getParams(), InputWindowSingleSelect.class);
                            if (employeeNos.contains(employeeNoInputWindowSingleSelect.getSelectId())) {
                                throw new ServiceException(this.localeService.getLanguageValue(locale, "\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u76f8\u540c\u7684\u6267\u884c\u4eba\uff01"));
                            }
                            employeeNos.add(employeeNoInputWindowSingleSelect.getSelectId());
                            break;
                        }
                        case "INPUT_NUMERIC": {
                            InputNumeric workHoursInputNumeric = (InputNumeric)JsonUtil.objectToJavaObject((Object)groupSubmitParamDetail.getParams(), InputNumeric.class);
                            String workHours = workHoursInputNumeric.getText();
                            sumWorkHours = sumWorkHours.add(new BigDecimal(StringUtils.isNotBlank((CharSequence)workHours) ? workHours : "0"));
                        }
                    }
                }
            }
        }
        if (totalWorkHours.add(sumWorkHours).compareTo(BigDecimal.ZERO) < 0) {
            throw new ServiceException(this.localeService.getLanguageValue(locale, "\u8017\u7528\u603b\u5de5\u65f6\u4e0e\u6267\u884c\u4eba\u6e05\u5355\u5de5\u65f6\u7d2f\u8ba1\u4e0d\u53ef\u5c0f\u4e8e0"));
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_AND_TRANSFER_GROUP_DATA_TO_PREFIX.getValue());
        action.setToastMsg(this.localeService.getLanguageValue(locale, "\u4fdd\u5b58\u6210\u529f"));
        Map workHoursMap = (Map)MapUtil.getOrDefault((Map)apiRawDataMap, (String)"work_hours", Collections.emptyMap());
        if (!CollectionUtils.isEmpty((Map)workHoursMap)) {
            InputNumeric workHours = (InputNumeric)JsonUtil.objectToJavaObject((Object)workHoursMap, InputNumeric.class);
            workHours.setText(sumWorkHours.toString());
            workHours.setRequired(Boolean.valueOf(true));
            HashMap<String, List> workHoursRawData = new HashMap<String, List>(1);
            workHoursRawData.put("groupSubmitParamList", apiRequestSubmit.getGroupSubmitParamList());
            workHours.setRawData(workHoursRawData);
            List<ValidateRule> validateRuleList = CollectionUtils.isEmpty((Collection)workHours.getValidateRuleList()) ? new ArrayList() : workHours.getValidateRuleList();
            ValidateRule validateSameWorkHoursRule = new ValidateRule();
            validateSameWorkHoursRule.setSchema("work_hours");
            validateSameWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateSameWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateSameWorkHoursRule.setParameter(sumWorkHours.toString());
            validateSameWorkHoursRule.setOperatorType(Integer.valueOf(1));
            validateSameWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateSameWorkHoursRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u4e0e\u6267\u884c\u4eba\u6e05\u5355\u7d2f\u8ba1\u5de5\u65f6(" + sumWorkHours + "\uff09\u672a\u4fdd\u6301\u4e00\u81f4\uff01"));
            validateRuleList.add(validateSameWorkHoursRule);
            ValidateRule validateSumWorkHoursRule = new ValidateRule();
            validateSumWorkHoursRule.setSchema("work_hours");
            validateSumWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateSumWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateSumWorkHoursRule.setParameter(totalWorkHours.negate().toString());
            validateSumWorkHoursRule.setOperatorType(Integer.valueOf(6));
            validateSumWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateSumWorkHoursRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u8017\u7528\u603b\u5de5\u65f6\u4e0e\u5de5\u65f6\u7d2f\u8ba1\u4e0d\u53ef\u5c0f\u4e8e0\uff01"));
            validateRuleList.add(validateSumWorkHoursRule);
            workHours.setValidateRuleList(validateRuleList);
            RelationRule relationRule = Optional.ofNullable(workHours.getRelationRule()).orElse(new RelationRule());
            List ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList());
            CommonRule reportDateNotEditCommonRule = new CommonRule();
            reportDateNotEditCommonRule.setTargetSchema("report_date");
            reportDateNotEditCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            reportDateNotEditCommonRule.setTargetHidden(Boolean.valueOf(false));
            reportDateNotEditCommonRule.setTargetEnable(Boolean.valueOf(true));
            reportDateNotEditCommonRule.setTargetRequired(Boolean.valueOf(false));
            ruleList.add(reportDateNotEditCommonRule);
            CommonRule reportDateSetDefaultDateCommonRule = new CommonRule();
            reportDateSetDefaultDateCommonRule.setTargetSchema("report_date");
            reportDateSetDefaultDateCommonRule.setCondition(CommonRuleCondition.CONDITION_EMPTY_RESET.getType());
            reportDateSetDefaultDateCommonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
            reportDateSetDefaultDateCommonRule.setTargetHidden(Boolean.valueOf(false));
            reportDateSetDefaultDateCommonRule.setTargetEnable(Boolean.valueOf(true));
            reportDateSetDefaultDateCommonRule.setTargetRequired(Boolean.valueOf(false));
            ruleList.add(reportDateSetDefaultDateCommonRule);
            relationRule.setRuleList(ruleList);
            workHours.setRelationRule(relationRule);
            HashMap<String, InputNumeric> rawData = new HashMap<String, InputNumeric>(1);
            rawData.put("work_hours", workHours);
            action.setRawData(rawData);
        }
        return action;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

