/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.qrcode;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildQrCodeSearchTaskListStrategy")
public class UiBotModelBuildQrCodeSearchTaskListStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildQrCodeSearchTaskListStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build QrCode SearchTask List");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        Map rawData = apiRequest.getRawData().getInnerMap();
        if (Objects.isNull(rawData.get("searchedBacklogList"))) {
            return UiBotModel.emptyTaskUibotModel((String)apiRequest.getLocale());
        }
        List searchedBacklogList = (List)JsonUtil.objectToJavaObject(rawData.get("searchedBacklogList"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Collection)searchedBacklogList)) {
            return UiBotModel.emptyTaskUibotModel((String)apiRequest.getLocale());
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        TodoList todoList = new TodoList();
        this.uiBotModelBuildMyTaskListStrategy.paddingMobileTaskListFormWithOutFilterList(apiRequest, searchedBacklogList, todoList, true, tenantVersion);
        if (CollectionUtils.isEmpty((Collection)todoList.getTodoList())) {
            return UiBotModel.emptyTaskUibotModel((String)apiRequest.getLocale());
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TODO_LIST": {
                    todoList.setCalenderType(Integer.valueOf(1));
                    pageData.put((Object)schema, (Object)todoList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

