/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.schedulereport;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcCommonAttachmentDetailStrategy")
public class TaskDetailBuildApcCommonAttachmentDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcCommonAttachmentDetailStrategy.class);
    private static final String ATTACHMENT_SCHEMA_PREFIX = "source_type_";
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build APC Attachemnt Detail Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map data = (Map)MapUtil.getOrDefault((Map)rawData, (String)"data", Collections.emptyMap());
        HashMap queryRawData = new HashMap();
        queryRawData.put("wo_no", data.get("wo_no"));
        queryRawData.put("plot_no", data.get("plot_no"));
        queryRawData.put("op_seq", data.get("op_seq"));
        queryRawData.put("op_no", data.get("op_no"));
        queryRawData.put("sub_op_seq", data.get("sub_op_seq"));
        queryRawData.put("sub_op_no", data.get("sub_op_no"));
        HashMap reportInfoMap = new HashMap(1);
        reportInfoMap.put("wo_op_report_attachment_data", Collections.singletonList(queryRawData));
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("parameter", reportInfoMap);
        requestParamMap.put("actionId", "bm.opsc.lc.wo.op.report.attachment.get");
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestParamMap);
        List woOpReportAttachmentDataList = Optional.ofNullable(resp).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List)e.get((Object)"wo_op_report_attachment_data")).orElse(Collections.emptyList());
        woOpReportAttachmentDataList = woOpReportAttachmentDataList.stream().filter(e -> !ObjectUtils.isEmpty(e.get("attachment"))).collect(Collectors.toList());
        Map<Object, Object> woOpReportAttachmentDataMapBySourceType = new HashMap();
        if (!CollectionUtils.isEmpty(woOpReportAttachmentDataList)) {
            woOpReportAttachmentDataMapBySourceType = woOpReportAttachmentDataList.stream().collect(Collectors.groupingBy(e -> MapUtils.getString((Map)e, (Object)"source_type")));
        }
        stopWatch.start("Build APC Attachemnt Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List customGroupUiBotLayouts = customGroupContent.getLayout();
                    Iterator customGroupUiBotLayoutIterator = customGroupUiBotLayouts.iterator();
                    while (customGroupUiBotLayoutIterator.hasNext()) {
                        UiBotLayout customGroupUiBotLayout = (UiBotLayout)customGroupUiBotLayoutIterator.next();
                        String customGroupSchema = customGroupUiBotLayout.getSchema();
                        switch (customGroupUiBotLayout.getType()) {
                            case "ATTACHMENT": {
                                String sourceType = customGroupSchema.replace(ATTACHMENT_SCHEMA_PREFIX, "");
                                List attachmentDataListBySourceType = (List)woOpReportAttachmentDataMapBySourceType.get(sourceType);
                                if (CollectionUtils.isEmpty((Collection)attachmentDataListBySourceType)) {
                                    customGroupUiBotLayoutIterator.remove();
                                    break;
                                }
                                List dataList = attachmentDataListBySourceType.stream().map(e -> {
                                    Map attachmentBySourceType = (Map)MapUtil.getOrDefault((Map)e, (String)"attachment", Collections.emptyMap());
                                    return (List)MapUtil.getOrDefault((Map)attachmentBySourceType, (String)"data", Collections.emptyList());
                                }).flatMap(Collection::stream).collect(Collectors.toList());
                                Attachment attachment = Attachment.createAttachment(dataList, null, (String)this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel()));
                                customGroupContent.getPageData().put((Object)customGroupSchema, (Object)attachment);
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)customGroupUiBotLayouts)) {
                        layout.setType("EMPTY");
                        uiBotModel.getPageData().put((Object)schema, (Object)Empty.create((String)this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e"), (boolean)true));
                        break;
                    }
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale, (String)"\u5173\u95ed");
                    uiBotModel.getPageData().put((Object)schema, Collections.singletonList(submitButton));
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

