/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.snm;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanMulti;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanSingle;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailCustom;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskDetailBuildSnmPasteDetailItemDetailStrategy")
public class TaskDetailBuildSnmPasteDetailItemDetailStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildSnmPasteDetailItemDetailStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    public String getTaskDetailType() {
        return PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_PASTE_DETAIL_ITEM_DETAIL.toString();
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailCustom taskDetailCustom = new TaskDetailCustom(this.localeService);
        Map itemDataResponse = this.zhilinkService.woProductItemSummaryInfoGet(apiRequest, pcUiBotModel);
        List itemDataList = (List)itemDataResponse.get("item_data");
        String schema = pcUiBotModel.searchBizDataSchema();
        if (null != itemDataList && !itemDataList.isEmpty()) {
            pcUiBotModel.getPageData().put((Object)schema, (Object)itemDataList);
        }
        String requestItemNo = apiRequest.getRawData().getJSONObject("data").getJSONArray(schema).getJSONObject(0).getString("item_no");
        for (Map currentItemData : itemDataList) {
            String itemDataItemNo = (String)currentItemData.get("item_no");
            if (!Objects.equals(requestItemNo, itemDataItemNo)) continue;
            this.createBySingleBizDataItem(apiRequest, pageSetting, pcUiBotModel, taskDetailCustom, currentItemData);
        }
        return taskDetailCustom;
    }

    private void createBySingleBizDataItem(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, TaskDetailCustom taskDetailCustom, Map<String, Object> bizDataItem) {
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        UiBotPageData pageData = pageSettingModel.getPageData();
        for (int i = 0; i < pageSettingModel.getLayout().size(); ++i) {
            String fieldLabel;
            String newCheckUrl;
            String oldCheckUrl;
            UiBotLayout pageSettingLayout = (UiBotLayout)pageSettingModel.getLayout().get(i);
            String bizDataSchema = pageSettingLayout.getSchema();
            String type = pageSettingLayout.getType();
            if (type.equals("FIELD")) {
                String fieldLabel2 = Optional.ofNullable(pageSettingLayout.getmLabelText()).map(labelTextMap -> (String)labelTextMap.get(apiRequest.getLocale())).orElse(bizDataSchema);
                Field fieldComponent = Field.create((String)fieldLabel2, null, (String)String.valueOf(bizDataItem.get(bizDataSchema)), (String)bizDataSchema);
                if (fieldComponent.getValue().trim().isEmpty()) continue;
                taskDetailCustom.put((Object)bizDataSchema, (Object)fieldComponent);
                continue;
            }
            if (type.equals("INPUT_SCAN_SINGLE")) {
                InputScanSingle inputScanSingle = (InputScanSingle)JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()), InputScanSingle.class);
                if (Optional.ofNullable(inputScanSingle.getCheck()).orElse(false).booleanValue()) {
                    oldCheckUrl = inputScanSingle.getCheckUrl();
                    newCheckUrl = AppContext.getBaseUrl() + oldCheckUrl;
                    inputScanSingle.setCheckUrl(newCheckUrl);
                }
                fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText()).map(labelTextMap -> (String)labelTextMap.get(apiRequest.getLocale())).orElse(bizDataSchema);
                inputScanSingle.setTitle(fieldLabel);
                HashMap<String, Object> rawData = new HashMap<String, Object>();
                rawData.put("data", bizDataItem.get("wo_data"));
                inputScanSingle.setRawData(rawData);
                taskDetailCustom.put((Object)bizDataSchema, (Object)inputScanSingle);
                continue;
            }
            if (type.equals("INPUT_SCAN_MULTI")) {
                InputScanMulti inputScanMulti = (InputScanMulti)JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()), InputScanMulti.class);
                if (Optional.ofNullable(inputScanMulti.getCheck()).orElse(false).booleanValue()) {
                    oldCheckUrl = inputScanMulti.getCheckUrl();
                    newCheckUrl = AppContext.getBaseUrl() + oldCheckUrl;
                    inputScanMulti.setCheckUrl(newCheckUrl);
                }
                fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText()).map(labelTextMap -> (String)labelTextMap.get(apiRequest.getLocale())).orElse(bizDataSchema);
                inputScanMulti.setTitle(fieldLabel);
                inputScanMulti.setRawData(this.zhilinkService.getScanRawDataInPasteDetail(pcUiBotModel, (List)bizDataItem.get("wo_data")));
                taskDetailCustom.put((Object)bizDataSchema, (Object)inputScanMulti);
                continue;
            }
            if (!type.equals("BOTTOM_BUTTON")) continue;
            BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()), BottomButtonList.class);
            bottomButtonList.forEach(bottomButton -> {
                String oldName = bottomButton.getName();
                String newName = LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)oldName);
                bottomButton.setName(newName);
            });
            taskDetailCustom.put((Object)bizDataSchema, (Object)bottomButtonList);
        }
    }
}

