/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="taskDetailBuildTbdsProductionProcessRecordModifyParamStrategy")
public class TaskDetailBuildTbdsProductionProcessRecordModifyParamStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildTbdsProductionProcessRecordModifyParamStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress record modify param");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        List parameterDatas = (List)rawData.get("data");
        ArrayList<UiBotLayout> newUiBotLayouts = new ArrayList<UiBotLayout>();
        block8: for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "INPUT_SINGLE": {
                    for (Map parameterData : parameterDatas) {
                        String dataSchema = (String)parameterData.get("parameter_no");
                        String label = ModuleUtils.emptyValueToHyphen(parameterData.get(layout.getLabel()));
                        newUiBotLayouts.add(new UiBotLayout(dataSchema, "INPUT_SINGLE"));
                        String flag = (String)parameterData.get(layout.getMBizKey());
                        pageData.put((Object)dataSchema, (Object)InputSingleText.create((String)dataSchema, (String)label, (Boolean)(!flag.equalsIgnoreCase("N") ? 1 : 0), (Boolean)true, (String)locale, (String)((String)parameterData.get(schema)), (Boolean)false));
                    }
                    continue block8;
                }
                case "BOTTOM_BUTTON": {
                    newUiBotLayouts.add(layout);
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(arg_0 -> this.lambda$doActually$0(locale, (Map)rawData, apiRequest, arg_0));
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        uiBotModel.setLayout(newUiBotLayouts);
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private /* synthetic */ void lambda$doActually$0(String locale, Map rawData, ApiRequest apiRequest, BottomButtonDigiwinAthena bottomButtonDigiwinAthena) {
        String buttonName = bottomButtonDigiwinAthena.getName();
        if (StringUtils.hasLength((String)buttonName)) {
            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, buttonName));
            if (bottomButtonDigiwinAthena.getIsCheckButton().booleanValue()) {
                Action action = bottomButtonDigiwinAthena.getAction();
                rawData.put("biz_id", "TBDS");
                rawData.put("pageId", apiRequest.getPageId());
                rawData.put("refreshPageId", apiRequest.getRefreshPageId());
                action.setRawData((Object)rawData);
            }
        }
    }
}

