/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds.TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildTbdsProductionProgressReportDetailStrategy")
public class TaskDetailBuildTbdsProductionProgressReportDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Tbds Production Progress Report Detail");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map processData = (Map)apiRawData.get((Object)"data");
        Boolean reworkTimes = (Integer)MapUtil.getOrDefault((Map)processData, (String)"rework_times", (Object)0) > 0;
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    if (!reworkTimes.booleanValue() && ("rework_operation".equalsIgnoreCase(schema) || "rework_reason".equalsIgnoreCase(schema))) break;
                    String name = this.localeService.getLanguageValue(locale, layout.getLabel());
                    String data = String.valueOf(MapUtil.getOrDefault((Map)processData, (String)schema, (Object)""));
                    Field field = Field.createLabelLeftValueRightField((String)name, (String)data);
                    pageData.put((Object)schema, (Object)field);
                    break;
                }
                case "PICTURE": {
                    Picture picture = new Picture();
                    Field picturePageData = null;
                    if ("resource_data".equalsIgnoreCase(schema)) {
                        if (Objects.isNull(processData.get("resource_data"))) break;
                        List resourceDataList = (List)processData.get("resource_data");
                        if (!CollectionUtils.isEmpty(resourceDataList = resourceDataList.stream().filter(e -> "1".equals(e.get("resource_base"))).collect(Collectors.toList()))) {
                            Attachment attachment = Attachment.createTbdsFiles(resourceDataList, (String)this.localeService.getLanguageValue(locale, layout.getLabel()));
                            attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                            attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                            BeanUtils.copyProperties((Object)attachment, (Object)picture);
                            AttachmentRawDataDigiwinAthena pictureRawData = new AttachmentRawDataDigiwinAthena();
                            pictureRawData.setBuckets("tbds");
                            picture.setRawData((AttachmentRawData)pictureRawData);
                            picturePageData = picture;
                        } else {
                            layout.setType("FIELD");
                            picturePageData = Field.createLabelLeftValueRightField((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"");
                        }
                    }
                    pageData.put((Object)schema, picturePageData);
                    break;
                }
                case "ATTACHMENT": {
                    List documentInfos;
                    Attachment attachmentPageData = null;
                    List documentInfoList = (List)MapUtil.getOrDefault((Map)processData, (String)"document_info", Collections.emptyList());
                    List attachmentData = Optional.ofNullable(documentInfoList).map(filesList -> filesList.stream().map(file -> Optional.ofNullable((Map)file.get("attachment")).orElse(new HashMap())).map(attachmentInfo -> Optional.ofNullable((List)attachmentInfo.get("data")).orElse(new ArrayList())).flatMap(Collection::stream).collect(Collectors.toList())).orElse(new ArrayList());
                    if ("historical_attachments".equalsIgnoreCase(schema) && !CollectionUtils.isEmpty(documentInfos = attachmentData.stream().filter(e -> "tbds".equals(e.get("category"))).collect(Collectors.toList()))) {
                        attachmentPageData = Attachment.createTbdsFiles(documentInfos, (Integer)AttachmentTypeEnum.READ_ONLY.getValue(), (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue(), (String)"tbds", (Integer)SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                    }
                    if ("attachments".equalsIgnoreCase(schema)) {
                        documentInfos = attachmentData.stream().filter(e -> "CTP".equals(e.get("category"))).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(documentInfos)) {
                            attachmentPageData = Attachment.createTbdsFiles(documentInfos, (Integer)AttachmentTypeEnum.READ_ONLY.getValue(), (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue(), (String)"CTP", (Integer)SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                        } else {
                            layout.setType("FIELD");
                            attachmentPageData = Field.createLabelLeftValueRightField((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"");
                        }
                    }
                    pageData.put((Object)schema, attachmentPageData);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(1);
                    BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale);
                    buttonList.add(cancelButton);
                    pageData.put((Object)schema, buttonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

