/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumb;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.processnode.ProcessNode;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildTbdsProductionProgressRecordNextStepStrategy")
public class UiBotModelBuildTbdsProductionProgressRecordNextStepStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressRecordNextStepStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress report");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String currentSeq;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        BreadCrumb parentBreadCrumb = null;
        Boolean hasButton = true;
        Boolean isSubmit = false;
        if (rawData.get("isSubmit") != null) {
            isSubmit = (Boolean)rawData.get("isSubmit");
        }
        Boolean isRecipe = (Boolean)rawData.get("is_recipe");
        int processNo = 0;
        String reportNo = (String)rawData.get("report_no");
        if (rawData.get("hasButton") != null) {
            hasButton = (Boolean)rawData.get("hasButton");
        }
        if (!StringUtils.hasLength((String)reportNo) && hasButton.booleanValue()) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        if (rawData.get("nodeNo") != null) {
            processNo = (Integer)rawData.get("nodeNo");
        }
        int crumbLength = 1;
        if (rawData.get("crumbLength") != null) {
            crumbLength = (Integer)rawData.get("crumbLength");
        } else if (apiRequest.getCrumbLength() != null) {
            crumbLength = apiRequest.getCrumbLength();
        }
        String breadName = (String)rawData.get("breadName");
        Map newParameter = (Map)rawData.get("newParameter");
        Map executeContext = (Map)rawData.get("executeContext");
        Map businessUnit = new HashMap();
        if (!CollectionUtils.isEmpty((Map)executeContext)) {
            businessUnit = (Map)executeContext.get("businessUnit");
        }
        if (crumbLength > 0 && rawData.get("currentCrumb") != null) {
            parentBreadCrumb = (BreadCrumb)JsonUtil.objectToJavaObject(rawData.get("currentCrumb"), BreadCrumb.class);
            Map parentRawData = ((BreadCrumbNode)parentBreadCrumb.getData().get(crumbLength - 1)).getRawData();
            String title = ((BreadCrumbNode)parentBreadCrumb.getData().get(crumbLength - 1)).getTitle();
            if (parentRawData.get("breadName") == null && parentRawData.get("currentCrumb") != null) {
                parentBreadCrumb = (BreadCrumb)JsonUtil.objectToJavaObject(parentRawData.get("currentCrumb"), BreadCrumb.class);
                parentRawData = ((BreadCrumbNode)parentBreadCrumb.getData().get(crumbLength - 1)).getRawData();
            }
            if (rawData.get("is_recipe") == null && parentRawData.get("is_recipe") != null) {
                isRecipe = (Boolean)parentRawData.get("is_recipe");
            }
            if (isSubmit.booleanValue() && StringUtils.hasLength((String)title)) {
                breadName = title;
            }
            if (rawData.get("newParameter") == null) {
                newParameter = (Map)parentRawData.get("newParameter");
                if (rawData.get("currentNewParameter_" + crumbLength) != null) {
                    newParameter = (Map)rawData.get("currentNewParameter_" + crumbLength);
                } else {
                    Map findNew = parentBreadCrumb.searchCurrentNewParameter(parentBreadCrumb, crumbLength, newParameter);
                    if (!CollectionUtils.isEmpty((Map)findNew)) {
                        newParameter = findNew;
                    }
                }
            }
            for (int i = crumbLength - 1; i < parentBreadCrumb.getData().size(); ++i) {
                parentBreadCrumb.getData().remove(i);
            }
            if (rawData.get("executeContext") == null) {
                executeContext = (Map)parentRawData.get("executeContext");
            }
            businessUnit = (Map)executeContext.get("businessUnit");
        }
        if (io.micrometer.core.instrument.util.StringUtils.isEmpty((String)(currentSeq = (String)((Map)((List)newParameter.get("query_info")).get(0)).get("parent_seq")))) {
            currentSeq = (String)((Map)((List)newParameter.get("query_info")).get(0)).get("parent_seq");
        } else {
            ((Map)((List)newParameter.get("query_info")).get(0)).put("parent_seq", currentSeq);
        }
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create((String)"bm.opsc.trial.production.complete.get", (Map)newParameter, (Map)executeContext, businessUnit);
        List opDatas = this.digiwinAtdmProxyService.tbdsDataQueryByActionId(locale, iamUserToken, JsonUtil.javaObjectToJsonString((Object)request), tenantId);
        if (CollectionUtils.isEmpty((Collection)opDatas) && (rawData.get("currentCrumb") == null || parentBreadCrumb == null || CollectionUtils.isEmpty((Collection)parentBreadCrumb.getData())) && !CollectionUtils.isEmpty((Collection)((Collection)rawData.get("rawDataList")))) {
            opDatas = (List)rawData.get("rawDataList");
        }
        if (CollectionUtils.isEmpty((Collection)opDatas)) {
            return UiBotModel.emptyImageUibotModel((String)locale, (String)"\u6682\u65e0\u6570\u636e", (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
        }
        Map opData = (Map)opDatas.get(0);
        ArrayList<UiBotLayout> newUibotlayouts = new ArrayList<UiBotLayout>(3);
        Map commonRawData = uiBotModel.getCommonRawData();
        rawData.put("pageId", apiRequest.getPageId());
        if (isRecipe == null) {
            isRecipe = rawData.get("breadRecipt") != null ? (Boolean)rawData.get("breadRecipt") : (breadName.contains(this.localeService.getLanguageValue(locale, "\u6750\u6599")) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "PROCESS_NODE": {
                    if (!isRecipe.booleanValue()) break;
                    newUibotlayouts.add(layout);
                    ProcessNode processNode = (ProcessNode)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), ProcessNode.class);
                    pageData.put((Object)schema, (Object)ProcessNode.create((UiBotModel)uiBotModel, (ProcessNode)processNode, (List)opDatas, (LocaleService)this.localeService, (String)locale, (DigiwinAtdmProxyService)this.digiwinAtdmProxyService, (ApiRequest)apiRequest, (Boolean)hasButton, (int)processNo, (DigiwinEspProxyService)this.digiwinEspProxyService, (String)reportNo));
                    break;
                }
                case "BREAD_CRUMB": {
                    newUibotlayouts.add(layout);
                    rawData.remove("currentCrumb");
                    BreadCrumb breadCrumb = new BreadCrumb();
                    if (parentBreadCrumb != null && !CollectionUtils.isEmpty((Collection)parentBreadCrumb.getData())) {
                        breadCrumb.getData().addAll(parentBreadCrumb.getData());
                    }
                    rawData.put("currentSeq", currentSeq);
                    rawData.put("is_recipe", isRecipe);
                    if (!rawData.containsKey("newParameter")) {
                        rawData.put("newParameter", newParameter);
                    }
                    breadCrumb.getData().add(new BreadCrumbNode(breadName, (Map)rawData, "", "/mobile/v1/proxy/get/breadCrumb/data"));
                    uiBotModel.getCommonRawData().put("currentCrumb", breadCrumb);
                    pageData.put((Object)schema, (Object)breadCrumb);
                    break;
                }
                case "CUSTOM_GROUP": {
                    if (isRecipe.booleanValue()) break;
                    newUibotlayouts.add(layout);
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_OUTSIDE_THE_TITLE_GROUP.getValue());
                    customGroup.setName(this.localeService.getLanguageValue(locale, customGroup.getName()));
                    List itemList = (List)opData.get(schema);
                    uiBotModel.buildCommonRawData(commonRawData, opData, uiBotModel);
                    commonRawData.put("trial_op_report_item_list", itemList);
                    customGroup.buildTbdsItemList(customGroup, locale, this.localeService, itemList, (Map)rawData, this.digiwinAtdmProxyService, apiRequest, hasButton, Boolean.valueOf(false), Boolean.valueOf(false));
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
            }
        }
        uiBotModel.setLayout(newUibotlayouts);
        uiBotModel.getCommonRawData().put("hasButton", hasButton);
        if (rawData.get("report_no") != null) {
            uiBotModel.getCommonRawData().put("report_no", rawData.get("report_no"));
            uiBotModel.getCommonRawData().put("executeContext", executeContext);
            uiBotModel.getCommonRawData().put("currentNewParameter_" + crumbLength, newParameter);
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

