/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.workreportinfo;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBarStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="taskDetailBuildPccWorkReportInfoStrategy")
public class TaskDetailBuildPccWorkReportInfoStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildPccWorkReportInfoStrategy.class);
    private static final String TMACTIVITYID = "DataEntry_workreportinfo";
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;
    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformerImpl;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private UserCardListFilterService userCardListFilterService;
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Work Report Info Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        ArrayList<BaseMobileComponentWrapper> bodyCmptList = new ArrayList<BaseMobileComponentWrapper>();
        String eocId = this.digiwinEocProxyService.getEocId(apiRequest.getIamUserToken(), apiRequest.getUserId());
        String employeeNo = StringUtils.hasLength((String)eocId) ? eocId : apiRequest.getUserId();
        HashMap<String, String> employeeInfoMap = new HashMap<String, String>();
        employeeInfoMap.put("employee_no", employeeNo);
        HashMap queryConditionMap = new HashMap();
        queryConditionMap.put("employee_info", Collections.singletonList(employeeInfoMap));
        UserCardListFilter userCardListFilter = this.userCardListFilterService.getUserCardListFilterByTmActivityIdAndUserId(new UserCardListFilterQueryDTO().setTenantId(AppRequestContext.getContextEntity().getTenantId()).setUserId(AppRequestContext.getContextEntity().getUserId()).setTmActivityId(TMACTIVITYID));
        String data = Optional.ofNullable(userCardListFilter).map(UserCardListFilter::getData).orElse("");
        if (StringUtils.hasLength((String)data)) {
            Map dataMap = (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
            queryConditionMap.putAll(dataMap);
            queryConditionMap.put("project_info", queryConditionMap.get("project_info_condition"));
            queryConditionMap.remove("project_info_condition");
        }
        HashMap parameter = new HashMap(1);
        parameter.put("query_condition", Collections.singletonList(queryConditionMap));
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("parameter", parameter);
        params.put("actionId", "task.report.record.info.get");
        DigiwinAthenaApiResponse getTaskReportRecordResp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), null, params);
        List<Map> taskReportRecordInfoList = (List<Map>)MapUtil.getOrDefault((Map)((JSONObject)getTaskReportRecordResp.getResponse()).getInnerMap(), (String)"report_info", Collections.emptyList());
        if (taskReportRecordInfoList.size() == 1 && StringUtils.hasLength((String)MapUtils.getString((Map)((Map)taskReportRecordInfoList.get(0)), (Object)"errg_msg"))) {
            String errgMsg = MapUtils.getString((Map)((Map)taskReportRecordInfoList.get(0)), (Object)"errg_msg");
            String emptyDateMsg = this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e");
            if (!emptyDateMsg.equals(errgMsg)) {
                BaseMobileComponentWrapper baseMobileComponentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)MessageBar.create((String)errgMsg, (Integer)MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType()), "DW_MESSAGE_BAR");
                bodyCmptList.add(baseMobileComponentWrapper);
            }
            taskReportRecordInfoList.clear();
        }
        taskReportRecordInfoList = taskReportRecordInfoList.stream().sorted((o1, o2) -> {
            LocalDateTime o1SDate = DateTimeUtil.parseUseDefaultPattern((String)MapUtils.getString((Map)o1, (Object)"report_date"));
            LocalDateTime o2SDate = DateTimeUtil.parseUseDefaultPattern((String)MapUtils.getString((Map)o2, (Object)"report_date"));
            return o2SDate.compareTo(o1SDate);
        }).collect(Collectors.toList());
        AtomicInteger index = new AtomicInteger(1);
        taskReportRecordInfoList.forEach(e -> {
            e.put("index", index.getAndIncrement());
            e.put("project_detail", e.get("project_name") + "[" + e.get("project_no") + "]");
            e.put("translate_report_complete_rate", new BigDecimal(String.valueOf(MapUtils.getDoubleValue((Map)e, (Object)"report_complete_rate"))).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString() + "%");
        });
        MobileDesignerConfig config = this.mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        List<UiBotPageLayout> uiBotPageLayoutList = Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> {
            MobileRenderDataUtil.multilingualProcessing((Map)r, (String)AppRequestContext.getContextEntity().getLocale());
            return r;
        }).map(r -> r.getJSONObject("pageDslMobile")).map(r -> (Map)r.getJSONArray("layout").get(0)).map(r -> (Map)r.get("data")).map(r -> r.get("data")).map(r -> (List)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(uiBotPageLayoutList)) {
            uiBotPageLayoutList.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));
        }
        UiBotQueryButton queryButton = new UiBotQueryButton();
        queryButton.setPageLayout(uiBotPageLayoutList);
        List hooks = Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> r.getJSONObject("pageDslMobile")).map(r -> r.getJSONArray("hooks")).orElse(Collections.emptyList());
        queryButton.setHooks(hooks);
        PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = new PcUiBotDataSourceSetDTO();
        pcUiBotDataSourceSetDTO.setMainDatasource("report_info");
        queryButton.setDataSourceSet((Map)JsonUtil.objectToJavaObject((Object)pcUiBotDataSourceSetDTO, Map.class));
        UiBotPageData uiBotPageData = new UiBotPageData();
        uiBotPageData.put((Object)"report_info", taskReportRecordInfoList);
        uiBotModel.setPageData(uiBotPageData);
        PcUiBotExecuteContext pcUiBotExecuteContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)apiRequest.getDataId());
        pcUiBotExecuteContext.appendPageInfo("task-detail-mobile", null, apiRequest.getDataId(), "performer", Boolean.FALSE);
        pcUiBotExecuteContext.setTmActivityId(TMACTIVITYID);
        pcUiBotExecuteContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        ComponentContext cmptContext = (ComponentContext)JsonUtil.objectToJavaObject((Object)apiRequest, ComponentContext.class);
        this.uiBotDesignerRenderService.buildMainPageHooksByQueryButton(queryButton, cmptContext, uiBotModel, null);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.WORK_REPORT_INFO.name());
        List buildBodyCmptList = this.businessProcessPerformerImpl.buildBodyCmpt(pcUiBotExecuteContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
        if (!CollectionUtils.isEmpty((Collection)buildBodyCmptList)) {
            bodyCmptList.addAll(buildBodyCmptList);
        }
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer singleListContainer = new SingleListContainer();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }
            List bottomCmptList = this.businessProcessPerformerImpl.buildBottomCmpt(pcUiBotExecuteContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
            if (!CollectionUtils.isEmpty((Collection)bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
        return uiBotModel;
    }

    public static String getTmactivityid() {
        return TMACTIVITYID;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

