package com.digiwin.mobile.mobileuibot;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;


/**
 * <p>功能描述：本工程默认地址的接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @author zhangjj
 * @date 2021/8/4 0004 15:54
 */
@RestController
public class HomeController {

    @RequestMapping(value = "", method = RequestMethod.GET)
    public ApiResponse<Map<String, String>> showHome() {
        String title = "Welcome to ATHENA_MOBILE!";
        Map<String, String> homeMap = new HashMap<>(3);
        homeMap.put("title", title);
        homeMap.put("version", AppContext.getApiUrlSetting().getApplicationVersion());
        homeMap.put("buildTimestamp", AppContext.getApiUrlSetting().getApplicationBuildTimestamp());
        homeMap.put("currentTimestamp", LocalDateTime.now().toString());

        return ApiResponse.buildOK().setData(homeMap);
    }
}