package com.digiwin.mobile.mobileuibot.abireport;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ABI报表展示页面
 *
 * @author 吴阳
 * @date 20230103
 */
@Component("uiBotModelBuildAbiReportDetailStrategy")
public class UiBotModelBuildAbiReportDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildAbiReportDetailStrategy.class);

    private static final String SELECT_TAG = "hashCode";
    private static final String STATEMENT_RESID = "STATEMENT__resid";

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String resid = "";
        UiBotAction action = null;
        String conditionId = "";
        String conditionName = "";
        String hashKey;
        Map<String, Object> conditionData = new HashMap<>();
        Boolean useCommon = false;
        Boolean isFirst = true;
        //0.先看是不是点击查询按钮查看的报表
        ApiRawData rawData = apiRequest.getRawData();
        if (rawData.getString(SELECT_TAG) != null) {
            resid = rawData.getString(STATEMENT_RESID);
            hashKey = rawData.getString(SELECT_TAG);
            action = JsonUtil.objectToJavaObject(rawData.getJSONObject("action"), UiBotAction.class);
            conditionId = rawData.getString("conditionId");
            conditionName = rawData.getString("conditionName");
            conditionData = (Map<String, Object>) rawData.get("data");
            useCommon = rawData.getBooleanValue("useCommon");
            isFirst = false;
        } else {
            //1.看是否有redis缓存
            UiBotModel pcUibotModel = digiwinPcUiBotProxyService.conditionShow
                    (locale, iamUserToken, tenantId, dataId);
            Map<String, Object> params = new HashMap<>(2);

            if (pcUibotModel != null && pcUibotModel.getPageData() != null && pcUibotModel.getPageData().get("STATEMENT__resid") != null) {
                resid = (String) pcUibotModel.getPageData().get(STATEMENT_RESID);
                action = pcUibotModel.getActions().get(0);
                params.put("action", action);
                UiBotLayout uiBotLayout = pcUibotModel.getLayout().get(0);
                Map<String, Object> data = new HashMap<>(1);
                data.put(uiBotLayout.getSchema(), pcUibotModel.getPageData().get(uiBotLayout.getSchema()));
                params.put("data", data);
            }
            //2.获取缓存的key
            hashKey = digiwinAtmcProxyService.getAbiDataCache(iamUserToken, tenantId, locale, params);
        }
        List<Button> appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(Button.createAbiReport(localeService.getLanguageValue(locale,
                "查询"), dataId, action, conditionId, conditionName, conditionData, useCommon, isFirst));
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!StringUtils.hasLength(hashKey)) {
            UiBotModel emptyUiBotModel = UiBotModel.emptyAbiReportUiBotModel(locale, "请设定或选择条件以查询报表内容", "选择条件", dataId);
            emptyUiBotModel.setAppbarButtonList(appbarButtonList);
            return emptyUiBotModel;
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case Webview.COMPONENT_TYPE:
                    Webview webview = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Webview.class);
                    String url = webview.getUrl();
                    url = AppContext.getApiUrlSetting().getBiUrl() + url;
                    if (url.contains("${resid}")) {
                        url = url.replace("${resid}", resid);
                    }
                    if (url.contains("${hashKey}")) {
                        url = url.replace("${hashKey}", hashKey);
                    }
                    if (url.contains("${token}")) {
                        url = url.replace("${token}", iamUserToken);
                    }
                    if (url.contains("${tenantId}")) {
                        url = url.replace("${tenantId}", tenantId);
                    }
                    if (url.contains("${athenaUrl}")) {
                        url = url.replace("${athenaUrl}", AppContext.getApiUrlSetting().getMuiUrl());
                    }
                    webview.setUrl(url);
                    webview.setVerticalScroll(true);
                    webview.setWidthMode(1);
                    webview.setSizeMode(0);
                    pageData.put(layout.getSchema(), webview);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
