package com.digiwin.mobile.mobileuibot.abireport;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ABI报表右上角条件查询页面
 *
 * @author 吴阳
 * @date 20230103
 */
@Component("uiBotModelBuildAbiReportInfoStrategy")
public class UiBotModelBuildAbiReportInfoStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildAbiReportInfoStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> data = new HashMap<>(1);
        Boolean useCommon = (Boolean) rawData.get("useCommon");
        String conditionName = "";
        if (useCommon != null && useCommon) {
            data = (Map<String, Object>) rawData.get("data");
            conditionName = (String) rawData.get("conditionName");
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        //ABI报表查询条件的UibotModel
        UiBotModel pcUibotModel = digiwinPcUiBotProxyService.conditionShow
                (locale, iamUserToken, tenantId, dataId);
        if (pcUibotModel != null && pcUibotModel.getLayout() != null) {
            CustomGroup customGroup;
            String textSchema = "conditionName";
            String inputSwitchSchema = "inputSwitch";
            for (UiBotLayout uiBotLayout : uiBotLayouts) {
                switch (uiBotLayout.getType()) {
//                    case CommonConditions.COMPONENT_TYPE:
//                        pageData.put(uiBotLayout.getSchema(), buildCommonConditions(pcUibotModel,
//                                apiRequest, uiBotLayout.getLabel(), commonConditions));
//                        break;
                    case CustomGroup.COMPONENT_TYPE:
                        customGroup = buildCustomGroup(pcUibotModel, locale, uiBotLayout.getLabel(), data, iamUserToken);
                        pageData.put(uiBotLayout.getSchema(), customGroup);
                        if (customGroup != null) {
                            CustomGroupContent content = customGroup.getContent();
                            content.getLayout().add(new UiBotLayout(inputSwitchSchema, InputSwitch.COMPONENT_TYPE));
                            content.getLayout().add(new UiBotLayout(textSchema, InputSingleText.COMPONENT_TYPE));
                            if (StringUtil.isNotEmpty(conditionName)) {
                                content.getPageData().put(inputSwitchSchema, InputSwitch.createByAbiCondition(true, localeService.getLanguageValue(locale, "保存为常用条件"), textSchema));
                                content.getPageData().put(textSchema, InputSingleText.create(textSchema,
                                        localeService.getLanguageValue(locale, "常用条件名称"),
                                        true, true, locale, conditionName, false));
                            } else {
                                content.getPageData().put(inputSwitchSchema, InputSwitch.createByAbiCondition(false, localeService.getLanguageValue(locale, "保存为常用条件"), textSchema));
                                content.getPageData().put(textSchema, InputSingleText.create(textSchema,
                                        localeService.getLanguageValue(locale, "常用条件名称"),
                                        false, false, locale, "", true));
                            }

                            customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING.getValue());
                        }
                        break;
                    case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                        List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(uiBotLayout.getSchema()), BottomButtonDigiwinAthena.class);
                        for (BottomButtonDigiwinAthena bottomButton : buttons) {
                            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                            Action action = bottomButton.getAction();
                            Map<String, Object> actionRawData = (Map<String, Object>) action.getRawData();
                            if (actionRawData != null) {
                                actionRawData.put("data", pcUibotModel.getPageData());
                                actionRawData.put("layout", pcUibotModel.getLayout());
                                actionRawData.put("action", pcUibotModel.getActions().get(0));
                                actionRawData.put("dataId", dataId);
                                actionRawData.put("isAbi", true);
                                action.setRawData(actionRawData);
                                ConfirmPop confirmPop = new ConfirmPop();
                                confirmPop.setContent(localeService.getLanguageValue(locale, "该名称已存在，是否覆盖") + "?");
                                confirmPop.setNeedConfirm(true);
                                confirmPop.setCompareContent(conditionName);
                                confirmPop.setCompareSchema(textSchema);
                                confirmPop.setCheckedSchema(inputSwitchSchema);
                                action.setConfirmPop(confirmPop);
                            }
                        }
                        pageData.put(uiBotLayout.getSchema(), buttons);
                        break;
                    default:
                        break;
                }
            }
        }

        return uiBotModel;
    }

    /**
     * 创建常用条件组件
     *
     * @param pcUibotModel
     * @param apiRequest
     * @param label
     * @param commonConditions
     * @return
     */
//    private CommonConditions buildCommonConditions(UiBotModel pcUibotModel, ApiRequest apiRequest,
//                                                   String label, List<Map<String, Object>> commonConditions) {
//        CommonConditions conditions = new CommonConditions();
//        conditions.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), label));
//        List<Button> conditionList = conditions.getConditions();
//        for (Map<String, Object> commonCodition : commonConditions) {
//            Button condition = new Button();
//            condition.setName((String) commonCodition.get("conditionName"));
//            condition.setShowNum(false);
//            Map<String, Object> conditionValue = (Map<String, Object>) commonCodition.get("conditionValue");
//            String schema = (String) conditionValue.get("UIBOT__schema");
//            condition.setId((String) conditionValue.get("STATEMENT__resid"));
//            condition.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
//            Action action = new Action();
//            Map<String, Object> rawData = new HashMap<>(2);
//            rawData.put("useCommon", true);
//            rawData.put("data", conditionValue.get(schema));
//            action.setRawData(rawData);
//            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_INFO.toString());
//            action.setJumpPageTitle("");
//            action.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
//            condition.setAction(action);
//            conditionList.add(condition);
//        }
//        return conditions;
//    }

    /**
     * 创建报表筛选条件页面
     *
     * @param pcUibotModel
     * @param locale
     * @param label
     * @param iamUserToken
     * @return
     */
    private CustomGroup buildCustomGroup(UiBotModel pcUibotModel, String locale, String label, Map<String, Object> data, String iamUserToken) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> pcUiBotLayouts = pcUibotModel.getLayout();
        UiBotPageData pcPageData = pcUibotModel.getPageData();
        if (!CollectionUtils.isEmpty(pcUiBotLayouts)) {
            UiBotLayout uiBotLayout = pcUiBotLayouts.get(0);
            if (!CollectionUtils.isEmpty((Collection<?>) pcPageData.get(uiBotLayout.getSchema()))) {
                if (CollectionUtils.isEmpty(data)) {
                    data = (Map<String, Object>) ((List) pcPageData.get(uiBotLayout.getSchema())).get(0);
                }
                //公司别
                List<Map<String, Object>> companys = digiwinEocProxyService.getCompany(iamUserToken);
                //工厂别
                List<Map<String, Object>> factorys = digiwinEocProxyService.getFactory(iamUserToken);
                if (!CollectionUtils.isEmpty(data) && !CollectionUtils.isEmpty(companys)
                        && !CollectionUtils.isEmpty(factorys)) {
                    data.put("companys", companys);
                    data.put("factorys", factorys);
                }
                customGroup = (CustomGroup) ModuleUtils.buildFormList(uiBotLayout, data,
                        pcUibotModel.getExecuteContext(), locale,
                        localeService.getLanguageValue(locale, label),
                        pcUibotModel.getRules(), true, true, false, iamUserToken);
            }
        } else {
            customGroup = CustomGroup.createEmptyGroup(locale, localeService.getLanguageValue(locale, label));
        }
        return customGroup;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
