package com.digiwin.mobile.mobileuibot.agileData.controller;

import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataAutoAnalystService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataQueryDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 敏捷数据auto分析师需求专用Controller
 *
 * @author yanfeng
 * @date 2025/8/21
 */
@Validated
@RestController
@RequestMapping("/mobile/agileData/v2/autoAnalyst")
public class AgileDataAutoAnalystController {

    @Autowired
    private IAgileDataAutoAnalystService autoAnalystService;

    /**
     * 生成分析报告
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("generateAutoAnalystReport")
    public ApiResponse generateAutoAnalystReport(@RequestBody AgileDataAutoDataQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(autoAnalystService.generateAutoAnalystReport(queryDTO));
    }

    /**
     * auto分析师下载报告
     * @param queryDTO
     * @return
     */
    @PostMapping("autoDataDownLoad")
    public ApiResponse autoDataDownLoad(@RequestBody AgileDataAutoDataQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(autoAnalystService.autoDataDownLoad(queryDTO));
    }

    /**
     * 获取auto分析师报告状态
     * @param queryDTO
     * @return
     */
    @PostMapping("getAutoDataReportStatus")
    public ApiResponse getAutoDataReportStatus(@RequestBody AgileDataAutoDataQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(autoAnalystService.getAutoDataReportStatus(queryDTO));
    }

}