package com.digiwin.mobile.mobileuibot.agileData.controller;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataAnalysisFluctuateQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataService;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AdtTablePreviewDataRequest;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoAnalysisDataDimensionResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoAnalysisDataSummaryResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoFilterData;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoUserDefineHabitualDTO;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 敏捷数据2.0控制器
 *
 * @author yanfeng
 * @date 2025/6/12
 */
@Validated
@RestController
@RequestMapping("/mobile/agileData/v2")
public class AgileDataController {

    @Autowired
    private IAgileDataService agileDataService;

    /**
     * 敏捷数据:获取数据集列表
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getTableList")
    public ApiResponse getTableList(@RequestBody AgileDataApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getTableList(apiRequest));
    }

    /**
     * 敏捷数据:获取数据集预览
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getTablePreviewData")
    public ApiResponse getTablePreviewData(@RequestBody AdtTablePreviewDataRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getTablePreviewData(apiRequest));
    }

    /**
     * 敏捷数据:保存用户习惯(比如追问开关)
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("saveUserHabitual")
    public ApiResponse saveUserHabitual(@RequestBody EchoUserDefineHabitualDTO apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.saveUserHabitual(apiRequest));
    }

    /**
     * 敏捷数据:获取用户习惯(比如追问开关)
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getUserHabitual")
    public ApiResponse getUserHabitual(@RequestBody AgileDataApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getUserHabitual(apiRequest));
    }

    /**
     * 根据快照Id获取可转换图表列表（历史数据使用）
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getTransList")
    public ApiResponse getTransList(@RequestBody AgileDataApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getTransList(apiRequest));
    }

    /**
     * 获取敏捷数据版本
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getAgileVersion")
    public ApiResponse getAgileVersion(@RequestBody AgileDataApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getAgileVersion(apiRequest));
    }

    /**
     * 数据集1.0和指标-数据总结
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("getAgileDataSummarize")
    public ApiResponse getAgileDataSummarize(@RequestBody AgileDataApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(agileDataService.getAgileDataSummarize(apiRequest));
    }

    /**
     * 获取条件筛选后的DSL
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("getFilterAgileData")
    public ApiResponse getFilterAgileData(@RequestBody AgileDataFilterQueryDTO queryDTO) {
        EchoFilterData filterAgileData = agileDataService.getFilterAgileData(queryDTO);
        if (filterAgileData.getErrorMessage() != null) {
            return ApiResponse.buildError(filterAgileData.getErrorMessage());
        }
        return ApiResponse.buildOK().setData(filterAgileData);
    }

    /**
     * 归因分析-数据波动
     * @param queryDTO
     * @return
     */
    @PostMapping("getAttributionAnalysis")
    public ApiResponse getAttributionAnalysis(@RequestBody AgileDataAnalysisFluctuateQueryDTO queryDTO) {
        EchoAnalysisDataSummaryResultDTO attributionAnalysis = agileDataService.getAttributionAnalysis(queryDTO);
        if (BooleanUtils.isFalse(attributionAnalysis.getDataResult())) {
            return ApiResponse.buildError(attributionAnalysis.getMessage());
        }
        return ApiResponse.buildOK().setData(attributionAnalysis);
    }

    /**
     * 归因分析-获取维度归因信息
     * @param queryDTO
     * @return
     */
    @PostMapping("getAnalysisDataDimension")
    public ApiResponse getAnalysisDataDimension(@RequestBody AgileDataAnalysisFluctuateQueryDTO queryDTO) {
        EchoAnalysisDataDimensionResultDTO attributionAnalysis = agileDataService.getAnalysisDataDimension(queryDTO);
        if (BooleanUtils.isFalse(attributionAnalysis.getDataResult())) {
            return ApiResponse.buildError(attributionAnalysis.getMessage());
        }
        return ApiResponse.buildOK().setData(attributionAnalysis);
    }

    /**
     * 需求286790:查询应用功能权限(如：ppt生成等)
     * @param queryDTO
     * @return
     */
    @PostMapping("queryApplicationFunctionPermission")
    public ApiResponse queryApplicationFunctionPermission(@RequestBody AgileDataAnalysisFluctuateQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(agileDataService.queryApplicationFunctionPermission(queryDTO));
    }

    /**
     * 查询分析总结配置
     * @param queryDTO
     * @return
     */
    @PostMapping("getAnalysisConfigDataList")
    public ApiResponse getAnalysisConfigDataList(@RequestBody AgileDataAnalysisFluctuateQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(agileDataService.getAnalysisConfigDataList(queryDTO));
    }

}