package com.digiwin.mobile.mobileuibot.agileData.controller;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;
import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataPptService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.DigiwinAgileDataFileParsingResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 敏捷数据ppt需求专用Controller
 *
 * @author yanfeng
 * @date 2025/8/21
 */
@Validated
@RestController
@RequestMapping("/mobile/agileData/v2/ppt")
public class AgileDataPptController {

    @Autowired
    private IAgileDataPptService pptService;

    /**
     * PPT分析规划问句查询
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("getAgileDataFile")
    public ApiResponse getAgileDataFile(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.getAgileDataFile(queryDTO));
    }

    /**
     * 保存分析规划信息
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("saveAgileDataFile")
    public ApiResponse saveAgileDataFile(@RequestBody EchoAgileDataFileDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.saveAgileDataFile(queryDTO));
    }

    /**
     * 更新分析规划信息
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("updateAgileDataFile")
    public ApiResponse updateAgileDataFile(@RequestBody EchoAgileDataFileDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.updateAgileDataFile(queryDTO));
    }

    /**
     * 删除分析规划信息
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("deleteAgileDataFile")
    public ApiResponse deleteAgileDataFile(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.deleteAgileDataFile(queryDTO));
    }

    /**
     * 获取PPT文件列表
     * @param queryDTO
     * @return
     */
    @PostMapping("getPptFileList")
    public ApiResponse getPptFileList(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = pptService.getPptFileList(queryDTO);
        if (HttpStatus.OK.value() == result.getCode()) {
            return ApiResponse.buildOK().setData(result.getData());
        } else {
            return ApiResponse.buildError(result.getMsg());
        }
    }

    /**
     * 更新PPT文件名称
     * @param queryDTO
     * @return
     */
    @PostMapping("updatePptFileName")
    public ApiResponse updatePptFileName(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = pptService.updatePptFileName(queryDTO);
        if (HttpStatus.OK.value() == result.getCode()) {
            return ApiResponse.buildOK().setData(result.getData());
        } else {
            return ApiResponse.buildError(result.getMsg());
        }
    }

    /**
     * 删除PPT文件
     * @param queryDTO
     * @return
     */
    @PostMapping("deletePptFile")
    public ApiResponse deletePptFile(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = pptService.deletePptFile(queryDTO);
        if (HttpStatus.OK.value() == result.getCode()) {
            return ApiResponse.buildOK().setData(result.getData());
        } else {
            return ApiResponse.buildError(result.getMsg());
        }
    }

    /**
     * 上传PPT模版
     * @param queryDTO
     * @return
     */
    @PostMapping("uploadPptFile")
    public ApiResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = pptService.uploadPptFile(queryDTO);
        if (HttpStatus.OK.value() == result.getCode()) {
            return ApiResponse.buildOK().setData(result.getData());
        } else {
            return ApiResponse.buildError(result.getMsg());
        }
    }

    /**
     * 获取PPT转PDF链接
     * @param queryDTO
     * @return
     */
    @PostMapping("getPDFDmcShareUrl")
    public ApiResponse getPDFDmcShareUrl(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = pptService.getPDFDmcShareUrl(queryDTO);
        if (HttpStatus.OK.value() == result.getCode()) {
            return ApiResponse.buildOK().setData(result.getData());
        } else {
            return ApiResponse.buildError(result.getMsg());
        }
    }

    /**
     * 重新生成分析问句
     *
     * @param queryDTO
     * @return
     */
    @PostMapping("regenerateQuestion")
    public ApiResponse regenerateQuestion(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.regenerateQuestion(queryDTO));
    }

    /**
     * 生成PPT
     * @param queryDTO
     * @return
     */
    @PostMapping("generatePPT")
    public ApiResponse generatePPT(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData(pptService.generatePPT(queryDTO));
    }

    /**
     * 执行解析
     * @param queryDTO
     * @return
     */
    @PostMapping("executionParsing")
    public ApiResponse executionParsing(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        pptService.executionParsing(queryDTO);
        return ApiResponse.buildOK();
    }

}