package com.digiwin.mobile.mobileuibot.agileData.controller;

import com.digiwin.mobile.mobileuibot.agileData.sse.dto.AgileDadaSseChatReqDTO;
import com.digiwin.mobile.mobileuibot.agileData.sse.service.SseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

/**
 * 敏捷数据SSE控制器
 *
 * @author yanfeng
 * @date 2025/8/21
 */
@Slf4j
@RestController
@RequestMapping("/mobile/agileData/v2/sse")
public class AgileDataSseController {

    @Autowired
    private SseService service;

    /**
     * 移动端SSE通信接口
     *
     * @param queryDTO 查询参数
     * @return SseEmitter
     */
    @PostMapping("/sseChat")
    public SseEmitter sseChat(@RequestBody AgileDadaSseChatReqDTO queryDTO) {
        return service.sseChat(queryDTO);
    }

}