package com.digiwin.mobile.mobileuibot.agileData.dto;

import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：敏捷数据归因分析-数据波动入参</p>
 *
 * @Author: yanfeng
 * @Date: 2025/8/15
 */
@Data
public class AgileDataAnalysisFluctuateQueryDTO extends AgileDataApiRequest {

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 语义分析过程信息
     */
    private Map<String, Object> processStreamData;

    /**
     * 用户筛选维度条件
     */
    private List<AgileDataAnalysisData> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AgileDataAnalysisData> measurementData;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * AI输出结果SQL
     */
    private Map<String, Object> orgOutPutSql;

    /**
     * 分析参数
     */
    private Map<String, Object> analysisParams;
}