package com.digiwin.mobile.mobileuibot.agileData.service;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AdtGeneratePptResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AdtPptResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.DigiwinAgileDataFileParsingResponse;

/**
 * 敏捷数据PPT生成接口层
 *
 * @author yanfeng
 * @date 2025/6/12
 */
public interface IAgileDataPptService {

    /**
     * PPT分析规划问句查询
     *
     * @param queryDTO
     * @return
     */
    EchoAgileDataFileDTO getAgileDataFile(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 保存分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean saveAgileDataFile(EchoAgileDataFileDTO queryDTO);

    /**
     * 更新分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean updateAgileDataFile(EchoAgileDataFileDTO queryDTO);

    /**
     * 删除分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean deleteAgileDataFile(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 敏捷数据：查询我的ppt列表
     */
    DigiwinAgileDataFileParsingResponse getPptFileList(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：修改ppt文件名
     */
    DigiwinAgileDataFileParsingResponse updatePptFileName(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：删除ppt文件
     */
    DigiwinAgileDataFileParsingResponse deletePptFile(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：上传ppt文件
     * @param queryDTO
     * @return
     */
    DigiwinAgileDataFileParsingResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO);

    /**
     * 敏捷数据：获取pdf的dmc分享链接
     */
    DigiwinAgileDataFileParsingResponse getPDFDmcShareUrl(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 重新生成分析问句
     *
     * @param queryDTO
     * @return AdtPptResultDTO
     */
    AdtPptResultDTO regenerateQuestion(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 生成PPT
     *
     * @param queryDTO
     * @return AdtGeneratePptResultDTO
     */
    AdtGeneratePptResultDTO generatePPT(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 执行解析
     *
     * @param queryDTO
     */
    void executionParsing(AgileDataEchoPptQueryDTO queryDTO);
}