package com.digiwin.mobile.mobileuibot.agileData.service;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataAnalysisFluctuateQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AgileDataAdqApplicationFunctionPermissionResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AnalysisConfigData;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtDataSummarize;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtDataTableListRes;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtTablePreviewDataRes;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AdtTablePreviewDataRequest;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;

import java.util.List;
import java.util.Map;

/**
 * 敏捷数据接口层
 *
 * @author yanfeng
 * @date 2025/6/12
 */
public interface IAgileDataService {

    /**
     * 敏捷数据:获取数据集列表
     *
     * @param request
     * @return
     */
    DigiwinAdtDataTableListRes getTableList(AgileDataApiRequest request);

    /**
     * 敏捷数据:获取数据集预览
     *
     * @param request
     * @return
     */
    DigiwinAdtTablePreviewDataRes getTablePreviewData(AdtTablePreviewDataRequest request);

    /**
     * 保存用户习惯(比如追问开关)
     *
     * @param request
     * @return
     */
    Boolean saveUserHabitual(EchoUserDefineHabitualDTO request);

    /**
     * 获取用户习惯(比如追问开关)
     *
     * @param request
     * @return
     */
    EchoAgileDataUserDefine getUserHabitual(AgileDataApiRequest request);

    /**
     * 根据快照Id获取可转换图表列表（历史数据使用）
     *
     * @param request
     * @return
     */
    List<String> getTransList(AgileDataApiRequest request);

    /**
     * 获取敏捷数据版本
     *
     * @param request
     * @return
     */
    Map<String, Object> getAgileVersion(AgileDataApiRequest request);

    /**
     * 数据集1.0和指标-数据总结
     * @param request
     * @return
     */
    DigiwinAdtDataSummarize getAgileDataSummarize(AgileDataApiRequest request);

    /**
     * 获取条件筛选后的DSL
     * @param request
     * @return
     */
    EchoFilterData getFilterAgileData(AgileDataFilterQueryDTO request);

    /**
     * 归因分析-数据波动
     * @param request
     * @return
     */
    EchoAnalysisDataSummaryResultDTO getAttributionAnalysis(AgileDataAnalysisFluctuateQueryDTO request);

    /**
     *归因分析-获取维度归因信息
     * @param request
     * @return
     */
    EchoAnalysisDataDimensionResultDTO getAnalysisDataDimension(AgileDataAnalysisFluctuateQueryDTO request);

    /**
     * 需求286790:查询应用功能权限(如：ppt生成等)
     *
     * @param apiRequest
     * @return
     */
    AgileDataAdqApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(AgileDataApiRequest apiRequest);

    /**
     * 查询分析总结配置
     *
     * @param apiRequest 请求参数
     * @return 配置列表
     */
    AnalysisConfigData getAnalysisConfigDataList(AgileDataApiRequest apiRequest);

}