package com.digiwin.mobile.mobileuibot.agileData.service.impl;

import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataAutoAnalystService;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataDownLoadDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AgileDataAutoDataResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.AgileDataEchoAutoDataReportResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @date 2025/9/3
 * @author yanfeng
 */
@Service
public class IAgileDataAutoAnalystServiceImpl implements IAgileDataAutoAnalystService {

    @Autowired
    private DigiwinAdtProxyService digiwinAdtProxyService;

    @Autowired
    private DigiwinAgileDataEchoProxyService echoProxyService;

    @Override
    public AgileDataAutoDataResultDTO generateAutoAnalystReport(AgileDataAutoDataQueryDTO queryDTO) {
        return digiwinAdtProxyService.generateAutoAnalystReport(queryDTO);
    }

    @Override
    public AgileDataAutoDataDownLoadDTO autoDataDownLoad(AgileDataAutoDataQueryDTO queryDTO) {
        return digiwinAdtProxyService.autoDataDownLoad(queryDTO);
    }

    @Override
    public AgileDataEchoAutoDataReportResultDTO getAutoDataReportStatus(AgileDataAutoDataQueryDTO request) {
        return echoProxyService.getAutoDataReportStatus(request);
    }
}