package com.digiwin.mobile.mobileuibot.agileData.service.impl;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;
import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataPptService;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AdtGeneratePptResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.AdtPptResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyPptService;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.AgileDataFileParsingProxyService;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.DigiwinAgileDataFileParsingResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ppt生成 服务实现类
 * @date 2025/8/21
 * @author yanfeng
 */
@Slf4j
@Service
public class IAgileDataPptServiceImpl implements IAgileDataPptService {

    @Autowired
    private DigiwinAgileDataEchoProxyPptService pptService;

    @Autowired
    private AgileDataFileParsingProxyService fileParsingService;

    @Autowired
    private DigiwinAdtProxyService adtProxyService;

    @Override
    public EchoAgileDataFileDTO getAgileDataFile(AgileDataEchoPptQueryDTO queryDTO) {
        return pptService.getAgileDataFile(queryDTO);
    }

    @Override
    public Boolean saveAgileDataFile(EchoAgileDataFileDTO queryDTO) {
        return pptService.saveAgileDataFile(queryDTO);
    }

    @Override
    public Boolean updateAgileDataFile(EchoAgileDataFileDTO queryDTO) {
        return pptService.updateAgileDataFile(queryDTO);
    }

    @Override
    public Boolean deleteAgileDataFile(AgileDataEchoPptQueryDTO queryDTO) {
        return pptService.deleteAgileDataFile(queryDTO);
    }

    @Override
    public DigiwinAgileDataFileParsingResponse getPptFileList(AgileDataFileParsingPptQueryDTO queryDTO) {
        queryDTO.setToken(queryDTO.getIamUserToken());
        return fileParsingService.getPptFileList(queryDTO);

    }

    @Override
    public DigiwinAgileDataFileParsingResponse updatePptFileName(AgileDataFileParsingPptQueryDTO queryDTO) {
        queryDTO.setToken(queryDTO.getIamUserToken());
        return fileParsingService.updatePptFileName(queryDTO);
    }

    @Override
    public DigiwinAgileDataFileParsingResponse deletePptFile(AgileDataFileParsingPptQueryDTO queryDTO) {
        queryDTO.setToken(queryDTO.getIamUserToken());
        return fileParsingService.deletePptFile(queryDTO);
    }

    @Override
    public DigiwinAgileDataFileParsingResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO) {
        queryDTO.setToken(queryDTO.getIamUserToken());
        return fileParsingService.uploadPptFile(queryDTO);
    }

    @Override
    public DigiwinAgileDataFileParsingResponse getPDFDmcShareUrl(AgileDataFileParsingPptQueryDTO queryDTO) {
        queryDTO.setToken(queryDTO.getIamUserToken());
        return fileParsingService.getPDFDmcShareUrl(queryDTO);
    }

    @Override
    public AdtPptResultDTO regenerateQuestion(AgileDataEchoPptQueryDTO queryDTO) {
        return adtProxyService.regenerateQuestion(queryDTO);
    }

    @Override
    public AdtGeneratePptResultDTO generatePPT(AgileDataEchoPptQueryDTO queryDTO) {
        return adtProxyService.generatePPT(queryDTO);
    }

    @Override
    public void executionParsing(AgileDataEchoPptQueryDTO queryDTO) {
        adtProxyService.executionParsing(queryDTO);
    }
}