package com.digiwin.mobile.mobileuibot.agileData.service.impl;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataAnalysisFluctuateQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataService;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.adq.AgileDataAdqProxyService;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AgileDataAdqApplicationFunctionPermissionResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AnalysisConfigData;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtDataSummarize;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtDataTableListRes;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtTablePreviewDataRes;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AdtTablePreviewDataRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.*;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 敏捷数据接口实现类
 *
 * @author yanfeng
 * @date 2025/6/12
 */
@Slf4j
@Service
public class IAgileDataServiceImpl implements IAgileDataService {

    @Autowired
    private DigiwinAdtProxyService adtProxyService;

    @Autowired
    private DigiwinAgileDataEchoProxyService echoProxyService;

    @Autowired
    private AgileDataAdqProxyService adqProxyService;

    @Override
    public DigiwinAdtDataTableListRes getTableList(AgileDataApiRequest request) {
        return adtProxyService.getTableList(request);
    }

    @Override
    public DigiwinAdtTablePreviewDataRes getTablePreviewData(AdtTablePreviewDataRequest request) {
        return adtProxyService.getTablePreviewData(request);
    }

    @Override
    public Boolean saveUserHabitual(EchoUserDefineHabitualDTO request) {
        return echoProxyService.saveUserHabitual(request);
    }

    @Override
    public EchoAgileDataUserDefine getUserHabitual(AgileDataApiRequest request) {
        return echoProxyService.getUserHabitual(request);
    }

    @Override
    public List<String> getTransList(AgileDataApiRequest request) {
        return adtProxyService.getTransList(request);
    }

    @Override
    public Map<String, Object> getAgileVersion(AgileDataApiRequest request) {
        return adtProxyService.getAgileVersion(request);
    }

    @Override
    public DigiwinAdtDataSummarize getAgileDataSummarize(AgileDataApiRequest request) {
        return adtProxyService.getAgileDataSummarize(request);
    }

    @Override
    public EchoFilterData getFilterAgileData(AgileDataFilterQueryDTO request) {
        return echoProxyService.getFilterAgileData(request);
    }

    @Override
    public EchoAnalysisDataSummaryResultDTO getAttributionAnalysis(AgileDataAnalysisFluctuateQueryDTO request) {
        return echoProxyService.getAttributionAnalysis(request);
    }

    @Override
    public EchoAnalysisDataDimensionResultDTO getAnalysisDataDimension(AgileDataAnalysisFluctuateQueryDTO request) {
        return echoProxyService.getAnalysisDataDimension(request);
    }

    @Override
    public AgileDataAdqApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(AgileDataApiRequest apiRequest) {
        return adqProxyService.queryApplicationFunctionPermission(apiRequest);
    }

    @Override
    public AnalysisConfigData getAnalysisConfigDataList(AgileDataApiRequest apiRequest) {
        return adqProxyService.getAnalysisConfigDataList(apiRequest);
    }
}