package com.digiwin.mobile.mobileuibot.agileData.sse.domain;


import com.digiwin.mobile.mobileuibot.agileData.sse.dto.ADEScencDTO;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.QuerySchemaReqDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * adt 上下文
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AthenaMessageEvent {
    /**
     * 消息内容
     */
    private Map<String, Object> msgBody;
    /**
     * 扩展消息
     */
    private Map<String, Object> msgExt;

    private String userId;
    private String userName;
    private String token;
    private String tenantId;
    private String tenantName;

    /**
     * 多语言标识
     */
    private String lang;

    /**
     * 端
     */
    private String terminal;

    /**
     * 提问时间
     */
    private LocalDateTime askTime;

    /**
     * 消息类型
     * 0.单场景消息
     * 1.多场景消息
     * 2.debug消息
     * 3.多目标
     * 4.param调试模式
     * 5.多应用
     * 6.多指标
     */
    private String messageType;

    /**
     * 组装问句
     */
    private String combinationQuestion;

    /**
     * generateSerialNo action 唯一序列
     */
    private Long generateSerialNo;

    /**
     * 语义入参
     */
    private QuerySchemaReqDTO querySchemaReqDTO;

    /**
     * question 问句
     */
    private String question;

    /**
     * 语义版本
     */
    private String version;

    /**
     * 多场景
     */
    private List<Map<String, Object>> scenes;

    /**
     * 多目标
     */
    private List<Map<String, Object>> targets;

    /**
     * 多应用
     */
    private List<Map<String, Object>> applicationList;

    /**
     * 多指标
     */
    private List<Map<String, Object>> metricList;

    /**
     * dataset
     */
    private List<Map<String, Object>> datasetList;

    /**
     * 计费应用id
     */
    private String appCode;

    /**
     * 计费应用id
     */
    private String appName;

    /**
     * 计费流量id
     */
    private String goodsCode;

    /**
     * 是否走计费业务
     */
    private boolean isCost;

    /**
     * 是否为订阅消息
     */
    private boolean isSubscribe;

    /**
     * 是否发送娜娜消息
     */
    private boolean isSendNana;
    /**
     * ade 入参
     */
    private ADEScencDTO adeScencDTO;

    /**
     * 链路id
     */
    private String ptxId;

    /**
     * 语义新增上下文字段
     * questionUnderstand
     */
    private String questionUnderstand;

    /**
     * 语义上下文sessionId
     */
    private String sessionId;

    /**
     * debug 模式 标识
     */

    private boolean isDebug;

    /**
     * dataflow/metric
     */
    private String method;

    /**
     * 娜娜助理编码
     */
    private String asaCode;

    /**
     * 多产品线
     */
    private List<Map<String, Object>> productLineInfo;

    /**
     * 是否可以删除订阅
     */
    private boolean undeletable;

    /**
     * 数据来源
     * 订阅/看板/问句/调试工具
     */
    private String sourceCode;

    /**
     * 数据来源名称
     * 订阅/看板/问句/调试工具
     */
    private String sourceName;

    /**
     * 是否从echo获取消息
     */
    private boolean isGetMessageInfo;

    /**
     * 是否为sse消息
     */
    private boolean isSseMessage;


    private String sseCallId;
    /**
     * sse
     */
    private SseEmitter sseEmitter;

    /**
     * 时间戳
     */
    private long getQuerySchemaTook;

    /**
     * 数据结果
     */
    private Map<String, Object> historyData;

    /**
     * token量
     */
    private Integer tokenSize;

    /**
     * 是否超过token量,超过无historyData
     */
    private Boolean exceedTokenThreshold;

    /**
     * 2.猜你想问/1.相关推荐标识
     */
    private Integer answerResult;

    /**
     * 猜你想问/相关推荐集合
     */
    private List<String> sentences;

    /**
     * 数据流版本
     * V1,V2
     */
    private String productVersion;


    /**
     * 数据集id
     */
    private List<String> datasetIdList;

    /**
     * 追问标识
     */
    private Boolean probe;

    /**
     * 精准：PrecisionMode，自由：FreeMode
     */
    private String conversationMode;

    /**
     * 数据总结是否超过token
     */
    private Boolean exceedSummarizeSize;

    /**
     * 语义问句分析过程
     */
    private Map<String, Object> processStreamData;

    /**
     * 大模型输出sql
     */
    private Map<String, Object> orgOutPutSql;

    /**
     * 流式输出版本标识 V1 V2
     */
    private String sseProductVersion;

    /**
     * 技能标识
     */
    private String skillType;

    /**
     * 技能动作
     */
    private String action;

    private AthenaMessageEvent init() {

        return this;
    }

}