package com.digiwin.mobile.mobileuibot.agileData.sse.domain;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Data
@JsonPropertyOrder({"event", "data"})
public class EventData implements Serializable {

    @NotBlank()
    private String eventId = UUID.randomUUID().toString().replace("-", "");
    @NotBlank()
    private String event;

    private EventMessage data;

    private Long eventTime = System.currentTimeMillis();


    public EventData() {
    }

    ;

    public EventData(String event) {
        this.event = event;
    }

    public EventData(String event, EventMessage data) {
        this.event = event;
        this.data = data;
    }

    public EventData(String event, String type, String messageType, String answerText) {
        this.event = event;
        EventMessage eventMessage = new EventMessage();
        eventMessage.setMessage(answerText);
        eventMessage.setType(type);
        eventMessage.setMessage_type(messageType);
        this.data = eventMessage;
    }

    @Data
    public static class EventMessage implements Serializable {

        @NotBlank()
        private String type;

        private String message_type;

        private Object message;

        private String status;

        private ExtraInfo extra_info;

        private Integer tool_type;

        private String message_id;

        private String conversation_id;

        public EventMessage() {
        }

        @Data
        public static class ExtraInfo implements Serializable {

            private String call_id;

            private String tool_type;
        }

        public EventMessage(String type, String message_type, String message) {
            this.type = type;
            this.message_type = message_type;
            this.message = message;
        }

        public static EventMessage builderNewEventMessage(String type, Object message, AthenaMessageEvent event) {
            EventMessage eventMessage = new EventMessage();
            ExtraInfo extraInfo = new ExtraInfo();
            extraInfo.setCall_id(new EventData().eventId);
            extraInfo.setTool_type("agileData_tool");
            eventMessage.setExtra_info(extraInfo);
            eventMessage.setMessage_type("text");
            eventMessage.setStatus("available");
            eventMessage.setType(type);
            eventMessage.setMessage(message);
            event.setSseCallId(extraInfo.getCall_id());
            return eventMessage;
        }

        public static EventMessage builderMessage(String type, Object message, String eventId) {
            EventMessage eventMessage = new EventMessage();
            ExtraInfo extraInfo = new ExtraInfo();
            extraInfo.setCall_id(eventId);
            extraInfo.setTool_type("agileData_tool");
            eventMessage.setExtra_info(extraInfo);
            eventMessage.setMessage_type("text");
            eventMessage.setType(type);
            eventMessage.setMessage(message);
            return eventMessage;
        }

        public static EventMessage builderMessageClose(String type, String eventId, String status) {
            EventMessage eventMessage = new EventMessage();
            ExtraInfo extraInfo = new ExtraInfo();
            extraInfo.setCall_id(eventId);
            extraInfo.setTool_type("agileData_tool");
            eventMessage.setExtra_info(extraInfo);
            eventMessage.setMessage_type("text");
            eventMessage.setType(type);
            if (StringUtils.isEmpty(status)) {
                status = "success";
            }
            eventMessage.setMessage("");
            eventMessage.setStatus(status);
            return eventMessage;
        }

        public static EventMessage builderAnswerMessage(Object message) {
            EventMessage eventMessage = new EventMessage();
            eventMessage.setType("answer");
            eventMessage.setMessage_type("card");
            eventMessage.setMessage(message);
            return eventMessage;
        }

        public static EventMessage builderAnswerTextMessage(Object message) {
            EventMessage eventMessage = new EventMessage();
            eventMessage.setType("answer");
            eventMessage.setMessage_type("text");
            eventMessage.setMessage(message);
            return eventMessage;
        }


        /**
         * 2.0 语义流式开启会话
         * @param type functionCall
         * @param message 语义输出
         * @param event 上下文
         * @return message
         */
        public static EventMessage builderNewEventMessageV2(String type, Object message, AthenaMessageEvent event) {
            EventMessage eventMessage = new EventMessage();
            Map<String, Object> messageObj = new HashMap<>();
            ExtraInfo extraInfo = new ExtraInfo();
            extraInfo.setCall_id(new EventData().eventId);
            messageObj.put("message_type", "text");
            messageObj.put("status", "available");
            messageObj.put("extra_info", extraInfo);
            messageObj.put("title", message);
            Map<String, Object> content = new HashMap<>();
            content.put("arguments", new HashMap<>());
            messageObj.put("content", content);
            eventMessage.setMessage(messageObj);
            eventMessage.setMessage_id(event.getGenerateSerialNo().toString());
            eventMessage.setConversation_id(event.getSessionId());
            eventMessage.setType(type);
            event.setSseCallId(extraInfo.getCall_id());
            return eventMessage;
        }

        public static EventMessage builderMessageV2(JSONObject res, String eventId) {
            EventMessage eventMessage = new EventMessage();
            String defaultType = "function_answer";
            if (res == null) {
                eventMessage.setType(defaultType);
                ExtraInfo extraInfo = new ExtraInfo();
                extraInfo.setCall_id(eventId);
                eventMessage.setExtra_info(extraInfo);
                Map<String, Object> messageObj = new HashMap<>();
                messageObj.put("message_type", "text");
                messageObj.put("extra_info", extraInfo);
                messageObj.put("title", "");
                messageObj.put("content", "");
                eventMessage.setMessage(messageObj);
                return eventMessage;
            }

            String type = res.getString("type");
            if (type == null) {
                type = defaultType;
            }
            eventMessage.setType(type);

            JSONObject messageObj = res.getJSONObject("message");
            if (messageObj != null) {
                eventMessage.setMessage(messageObj);
                ExtraInfo extraInfo = parseExtraInfo(messageObj.getJSONObject("extra_info"), eventId);
                if (extraInfo != null) {
                    eventMessage.setExtra_info(extraInfo);
                }
            }

            if (eventMessage.getExtra_info() == null) {
                ExtraInfo extraInfo = parseExtraInfo(res.getJSONObject("extra_info"), eventId);
                if (extraInfo != null) {
                    eventMessage.setExtra_info(extraInfo);
                }
            }

            if (eventMessage.getExtra_info() == null) {
                ExtraInfo extraInfo = new ExtraInfo();
                extraInfo.setCall_id(eventId);
                eventMessage.setExtra_info(extraInfo);
            }

            if (eventMessage.getMessage() == null) {
                Map<String, Object> messageObjFallback = new HashMap<>();
                messageObjFallback.put("message_type", "text");
                messageObjFallback.put("extra_info", eventMessage.getExtra_info());
                messageObjFallback.put("title", "");
                messageObjFallback.put("content", res.get("message"));
                eventMessage.setMessage(messageObjFallback);
            }

            return eventMessage;
        }

        private static ExtraInfo parseExtraInfo(JSONObject extraInfoObj, String eventId) {
            if (extraInfoObj == null) {
                return null;
            }
            ExtraInfo extraInfo = new ExtraInfo();
            String callId = extraInfoObj.getString("call_id");
            if (callId == null) {
                callId = eventId;
            }
            extraInfo.setCall_id(callId);
            extraInfo.setTool_type(extraInfoObj.getString("tool_type"));
            return extraInfo;
        }

        public static EventMessage builderMessageCloseV2(String type, String eventId, String status) {
            EventMessage eventMessage = new EventMessage();
            eventMessage.setType(type);
            ExtraInfo extraInfo = new ExtraInfo();
            extraInfo.setCall_id(eventId);
            eventMessage.setExtra_info(extraInfo);

            Map<String, Object> messageObj = new HashMap<>();
            messageObj.put("message_type", "text");
            messageObj.put("extra_info", extraInfo);
            Map<String, Object> content = new HashMap<>();
            content.put("title", "");
            messageObj.put("content", content);
            if (StringUtils.isEmpty(status)) {
                status = "success";
            }
            messageObj.put("status", status);
            eventMessage.setMessage(messageObj);
            return eventMessage;
        }
    }
}