package com.digiwin.mobile.mobileuibot.agileData.sse.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.OkHttpUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

import java.util.concurrent.TimeUnit;

/**
 * sse客户端入参构建
 */
@Slf4j
public class EventStreamClient {

    public static ConnectionPool connectionPool = new ConnectionPool(100, 5, TimeUnit.MINUTES);

    public static void executeSSE(AthenaMessageEvent event, String url,
                                  EventSourceListener eventSourceListener,
                                  JSONObject requestBody, SSEBaseEvent sseBaseEvent) {
        sseBaseEvent.getEvent().setGetQuerySchemaTook(System.currentTimeMillis());
        MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
        RequestBody formBody = RequestBody.create(mediaType, requestBody.toJSONString());
        Request.Builder requestBuilder = getRequestBuilder(event);
        requestBuilder.tag(JSONObject.class, requestBody);
        log.info("agileData_mobile_{}_{}_{}_{}_{}:获取用户提问，adt识别，adt入参：\n{}",
                event.getUserId(), event.getUserName()
                , event.getTenantId(), event.getTenantName(), event.getQuestion(), JsonUtil.javaObjectToJsonString(requestBody));
        Request request = requestBuilder.url(url).post(formBody).build();
        EventSource.Factory factory = EventSources.createFactory(OkHttpUtil.getInstance());
        try {
            factory.newEventSource(request, eventSourceListener);
        } catch (Exception e) {
            log.error("Failed to create event source for SSE connection", e);
            throw e;
        }
    }

    private static Request.Builder getRequestBuilder(AthenaMessageEvent event) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.addHeader("content-type", "application/json");
        requestBuilder.addHeader(AgileDataConstant.TOKEN, event.getToken());
        requestBuilder.addHeader(AgileDataConstant.IAM_USER_TOKEN, event.getToken());
        requestBuilder.addHeader(AgileDataConstant.IAM_APP_TOKEN, AgileDataConstant.IAM_APP_TOKEN_VALUE);
        requestBuilder.addHeader(AgileDataConstant.LOCALE, event.getLang());
        requestBuilder.addHeader(AgileDataConstant.ROUTER_KEY, event.getTenantId());
        requestBuilder.addHeader(AgileDataConstant.PTX_ID, event.getPtxId());
        requestBuilder.addHeader(AgileDataConstant.MESSAGE_ID, String.valueOf(event.getGenerateSerialNo()));
        requestBuilder.addHeader(AgileDataConstant.USER_ID, event.getUserId());
        return requestBuilder;
    }

}