package com.digiwin.mobile.mobileuibot.agileData.sse.domain;


import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Consumer;

/**
 * SSE异常回调组件
 */
@Slf4j
public class SseEmitterErrorCallbackComponent implements Consumer<Throwable> {


    private SSEBaseEvent sseBaseEvent;

    public SseEmitterErrorCallbackComponent(SSEBaseEvent sseBaseEvent) {
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void accept(Throwable throwable) {
        log.info("当前对话监听到异常信息，信息ID:{},错误信息:{}", sseBaseEvent.getId(), throwable.getMessage());
        //标记消息结束
        sseBaseEvent.setIsOver(true);
        //语义SSE监听取消
        if (!sseBaseEvent.getIsScrumOver()) {
            sseBaseEvent.getScrumEventSource().cancel();
        }
        //推送娜娜结束事件
        EventData doneData = new EventData(SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send(sseBaseEvent.getAniaEmitter(), doneData);
    }
}