package com.digiwin.mobile.mobileuibot.agileData.sse.domain;


import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * SSE超时监听回调组件
 */
@Slf4j
public class SseEmitterTimeOutCallbackComponent implements Runnable {

    private SSEBaseEvent sseBaseEvent;

    public SseEmitterTimeOutCallbackComponent(SSEBaseEvent sseBaseEvent) {
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void run() {
        log.info("当前对话执行时间过长，进行阻断，信息ID:{}", sseBaseEvent.getId());
        //标记消息结束
        sseBaseEvent.setIsOver(true);
        //语义SSE监听取消
        if (!sseBaseEvent.getIsScrumOver()) {
            sseBaseEvent.getScrumEventSource().cancel();
        }
        //推送超时提示消息
        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
        String answer = localeService.getLanguageValue(sseBaseEvent.getLang(), "抱歉，您请求访问的知识库连接异常，请稍后再试，如果问题持续，请联系您的租户管理员或顾问咨询。");
        EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),
                SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(),
                SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
        SseEmitterUtils.send(sseBaseEvent.getAniaEmitter(), eventData);
        //推送娜娜结束事件
        EventData doneData = new EventData(SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send(sseBaseEvent.getAniaEmitter(), doneData);
    }
}