package com.digiwin.mobile.mobileuibot.agileData.sse.dto;

import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
public class AgileDadaSseChatReqDTO extends AgileDataApiRequest {

    /**
     * 助理ID
     */
    private String assistantId;

    /**
     * sessionId
     */
    private String conversationId;

    private String messageId;

    /**
     * 消息体
     */
    private Message message;

    @Data
    public static class Message {

        /**
         * 文本输入的内容
         */
        private String content;

        /**
         * 入参
         */
        private Map<String, Object> extData;

        /**
         * 2.0 messageId
         */
        private String messageId;

    }
}