package com.digiwin.mobile.mobileuibot.agileData.sse.dto;

import com.digiwin.mobile.mobileuibot.agileData.enums.SseMessageType;
import lombok.Data;

import java.util.List;
import java.util.Map;

/*
  B娜调processMessage接口入参
 */
@Data
public class AthenaMessageDTO {
    /**
     * 意图
     */
    private String intent;
    /**
     * 消息编号
     */
    private String msgidServer;
    /**
     * 消息类型
     * TEXT(文本消息), CUSTOM(自定义消息)
     */
    private SseMessageType msgType;
    /**
     * 消息内容
     */
    private Map<String, Object> msgBody;
    /**
     * 在confirmIntent时回传的附加信息  暂时版本不需要
     */
    private Map<String, Object> attachInfo;
    /**
     * 扩展消息
     */
    private Map<String, Object> msgExt;
    /**
     * 客户端消息ID
     */
    private String msgidClient;
    /**
     * 消息发送时间
     */
    private String msgTimestamp;

    /**
     * 上下文sessionId
     */
    private Integer sessionId;

    /**
     * 娜娜融合 上下⽂组合消息
     */
    private String combinationMsg;

    /***
     * 娜娜融合 指标代号
     */
    private List<String> intentCode;

    /***
     * 娜娜助理编码
     */
    private String asaCode;

    /***
     * 应用编码
     */
    private String appCode;

    /**
     * 2.0 段轮会话id
     */
    private String sectionId;

    /**
     * 2.0 消息id
     */
    private String messageId;

    /**
     * 2.0 会话id
     */
    private String conversationId;
}